/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Charsets;
import cpw.mods.fml.common.FMLLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class LanguageRegistry {
    private static final LanguageRegistry INSTANCE = new LanguageRegistry();
    private Map<String, Properties> modLanguageData = new HashMap<String, Properties>();

    public static LanguageRegistry instance() {
        return INSTANCE;
    }

    public String getStringLocalization(String key) {
        return this.getStringLocalization(key, bn.a().c());
    }

    public String getStringLocalization(String key, String lang) {
        String localizedString = "";
        Properties langPack = this.modLanguageData.get(lang);
        if (langPack != null && langPack.getProperty(key) != null) {
            localizedString = langPack.getProperty(key);
        }
        return localizedString;
    }

    public void addStringLocalization(String key, String value) {
        this.addStringLocalization(key, "en_US", value);
    }

    public void addStringLocalization(String key, String lang, String value) {
        Properties langPack = this.modLanguageData.get(lang);
        if (langPack == null) {
            langPack = new Properties();
            this.modLanguageData.put(lang, langPack);
        }
        langPack.put(key, value);
    }

    public void addStringLocalization(Properties langPackAdditions) {
        this.addStringLocalization(langPackAdditions, "en_US");
    }

    public void addStringLocalization(Properties langPackAdditions, String lang) {
        Properties langPack = this.modLanguageData.get(lang);
        if (langPack == null) {
            langPack = new Properties();
            this.modLanguageData.put(lang, langPack);
        }
        if (langPackAdditions != null) {
            langPack.putAll((Map<?, ?>)langPackAdditions);
        }
    }

    public static void reloadLanguageTable() {
        String lang = bn.a().c();
        bn.a().d = null;
        bn.a().a(lang);
    }

    public void addNameForObject(Object objectToName, String lang, String name) {
        String objectName;
        if (objectToName instanceof up) {
            objectName = ((up)objectToName).a();
        } else if (objectToName instanceof amq) {
            objectName = ((amq)objectToName).a();
        } else if (objectToName instanceof ur) {
            objectName = ((ur)objectToName).b().d((ur)objectToName);
        } else {
            throw new IllegalArgumentException(String.format("Illegal object for naming %s", objectToName));
        }
        objectName = objectName + ".name";
        this.addStringLocalization(objectName, lang, name);
    }

    public static void addName(Object objectToName, String name) {
        LanguageRegistry.instance().addNameForObject(objectToName, "en_US", name);
    }

    public void loadLanguageTable(Properties languagePack, String lang) {
        Properties langPack;
        Properties usPack = this.modLanguageData.get("en_US");
        if (usPack != null) {
            languagePack.putAll((Map<?, ?>)usPack);
        }
        if ((langPack = this.modLanguageData.get(lang)) == null) {
            return;
        }
        languagePack.putAll((Map<?, ?>)langPack);
    }

    public void loadLocalization(String localizationFile, String lang, boolean isXML) {
        this.loadLocalization(this.getClass().getResource(localizationFile), lang, isXML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLocalization(URL localizationFile, String lang, boolean isXML) {
        InputStream langStream = null;
        Properties langPack = new Properties();
        try {
            langStream = localizationFile.openStream();
            if (isXML) {
                langPack.loadFromXML(langStream);
            } else {
                langPack.load(new InputStreamReader(langStream, Charsets.UTF_8));
            }
            this.addStringLocalization(langPack, lang);
        }
        catch (IOException e2) {
            FMLLog.log(Level.SEVERE, e2, "Unable to load localization from file %s", localizationFile);
        }
        finally {
            try {
                if (langStream != null) {
                    langStream.close();
                }
            }
            catch (IOException ex2) {}
        }
    }
}

