/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;

public class Property {
    private String name;
    public String value;
    public String comment;
    public String[] valueList;
    private final boolean wasRead;
    private final boolean isList;
    private final Type type;

    public Property() {
        this.wasRead = false;
        this.type = null;
        this.isList = false;
    }

    public Property(String name, String value, Type type) {
        this(name, value, type, false);
    }

    Property(String name, String value, Type type, boolean read) {
        this.setName(name);
        this.value = value;
        this.type = type;
        this.wasRead = read;
        this.isList = false;
    }

    public Property(String name, String[] values, Type type) {
        this(name, values, type, false);
    }

    Property(String name, String[] values, Type type, boolean read) {
        this.setName(name);
        this.type = type;
        this.valueList = values;
        this.wasRead = read;
        this.isList = true;
    }

    public int getInt() {
        return this.getInt(-1);
    }

    public int getInt(int _default) {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e2) {
            return _default;
        }
    }

    public boolean isIntValue() {
        try {
            Integer.parseInt(this.value);
            return true;
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }

    public boolean getBoolean(boolean _default) {
        if (this.isBooleanValue()) {
            return Boolean.parseBoolean(this.value);
        }
        return _default;
    }

    public boolean isBooleanValue() {
        return "true".equals(this.value.toLowerCase()) || "false".equals(this.value.toLowerCase());
    }

    public boolean isDoubleValue() {
        try {
            Double.parseDouble(this.value);
            return true;
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }

    public double getDouble(double _default) {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e2) {
            return _default;
        }
    }

    public int[] getIntList() {
        ArrayList<Integer> nums = new ArrayList<Integer>();
        for (String value : this.valueList) {
            try {
                nums.add(Integer.parseInt(value));
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
        }
        int[] primitives = new int[nums.size()];
        for (int i2 = 0; i2 < nums.size(); ++i2) {
            primitives[i2] = (Integer)nums.get(i2);
        }
        return primitives;
    }

    public boolean isIntList() {
        for (String value : this.valueList) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e2) {
                return false;
            }
        }
        return true;
    }

    public boolean[] getBooleanList() {
        ArrayList<Boolean> values = new ArrayList<Boolean>();
        for (String value : this.valueList) {
            try {
                values.add(Boolean.parseBoolean(value));
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
        }
        boolean[] primitives = new boolean[values.size()];
        for (int i2 = 0; i2 < values.size(); ++i2) {
            primitives[i2] = (Boolean)values.get(i2);
        }
        return primitives;
    }

    public boolean isBooleanList() {
        for (String value : this.valueList) {
            if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) continue;
            return false;
        }
        return true;
    }

    public double[] getDoubleList() {
        ArrayList<Double> values = new ArrayList<Double>();
        for (String value : this.valueList) {
            try {
                values.add(Double.parseDouble(value));
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
        }
        double[] primitives = new double[values.size()];
        for (int i2 = 0; i2 < values.size(); ++i2) {
            primitives[i2] = (Double)values.get(i2);
        }
        return primitives;
    }

    public boolean isDoubleList() {
        for (String value : this.valueList) {
            try {
                Double.parseDouble(value);
            }
            catch (NumberFormatException e2) {
                return false;
            }
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean wasRead() {
        return this.wasRead;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isList() {
        return this.isList;
    }

    public static enum Type {
        STRING,
        INTEGER,
        BOOLEAN,
        DOUBLE;

        private static Type[] values;

        public static Type tryParse(char id) {
            for (int x2 = 0; x2 < values.length; ++x2) {
                if (values[x2].getID() != id) continue;
                return values[x2];
            }
            return STRING;
        }

        public char getID() {
            return this.name().charAt(0);
        }

        static {
            values = new Type[]{STRING, INTEGER, BOOLEAN, DOUBLE};
        }
    }
}

