/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.NEIClientUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class FastTransferManger {
    public LinkedList slotZones = new LinkedList();
    public HashMap slotZoneMap = new HashMap();

    private void generateSlotMap(rq container, ur stack) {
        stack = stack.l();
        stack.a = 1;
        int slotNo = 0;
        while (slotNo < container.c.size()) {
            if (!this.slotZoneMap.containsKey(slotNo) && container.a(slotNo).a(stack)) {
                HashSet connectedSlots = new HashSet();
                this.findConnectedSlots(container, slotNo, connectedSlots);
                LinkedList zoneSlots = new LinkedList(connectedSlots);
                Collections.sort(zoneSlots, new SlotPositionComparator(container));
                this.slotZones.add(zoneSlots);
                Iterator iterator = zoneSlots.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    this.slotZoneMap.put(i, this.slotZones.size() - 1);
                }
            }
            ++slotNo;
        }
    }

    private void findConnectedSlots(rq container, int slotNo, HashSet connectedSlots) {
        connectedSlots.add(slotNo);
        sr slot = container.a(slotNo);
        int threshold = 18;
        int i = 0;
        while (i < container.c.size()) {
            if (!connectedSlots.contains(i)) {
                sr slot1 = container.a(i);
                if (Math.abs(slot.h - slot1.h) <= 18 && Math.abs(slot.i - slot1.i) <= 18) {
                    this.findConnectedSlots(container, i, connectedSlots);
                }
            }
            ++i;
        }
    }

    public static int findSlotWithItem(rq container, ur teststack) {
        int slotNo = 0;
        while (slotNo < container.c.size()) {
            ur stack = container.a(slotNo).c();
            if (stack != null && NEIClientUtils.areStacksSameType(stack, teststack)) {
                return slotNo;
            }
            ++slotNo;
        }
        return -1;
    }

    public static void clearSlots(rq container) {
        int slotNo = 0;
        while (slotNo < container.c.size()) {
            ((sr)container.c.get(slotNo)).c(null);
            ++slotNo;
        }
    }

    public void performMassTransfer(avf window, int fromSlot, int toSlot, ur heldStack) {
        this.generateSlotMap(window.d, heldStack);
        Integer fromZone = (Integer)this.slotZoneMap.get(fromSlot);
        Integer toZone = (Integer)this.slotZoneMap.get(toSlot);
        if (fromZone == null || toZone == null || fromZone == toZone) {
            return;
        }
        if (NEIClientUtils.getHeldItem() != null && !NEIClientUtils.areStacksSameType(heldStack, NEIClientUtils.getHeldItem())) {
            return;
        }
        if (!this.fillZoneWithHeldItem(window, toZone)) {
            return;
        }
        Iterator iterator = ((LinkedList)this.slotZones.get(fromZone)).iterator();
        while (iterator.hasNext()) {
            int transferFrom = (Integer)iterator.next();
            ur transferStack = window.d.a(transferFrom).c();
            if (!NEIClientUtils.areStacksSameType(heldStack, transferStack)) continue;
            FastTransferManger.clickSlot(window, transferFrom);
            if (this.fillZoneWithHeldItem(window, toZone)) continue;
            FastTransferManger.clickSlot(window, transferFrom);
            return;
        }
    }

    public int findShiftClickDestinationSlot(rq container, int fromSlot) {
        LinkedList save = this.saveContainer(container);
        sr slot = container.a(fromSlot);
        ur stack = slot.c();
        if (stack == null) {
            return -1;
        }
        stack.a = 1;
        slot.c(stack.l());
        LinkedList compareBefore = this.saveContainer(container);
        container.a(fromSlot, 0, 1, (qx)NEIClientUtils.mc().g);
        LinkedList compareAfter = this.saveContainer(container);
        try {
            int i = 0;
            while (i < compareBefore.size()) {
                ur after;
                ur before;
                if (i != fromSlot && !NEIClientUtils.areStacksIdentical(before = (ur)compareBefore.get(i), after = (ur)compareAfter.get(i)) && after != null && (before == null && NEIClientUtils.areStacksSameType(stack, after) || NEIClientUtils.areStacksSameType(stack, after) && after.a - before.a > 0)) {
                    int n = i;
                    return n;
                }
                ++i;
            }
            return -1;
        }
        finally {
            this.restoreContainer(container, save);
        }
    }

    public LinkedList saveContainer(rq container) {
        LinkedList<ur> stacks = new LinkedList<ur>();
        int i = 0;
        while (i < container.c.size()) {
            stacks.add(NEIClientUtils.copyStack(container.a(i).c()));
            ++i;
        }
        return stacks;
    }

    public void restoreContainer(rq container, LinkedList items) {
        int i = 0;
        while (i < container.c.size()) {
            container.a(i).c((ur)items.get(i));
            ++i;
        }
        container.a(-999, 0, 0, (qx)NEIClientUtils.mc().g);
    }

    public void transferItem(avf window, int fromSlot) {
        int toSlot = this.findShiftClickDestinationSlot(window.d, fromSlot);
        if (toSlot == -1) {
            return;
        }
        sr from = window.d.a(fromSlot);
        if (from.a(from.c())) {
            this.moveOneItem(window, fromSlot, toSlot);
        } else {
            this.moveOutputSet(window, fromSlot, toSlot);
        }
    }

    public void moveOutputSet(avf window, int fromSlot, int toSlot) {
        if (NEIClientUtils.getHeldItem() != null) {
            return;
        }
        FastTransferManger.clickSlot(window, fromSlot);
        if (NEIClientUtils.getHeldItem() == null) {
            return;
        }
        FastTransferManger.clickSlot(window, toSlot);
    }

    public void moveOneItem(avf window, int fromSlot, int toSlot) {
        FastTransferManger.clickSlot(window, fromSlot);
        FastTransferManger.clickSlot(window, toSlot, 1);
        FastTransferManger.clickSlot(window, fromSlot);
    }

    public void retrieveItem(avf window, int toSlot) {
        Integer integer;
        sr slot = window.d.a(toSlot);
        ur slotStack = slot.c();
        if (slotStack == null || slotStack.a == slot.a() || slotStack.a == slotStack.d()) {
            return;
        }
        this.generateSlotMap(window.d, slotStack);
        Integer destZone = (Integer)this.slotZoneMap.get(toSlot);
        if (destZone == null) {
            return;
        }
        int firstZoneSlot = this.findShiftClickDestinationSlot(window.d, toSlot);
        int firstZone = -1;
        if (firstZoneSlot != -1 && (integer = (Integer)this.slotZoneMap.get(firstZoneSlot)) != null && this.retrieveItemFromZone(window, firstZone = integer.intValue(), toSlot)) {
            return;
        }
        int zone = 0;
        while (zone < this.slotZones.size()) {
            if (zone != destZone && zone != firstZone && this.retrieveItemFromZone(window, zone, toSlot)) {
                return;
            }
            ++zone;
        }
        this.retrieveItemFromZone(window, destZone, toSlot);
    }

    private boolean retrieveItemFromZone(avf window, int zone, int toSlot) {
        sr slot;
        ur stack1;
        int i;
        ur stack = window.d.a(toSlot).c();
        Iterator iterator = ((LinkedList)this.slotZones.get(zone)).iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            if (i == toSlot || !NEIClientUtils.areStacksSameType(stack, stack1 = (slot = window.d.a(i)).c()) || stack1.a == slot.a() || stack1.a == stack1.d()) continue;
            this.moveOneItem(window, i, toSlot);
            return true;
        }
        iterator = ((LinkedList)this.slotZones.get(zone)).iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            if (i == toSlot || !NEIClientUtils.areStacksSameType(stack, stack1 = (slot = window.d.a(i)).c())) continue;
            this.moveOneItem(window, i, toSlot);
            return true;
        }
        return false;
    }

    public static void clickSlot(avf window, int slotIndex) {
        FastTransferManger.clickSlot(window, slotIndex, 0);
    }

    public static void clickSlot(avf window, int slotIndex, int button) {
        FastTransferManger.clickSlot(window, slotIndex, button, 0);
    }

    public static void clickSlot(avf window, int slotIndex, int button, int modifier) {
        rq container = window.d;
        sr slot = null;
        if (slotIndex >= 0 && slotIndex < container.c.size()) {
            slot = container.a(slotIndex);
        }
        window.a(slot, slotIndex, button, modifier);
    }

    private boolean fillZoneWithHeldItem(avf window, int zoneIndex) {
        ur inToSlot;
        ur held;
        int transferTo;
        Iterator iterator = ((LinkedList)this.slotZones.get(zoneIndex)).iterator();
        while (iterator.hasNext()) {
            transferTo = (Integer)iterator.next();
            held = NEIClientUtils.getHeldItem();
            if (held == null) break;
            inToSlot = window.d.a(transferTo).c();
            if (!NEIClientUtils.areStacksSameType(inToSlot, held)) continue;
            FastTransferManger.clickSlot(window, transferTo);
        }
        iterator = ((LinkedList)this.slotZones.get(zoneIndex)).iterator();
        while (iterator.hasNext()) {
            transferTo = (Integer)iterator.next();
            held = NEIClientUtils.getHeldItem();
            if (held == null) break;
            inToSlot = window.d.a(transferTo).c();
            if (inToSlot != null) continue;
            FastTransferManger.clickSlot(window, transferTo);
        }
        return NEIClientUtils.getHeldItem() == null;
    }

    public void throwAll(avf window, int pickedUpFromSlot) {
        ur held = NEIClientUtils.getHeldItem();
        if (held == null) {
            return;
        }
        FastTransferManger.clickSlot(window, -999);
        this.generateSlotMap(window.d, held);
        Iterator iterator = ((LinkedList)this.slotZones.get((Integer)this.slotZoneMap.get(pickedUpFromSlot))).iterator();
        while (iterator.hasNext()) {
            int slotIndex = (Integer)iterator.next();
            sr slot = window.d.a(slotIndex);
            if (!NEIClientUtils.areStacksSameType(held, slot.c())) continue;
            FastTransferManger.clickSlot(window, slotIndex);
            FastTransferManger.clickSlot(window, -999);
        }
    }

    public static class SlotPositionComparator
    implements Comparator {
        rq container;

        public SlotPositionComparator(rq c) {
            this.container = c;
        }

        public int compare(Integer arg0, Integer arg1) {
            sr slot1 = this.container.a(arg0.intValue());
            sr slot2 = this.container.a(arg1.intValue());
            if (slot2.i != slot1.i) {
                return slot1.i - slot2.i;
            }
            return slot1.h - slot2.h;
        }
    }
}

