/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.FMLTextureFX;
import cpw.mods.fml.client.ITextureFX;
import cpw.mods.fml.client.OverrideInfo;
import cpw.mods.fml.client.SpriteHelper;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModContainer;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class TextureFXManager {
    private static final TextureFXManager INSTANCE = new TextureFXManager();
    private Map<Integer, TextureProperties> textureProperties = Maps.newHashMap();
    private Multimap<String, OverrideInfo> overrideInfo = ArrayListMultimap.create();
    private HashSet<OverrideInfo> animationSet = new HashSet();
    private List<bdg> addedTextureFX = new ArrayList<bdg>();
    private Minecraft client;
    private HashMap<Integer, Dimension> textureDims = new HashMap();
    private IdentityHashMap<bdg, Integer> effectTextures = new IdentityHashMap();
    private bem earlyTexturePack;

    void setClient(Minecraft client) {
        this.client = client;
    }

    public boolean onUpdateTextureEffect(bdg effect) {
        ITextureFX ifx;
        ITextureFX iTextureFX = ifx = effect instanceof ITextureFX ? (ITextureFX)effect : null;
        if (ifx != null && ifx.getErrored()) {
            return false;
        }
        String name = effect.getClass().getSimpleName();
        this.client.I.a(name);
        try {
            if (!FMLClientHandler.instance().hasOptifine()) {
                effect.a();
            }
        }
        catch (Exception e2) {
            FMLLog.log("fml.TextureManager", Level.WARNING, "Texture FX %s has failed to animate. Likely caused by a texture pack change that they did not respond correctly to", name);
            if (ifx != null) {
                ifx.setErrored(true);
            }
            this.client.I.b();
            return false;
        }
        this.client.I.b();
        if (ifx != null) {
            Dimension dim = this.getTextureDimensions(effect);
            int target = (dim.width >> 4) * (dim.height >> 4) << 2;
            if (effect.d.length != target) {
                FMLLog.log("fml.TextureManager", Level.WARNING, "Detected a texture FX sizing discrepancy in %s (%d, %d)", name, effect.d.length, target);
                ifx.setErrored(true);
                return false;
            }
        }
        return true;
    }

    public void scaleTextureFXData(byte[] data, ByteBuffer buf, int target, int length) {
        int sWidth = (int)Math.sqrt(data.length / 4);
        int factor = target / sWidth;
        byte[] tmp = new byte[4];
        buf.clear();
        if (factor > 1) {
            for (int y2 = 0; y2 < sWidth; ++y2) {
                int sRowOff = sWidth * y2;
                int tRowOff = target * y2 * factor;
                for (int x2 = 0; x2 < sWidth; ++x2) {
                    int sPos = (x2 + sRowOff) * 4;
                    tmp[0] = data[sPos + 0];
                    tmp[1] = data[sPos + 1];
                    tmp[2] = data[sPos + 2];
                    tmp[3] = data[sPos + 3];
                    int tPosTop = x2 * factor + tRowOff;
                    for (int y22 = 0; y22 < factor; ++y22) {
                        buf.position((tPosTop + y22 * target) * 4);
                        for (int x22 = 0; x22 < factor; ++x22) {
                            buf.put(tmp);
                        }
                    }
                }
            }
        }
        buf.position(0).limit(length);
    }

    public void onPreRegisterEffect(bdg effect) {
        Dimension dim = this.getTextureDimensions(effect);
        if (effect instanceof ITextureFX) {
            ((ITextureFX)effect).onTextureDimensionsUpdate(dim.width, dim.height);
        }
    }

    public int getEffectTexture(bdg effect) {
        Integer id2 = this.effectTextures.get(effect);
        if (id2 != null) {
            return id2;
        }
        int old = GL11.glGetInteger((int)32873);
        effect.a(this.client.o);
        id2 = GL11.glGetInteger((int)32873);
        GL11.glBindTexture((int)3553, (int)old);
        this.effectTextures.put(effect, id2);
        effect.g = id2;
        return id2;
    }

    public void onTexturePackChange(bba engine, bem texturepack, List<bdg> effects) {
        this.pruneOldTextureFX(texturepack, effects);
        for (bdg tex : effects) {
            if (!(tex instanceof ITextureFX)) continue;
            ((ITextureFX)tex).onTexturePackChanged(engine, texturepack, this.getTextureDimensions(tex));
        }
        this.loadTextures(texturepack);
    }

    public void setTextureDimensions(int id2, int width, int height, List<bdg> effects) {
        Dimension dim = new Dimension(width, height);
        this.textureDims.put(id2, dim);
        for (bdg tex : effects) {
            if (this.getEffectTexture(tex) != id2 || !(tex instanceof ITextureFX)) continue;
            ((ITextureFX)tex).onTextureDimensionsUpdate(width, height);
        }
    }

    public Dimension getTextureDimensions(bdg effect) {
        return this.getTextureDimensions(this.getEffectTexture(effect));
    }

    public Dimension getTextureDimensions(int id2) {
        return this.textureDims.get(id2);
    }

    public void addAnimation(bdg anim) {
        OverrideInfo info = new OverrideInfo();
        info.index = anim.e;
        info.imageIndex = anim.i;
        info.textureFX = anim;
        if (this.animationSet.contains(info)) {
            this.animationSet.remove(info);
        }
        this.animationSet.add(info);
    }

    public void loadTextures(bem texturePack) {
        this.registerTextureOverrides(this.client.o);
    }

    public void registerTextureOverrides(bba renderer) {
        for (OverrideInfo animationOverride : this.animationSet) {
            renderer.a(animationOverride.textureFX);
            this.addedTextureFX.add(animationOverride.textureFX);
            FMLLog.log("fml.TextureManager", Level.FINE, "Registered texture override %d (%d) on %s (%d)", animationOverride.index, animationOverride.textureFX.e, animationOverride.textureFX.getClass().getSimpleName(), animationOverride.textureFX.i);
        }
        for (String fileToOverride : this.overrideInfo.keySet()) {
            for (OverrideInfo override : this.overrideInfo.get((Object)fileToOverride)) {
                try {
                    BufferedImage image = this.loadImageFromTexturePack(renderer, override.override);
                    ModTextureStatic mts = new ModTextureStatic(override.index, 1, override.texture, image);
                    renderer.a(mts);
                    this.addedTextureFX.add(mts);
                    FMLLog.log("fml.TextureManager", Level.FINE, "Registered texture override %d (%d) on %s (%d)", override.index, mts.e, override.texture, mts.i);
                }
                catch (IOException e2) {
                    FMLLog.log("fml.TextureManager", Level.WARNING, e2, "Exception occurred registering texture override for %s", fileToOverride);
                }
            }
        }
    }

    protected void registerAnimatedTexturesFor(ModContainer mod) {
    }

    public void onEarlyTexturePackLoad(bem fallback) {
        if (this.client == null) {
            this.earlyTexturePack = fallback;
        } else {
            this.loadTextures(fallback);
        }
    }

    public void pruneOldTextureFX(bem var1, List<bdg> effects) {
        ListIterator<bdg> li2 = this.addedTextureFX.listIterator();
        while (li2.hasNext()) {
            bdg tex = li2.next();
            if (tex instanceof FMLTextureFX) {
                if (!((FMLTextureFX)tex).unregister(this.client.o, effects)) continue;
                li2.remove();
                continue;
            }
            effects.remove(tex);
            li2.remove();
        }
    }

    public void addNewTextureOverride(String textureToOverride, String overridingTexturePath, int location) {
        OverrideInfo info = new OverrideInfo();
        info.index = location;
        info.override = overridingTexturePath;
        info.texture = textureToOverride;
        this.overrideInfo.put((Object)textureToOverride, (Object)info);
        FMLLog.log("fml.TextureManager", Level.FINE, "Overriding %s @ %d with %s. %d slots remaining", textureToOverride, location, overridingTexturePath, SpriteHelper.freeSlotCount(textureToOverride));
    }

    public BufferedImage loadImageFromTexturePack(bba renderEngine, String path) throws IOException {
        InputStream image = this.client.C.e().a(path);
        if (image == null) {
            throw new RuntimeException(String.format("The requested image path %s is not found", path));
        }
        BufferedImage result = ImageIO.read(image);
        if (result == null) {
            throw new RuntimeException(String.format("The requested image path %s appears to be corrupted", path));
        }
        return result;
    }

    public static TextureFXManager instance() {
        return INSTANCE;
    }

    public void fixTransparency(BufferedImage loadedImage, String textureName) {
        if (textureName.matches("^/mob/.*_eyes.*.png$")) {
            for (int x2 = 0; x2 < loadedImage.getWidth(); ++x2) {
                for (int y2 = 0; y2 < loadedImage.getHeight(); ++y2) {
                    int argb = loadedImage.getRGB(x2, y2);
                    if ((argb & 0xFF000000) != 0 || argb == 0) continue;
                    loadedImage.setRGB(x2, y2, 0);
                }
            }
        }
    }

    private class TextureProperties {
        private int textureId;
        private Dimension dim;

        private TextureProperties() {
        }
    }
}

