/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.render;

import codechicken.core.Vector3;

public class LightModel {
    public static LightModel standardLightModel = new LightModel().setAmbient(new Vector3(0.4, 0.4, 0.4)).addLight(new Light().setPosition(new Vector3(0.2, 1.0, -0.7)).setDiffuse(new Vector3(0.6, 0.6, 0.6))).addLight(new Light().setPosition(new Vector3(-0.2, 1.0, 0.7)).setDiffuse(new Vector3(0.6, 0.6, 0.6)));
    private Vector3 ambient = new Vector3();
    private Light[] lights = new Light[8];
    private int lightCount;

    private LightModel addLight(Light light) {
        this.lights[this.lightCount++] = light;
        return this;
    }

    private LightModel setAmbient(Vector3 vec) {
        this.ambient.set(vec);
        return this;
    }

    public int apply(int colour, Vector3 normal) {
        Vector3 v_colour = new Vector3((double)(colour >> 16 & 0xFF) / 255.0, (double)(colour >> 8 & 0xFF) / 255.0, (double)(colour & 0xFF) / 255.0);
        Vector3 n_colour = new Vector3(this.ambient.x * v_colour.x, this.ambient.y * v_colour.y, this.ambient.z * v_colour.z);
        int l = 0;
        while (l < this.lightCount) {
            Light light = this.lights[l];
            double n_l = light.position.dotProduct(normal);
            double f = n_l > 0.0 ? 1 : 0;
            n_colour.x += v_colour.x * (light.ambient.x + f * light.diffuse.x * n_l);
            n_colour.y += v_colour.y * (light.ambient.y + f * light.diffuse.y * n_l);
            n_colour.z += v_colour.z * (light.ambient.z + f * light.diffuse.z * n_l);
            ++l;
        }
        if (n_colour.x > 1.0) {
            n_colour.x = 1.0;
        }
        if (n_colour.y > 1.0) {
            n_colour.y = 1.0;
        }
        if (n_colour.z > 1.0) {
            n_colour.z = 1.0;
        }
        return (int)(n_colour.x * 255.0) << 16 | (int)(n_colour.y * 255.0) << 8 | (int)(n_colour.z * 255.0);
    }

    public static class Light {
        public Vector3 ambient = new Vector3();
        public Vector3 diffuse = new Vector3();
        public Vector3 position = new Vector3();

        public Light setPosition(Vector3 vec) {
            this.position.set(vec).normalize();
            return this;
        }

        public Light setDiffuse(Vector3 vec) {
            this.diffuse.set(vec);
            return this;
        }

        public Light setAmbient(Vector3 vec) {
            this.ambient.set(vec);
            return this;
        }
    }
}

