/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.LaserKind;
import buildcraft.api.filler.FillerManager;
import buildcraft.api.filler.IFillerPattern;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionReceptor;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.builders.TileMarker;
import buildcraft.core.Box;
import buildcraft.core.IMachine;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TileNetworkData;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.triggers.ActionMachineControl;
import buildcraft.core.utils.Utils;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TileFiller
extends TileBuildCraft
implements ISidedInventory,
IPowerReceptor,
IMachine,
IActionReceptor {
    @TileNetworkData
    public Box box = new Box();
    @TileNetworkData
    public int currentPatternId = 0;
    @TileNetworkData
    public boolean done = true;
    public IFillerPattern currentPattern;
    boolean forceDone = false;
    private ur[] contents;
    IPowerProvider powerProvider;
    private ActionMachineControl.Mode lastMode = ActionMachineControl.Mode.Unknown;

    public TileFiller() {
        this.contents = new ur[this.k_()];
        this.powerProvider = PowerFramework.currentFramework.createPowerProvider();
        this.powerProvider.configure(20, 25, 50, 25, 100);
        this.powerProvider.configurePowerPerdition(25, 40);
    }

    @Override
    public void initialize() {
        IAreaProvider a;
        super.initialize();
        if (!CoreProxy.proxy.isRenderWorld(this.k) && (a = Utils.getNearbyAreaProvider(this.k, this.l, this.m, this.n)) != null) {
            this.box.initialize(a);
            if (a instanceof TileMarker) {
                ((TileMarker)a).removeFromWorld();
            }
            if (!CoreProxy.proxy.isRenderWorld(this.k) && this.box.isInitialized()) {
                this.box.createLasers(this.k, LaserKind.Stripes);
            }
            this.sendNetworkUpdate();
        }
        this.computeRecipe();
    }

    @Override
    public void g() {
        super.g();
        if (this.done) {
            if (this.lastMode == ActionMachineControl.Mode.Loop) {
                this.done = false;
            } else {
                return;
            }
        }
        if (this.powerProvider.getEnergyStored() >= 25.0f) {
            this.doWork();
        }
    }

    @Override
    public void doWork() {
        if (CoreProxy.proxy.isRenderWorld(this.k)) {
            return;
        }
        if (this.lastMode == ActionMachineControl.Mode.Off) {
            return;
        }
        if (this.powerProvider.useEnergy(25.0f, 25.0f, true) < 25.0f) {
            return;
        }
        if (this.box.isInitialized() && this.currentPattern != null && !this.done) {
            ur stack = null;
            int stackId = 0;
            for (int s = 9; s < this.k_(); ++s) {
                if (this.a(s) == null || this.a((int)s).a <= 0) continue;
                stack = this.contents[s];
                stackId = s;
                break;
            }
            this.done = this.currentPattern.iteratePattern(this, this.box, stack);
            if (stack != null && stack.a == 0) {
                this.contents[stackId] = null;
            }
            if (this.done) {
                this.k.i(this.l, this.m, this.n);
                this.sendNetworkUpdate();
            }
        }
        if (this.powerProvider.getEnergyStored() >= 25.0f) {
            this.doWork();
        }
    }

    public int k_() {
        return 36;
    }

    public ur a(int i) {
        return this.contents[i];
    }

    public void computeRecipe() {
        if (CoreProxy.proxy.isRenderWorld(this.k)) {
            return;
        }
        IFillerPattern newPattern = FillerManager.registry.findMatchingRecipe((la)this);
        if (newPattern == this.currentPattern) {
            return;
        }
        this.currentPattern = newPattern;
        if (this.currentPattern == null || this.forceDone) {
            this.done = this.lastMode != ActionMachineControl.Mode.Loop;
            this.forceDone = false;
        } else {
            this.done = false;
        }
        if (this.k != null) {
            this.k.i(this.l, this.m, this.n);
        }
        this.currentPatternId = this.currentPattern == null ? 0 : this.currentPattern.getId();
        if (CoreProxy.proxy.isSimulating(this.k)) {
            this.sendNetworkUpdate();
        }
    }

    public ur a(int i, int j) {
        if (this.contents[i] != null) {
            if (this.contents[i].a <= j) {
                ur itemstack = this.contents[i];
                this.contents[i] = null;
                this.computeRecipe();
                return itemstack;
            }
            ur itemstack1 = this.contents[i].a(j);
            if (this.contents[i].a == 0) {
                this.contents[i] = null;
            }
            this.computeRecipe();
            return itemstack1;
        }
        return null;
    }

    public void a(int i, ur itemstack) {
        this.contents[i] = itemstack;
        if (itemstack != null && itemstack.a > this.c()) {
            itemstack.a = this.c();
        }
        this.computeRecipe();
    }

    public ur a_(int slot) {
        if (this.contents[slot] == null) {
            return null;
        }
        ur toReturn = this.contents[slot];
        this.contents[slot] = null;
        return toReturn;
    }

    public String b() {
        return "Filler";
    }

    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        Utils.readStacksFromNBT(nbttagcompound, "Items", this.contents);
        if (nbttagcompound.b("box")) {
            this.box.initialize(nbttagcompound.l("box"));
        }
        this.done = nbttagcompound.n("done");
        this.lastMode = ActionMachineControl.Mode.values()[nbttagcompound.c("lastMode")];
        this.forceDone = this.done;
    }

    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        Utils.writeStacksToNBT(nbttagcompound, "Items", this.contents);
        if (this.box != null) {
            bq boxStore = new bq();
            this.box.writeToNBT(boxStore);
            nbttagcompound.a("box", (cd)boxStore);
        }
        nbttagcompound.a("done", this.done);
        nbttagcompound.a("lastMode", (byte)this.lastMode.ordinal());
    }

    public int c() {
        return 64;
    }

    public boolean a_(qx entityplayer) {
        if (this.k.q(this.l, this.m, this.n) != this) {
            return false;
        }
        return entityplayer.e((double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5) <= 64.0;
    }

    @Override
    public void w_() {
        super.w_();
        this.destroy();
    }

    @Override
    public void destroy() {
        if (this.box != null) {
            this.box.deleteLasers();
        }
    }

    @Override
    public void handleDescriptionPacket(PacketUpdate packet) {
        boolean initialized = this.box.isInitialized();
        super.handleDescriptionPacket(packet);
        this.currentPattern = FillerManager.registry.getPattern(this.currentPatternId);
        this.k.i(this.l, this.m, this.n);
        if (!initialized && this.box.isInitialized()) {
            this.box.createLasers(this.k, LaserKind.Stripes);
        }
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) {
        boolean initialized = this.box.isInitialized();
        super.handleUpdatePacket(packet);
        this.currentPattern = FillerManager.registry.getPattern(this.currentPatternId);
        this.k.i(this.l, this.m, this.n);
        if (!initialized && this.box.isInitialized()) {
            this.box.createLasers(this.k, LaserKind.Stripes);
        }
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public boolean isActive() {
        return !this.done && this.lastMode != ActionMachineControl.Mode.Off;
    }

    @Override
    public boolean manageLiquids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    public void l_() {
    }

    public void f() {
    }

    @Override
    public int powerRequest() {
        if (this.isActive()) {
            return this.powerProvider.getMaxEnergyReceived();
        }
        return 0;
    }

    @Override
    public void actionActivated(IAction action) {
        if (action == BuildCraftCore.actionOn) {
            this.lastMode = ActionMachineControl.Mode.On;
        } else if (action == BuildCraftCore.actionOff) {
            this.lastMode = ActionMachineControl.Mode.Off;
        } else if (action == BuildCraftCore.actionLoop) {
            this.lastMode = ActionMachineControl.Mode.Loop;
        }
    }

    @Override
    public boolean allowActions() {
        return true;
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return 0;
        }
        return 9;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return 9;
        }
        return this.k_() - 9;
    }
}

