/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.buildcraft;

import buildcraft.api.recipes.AssemblyRecipe;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class AssemblyRecipeHandler
extends TemplateRecipeHandler {
    static final int[][] stackorder = new int[][]{{0, 0}, {1, 0}, {0, 1}, {1, 1}, {0, 2}, {1, 2}, {2, 0}, {2, 1}, {2, 2}};
    public static LinkedList assemblyRecipes;
    public static Class assemblyRecipeClass;
    public static Field inputField;
    public static Field outputField;
    public static Field energyField;

    public String getRecipeName() {
        return "Assembly Table";
    }

    public boolean hasOverlay(avf gui, rq container, int recipe) {
        return false;
    }

    public String getGuiTexture() {
        return "/gui/crafting.png";
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        Integer time = Math.round(((CachedAssemblyRecipe)((Object)this.arecipes.get((int)recipe))).energy);
        String costString = time.toString();
        gui.drawTextCentered(costString, 110, 9, -8355712, false);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), "buildcraft.assembly", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("buildcraft.assembly") && ((Object)((Object)this)).getClass() == AssemblyRecipeHandler.class) {
            for (AssemblyRecipe irecipe : AssemblyRecipe.assemblyRecipes) {
                this.arecipes.add(new CachedAssemblyRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ur result) {
        for (AssemblyRecipe irecipe : AssemblyRecipe.assemblyRecipes) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ur)result, (ur)irecipe.output)) continue;
            this.arecipes.add(new CachedAssemblyRecipe(irecipe));
        }
    }

    public boolean recipeContain(AssemblyRecipe irecipe, ur ingredient) {
        for (ur item : irecipe.input) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ur)item, (ur)ingredient)) continue;
            return true;
        }
        return false;
    }

    public void loadUsageRecipes(ur ingredient) {
        for (AssemblyRecipe irecipe : AssemblyRecipe.assemblyRecipes) {
            if (!this.recipeContain(irecipe, ingredient)) continue;
            CachedAssemblyRecipe recipe = new CachedAssemblyRecipe(irecipe);
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public class CachedAssemblyRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        ArrayList ingredients;
        PositionedStack result;
        float energy;

        public CachedAssemblyRecipe(AssemblyRecipe recipe) {
            super((TemplateRecipeHandler)AssemblyRecipeHandler.this);
            this.result = new PositionedStack((Object)recipe.output, 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(Arrays.asList(recipe.input));
            this.energy = recipe.energy;
        }

        public CachedAssemblyRecipe(ur[] input, ur output, float energy) {
            super((TemplateRecipeHandler)AssemblyRecipeHandler.this);
            this.result = new PositionedStack((Object)output, 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(Arrays.asList(input));
            this.energy = energy;
        }

        public void setIngredients(List items) {
            for (int ingred = 0; ingred < items.size(); ++ingred) {
                ur ingredient = (ur)items.get(ingred);
                PositionedStack stack = new PositionedStack((Object)ingredient, 25 + stackorder[ingred][0] * 18, 6 + stackorder[ingred][1] * 18);
                this.ingredients.add(stack);
            }
        }

        public void replaceMetaOnIngredients(ur ingredient) {
            for (PositionedStack stack : this.ingredients) {
                if (stack.item.j() != -1 || !NEIClientUtils.areStacksSameTypeCrafting((ur)ingredient, (ur)stack.item)) continue;
                stack.item.b(ingredient.j());
            }
        }

        public ArrayList getIngredients() {
            int cycle = AssemblyRecipeHandler.this.cycleticks / 20;
            ArrayList<PositionedStack> cycledstacks = new ArrayList<PositionedStack>();
            for (PositionedStack basestack : this.ingredients) {
                PositionedStack stack = basestack.copy();
                if (stack.item.j() == -1) {
                    int maxDamage = 0;
                    do {
                        stack.item.b(++maxDamage);
                    } while (NEIClientUtils.isValidItem((ur)stack.item));
                    stack.item.b(cycle % maxDamage);
                }
                cycledstacks.add(stack);
            }
            return cycledstacks;
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

