/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.forestry;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.gadgets.MachineMoistener;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import mistaqur.nei.common.ICachedRecipeWithLiquidTank;
import mistaqur.nei.common.LiquidHelper;
import mistaqur.nei.common.LiquidTank;
import mistaqur.nei.forestry.ForestryRecipeHandler;
import net.minecraftforge.liquids.LiquidStack;

public class MoistenerRecipeHandler
extends ForestryRecipeHandler {
    static Rectangle waterTank = new Rectangle(11, 5, 16, 58);
    static Point overlayTank = new Point(176, 0);
    static PositionedStack[] fuels;

    public String getRecipeName() {
        return "Moistener";
    }

    public void loadCraftingRecipes(ur result) {
        MachineMoistener.RecipeManager manager = (MachineMoistener.RecipeManager)RecipeManagers.moistenerManager;
        for (MachineMoistener.Recipe irecipe : MachineMoistener.RecipeManager.recipes) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ur)irecipe.product, (ur)result)) continue;
            this.arecipes.add(new CachedMoistenerRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ur ingredient) {
        if (fuels == null) {
            this.loadFuels();
        }
        MachineMoistener.RecipeManager manager = (MachineMoistener.RecipeManager)RecipeManagers.moistenerManager;
        MachineMoistener.Recipe irecipe = MachineMoistener.RecipeManager.findMatchingRecipe((ur)ingredient);
        if (irecipe != null) {
            CachedMoistenerRecipe recipe = new CachedMoistenerRecipe(irecipe);
            this.arecipes.add(recipe);
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (fuels == null) {
            this.loadFuels();
        }
        if (outputId.equals("forestry.moistener") && ((Object)((Object)this)).getClass() == MoistenerRecipeHandler.class) {
            MachineMoistener.RecipeManager cfr_ignored_0 = (MachineMoistener.RecipeManager)RecipeManagers.moistenerManager;
            ArrayList recipes = MachineMoistener.RecipeManager.recipes;
            for (MachineMoistener.Recipe irecipe : recipes) {
                this.arecipes.add(new CachedMoistenerRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public String getGuiTexture() {
        return "/gfx/forestry/gui/moistener.png";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(138, 27, 16, 14), "forestry.moistener", new Object[0]));
    }

    public void loadFuels() {
        ArrayList<ur> resources = new ArrayList<ur>();
        ArrayList<ur> products = new ArrayList<ur>();
        for (MoistenerFuel fuel : FuelManager.moistenerResource.values()) {
            resources.add(fuel.item);
            products.add(fuel.product);
        }
        fuels = new PositionedStack[]{new PositionedStack(resources, 100, 26), new PositionedStack(products, 34, 47)};
    }

    public class CachedMoistenerRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        LiquidTank tank;
        PositionedStack resource;
        PositionedStack product;

        public CachedMoistenerRecipe(MachineMoistener.Recipe recipe) {
            super((TemplateRecipeHandler)MoistenerRecipeHandler.this);
            this.resource = new PositionedStack((Object)recipe.resource, 138, 8);
            this.product = new PositionedStack((Object)recipe.product, 138, 44);
            LiquidStack water = new LiquidStack(amq.E, 10000);
            this.tank = new LiquidTank(water, 10000, waterTank, overlayTank);
            this.tank.showAmount = false;
        }

        public PositionedStack getResult() {
            return this.product;
        }

        public PositionedStack getIngredient() {
            return this.resource;
        }

        @Override
        public ArrayList getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.tank);
            return res;
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            stacks.add(LiquidHelper.getSeqCycledStack(MoistenerRecipeHandler.this.cycleticks / 20, fuels[0]));
            stacks.add(LiquidHelper.getSeqCycledStack(MoistenerRecipeHandler.this.cycleticks / 20, fuels[1]));
            return stacks;
        }
    }
}

