/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.railcraft;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.FurnaceRecipeHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mistaqur.nei.common.ICachedRecipeWithLiquidTank;
import mistaqur.nei.common.LiquidHelper;
import mistaqur.nei.common.LiquidTank;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.api.crafting.ICokeOvenRecipe;
import railcraft.common.api.crafting.RailcraftCraftingManager;

public class CokeOvenRecipeHandler
extends FurnaceRecipeHandler {
    static Rectangle outputTank = new Rectangle(85, 13, 48, 47);
    static Point overlayTank = new Point(176, 0);
    public static Class guiclass;

    public String getRecipeName() {
        return "Coke Oven";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(29, 32, 22, 16), "railcraft.cokeoven", new Object[0]));
    }

    public Class getGuiClass() {
        return guiclass;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("railcraft.cokeoven") && ((Object)((Object)this)).getClass() == CokeOvenRecipeHandler.class) {
            for (ICokeOvenRecipe recipe : RailcraftCraftingManager.cokeOven.getRecipes()) {
                this.arecipes.add(new CachedOvenRecipe(recipe));
            }
        } else if (outputId.equals("liquid") && results.length == 1 && results[0] instanceof LiquidStack) {
            LiquidStack t = (LiquidStack)results[0];
            for (ICokeOvenRecipe recipe : RailcraftCraftingManager.cokeOven.getRecipes()) {
                if (!recipe.getLiquidOutput().isLiquidEqual(t)) continue;
                this.arecipes.add(new CachedOvenRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ur ingred) {
        for (ICokeOvenRecipe recipe : RailcraftCraftingManager.cokeOven.getRecipes()) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ur)recipe.getInput(), (ur)ingred)) continue;
            this.arecipes.add(new CachedOvenRecipe(recipe));
        }
    }

    public void loadCraftingRecipes(ur result) {
        LiquidStack t = LiquidHelper.getLiquidStack(result);
        for (ICokeOvenRecipe recipe : RailcraftCraftingManager.cokeOven.getRecipes()) {
            if ((t == null || !recipe.getLiquidOutput().isLiquidEqual(t)) && !NEIClientUtils.areStacksSameType((ur)result, (ur)recipe.getLiquidOutput().asItemStack()) && !NEIClientUtils.areStacksSameType((ur)result, (ur)recipe.getOutput())) continue;
            this.arecipes.add(new CachedOvenRecipe(recipe));
        }
    }

    public String getGuiTexture() {
        return "/railcraft/client/textures/gui/gui_coke_oven.png";
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        this.drawLiquidTanks(gui, recipe);
    }

    public void drawLiquidTanks(GuiContainerManager gui, int recipe) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof ICachedRecipeWithLiquidTank) {
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                tank.draw(gui, this.getGuiTexture());
            }
        }
    }

    protected boolean transferLiquidTank(GuiRecipe guiRecipe, int recipe, boolean usage) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof ICachedRecipeWithLiquidTank) {
            Point mousepos = guiRecipe.manager.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - guiRecipe.n - offset.x, mousepos.y - guiRecipe.o - offset.y);
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                if (!tank.position.contains(relMouse) || tank.liquid.itemID <= 0 || !(usage ? GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.liquid}) : GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.liquid}))) continue;
                return true;
            }
        }
        return false;
    }

    public List handleTooltip(GuiRecipe guiRecipe, List currenttip, int recipe) {
        currenttip = super.handleTooltip(guiRecipe, currenttip, recipe);
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (guiRecipe.manager.shouldShowTooltip() && crecipe instanceof ICachedRecipeWithLiquidTank) {
            Point mousepos = guiRecipe.manager.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - guiRecipe.n - offset.x, mousepos.y - guiRecipe.o - offset.y);
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                if (!tank.position.contains(relMouse)) continue;
                tank.handleTooltip(currenttip);
            }
        }
        return currenttip;
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        if (keyCode == NEIClientConfig.getKeyBinding((String)"recipe") ? this.transferLiquidTank(gui, recipe, false) : keyCode == NEIClientConfig.getKeyBinding((String)"usage") && this.transferLiquidTank(gui, recipe, true)) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        if (button == 0 ? this.transferLiquidTank(gui, recipe, false) : button == 1 && this.transferLiquidTank(gui, recipe, true)) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public class CachedOvenRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        ICokeOvenRecipe oven;
        ArrayList inputs;
        PositionedStack output;
        PositionedStack liquidInput;
        PositionedStack liquidOutput;
        LiquidTank tank;

        public CachedOvenRecipe(ICokeOvenRecipe base) {
            super((TemplateRecipeHandler)CokeOvenRecipeHandler.this);
            this.oven = base;
            this.tank = new LiquidTank(base.getLiquidOutput(), 64000, outputTank, overlayTank);
            PositionedStack input = new PositionedStack((Object)this.oven.getInput(), 11, 32);
            this.output = new PositionedStack((Object)this.oven.getOutput(), 57, 32);
            PositionedStack[] output_cont = LiquidHelper.generateStacksForLiquid(this.tank.liquid, 144, 11, 144, 46);
            this.liquidInput = output_cont[0];
            this.liquidOutput = output_cont[1];
            this.inputs = new ArrayList();
            this.inputs.add(input);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(CokeOvenRecipeHandler.this.cycleticks / 20, this.inputs);
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            stacks.add(LiquidHelper.getSeqCycledStack(CokeOvenRecipeHandler.this.cycleticks / 20, this.liquidInput));
            stacks.add(LiquidHelper.getSeqCycledStack(CokeOvenRecipeHandler.this.cycleticks / 20, this.liquidOutput));
            return stacks;
        }

        @Override
        public ArrayList getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.tank);
            return res;
        }
    }
}

