/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.railcraft;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import railcraft.common.api.crafting.IRockCrusherRecipe;
import railcraft.common.api.crafting.RailcraftCraftingManager;

public class RockCrusherRecipeHandler
extends TemplateRecipeHandler {
    static final int[][] stackorder = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}};
    public static Class guiclass;

    public String getRecipeName() {
        return "Rock Crusher";
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        this.drawProgressBar(gui, 59, 9, 176, 0, 29, 53, 48, 0);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(59, 9, 29, 53), "railcraft.crusher", new Object[0]));
    }

    public Class getGuiClass() {
        return guiclass;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("railcraft.crusher") && ((Object)((Object)this)).getClass() == RockCrusherRecipeHandler.class) {
            for (IRockCrusherRecipe irecipe : RailcraftCraftingManager.rockCrusher.getRecipes()) {
                this.arecipes.add(new CachedRockCrusherRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ur result) {
        for (IRockCrusherRecipe irecipe : RailcraftCraftingManager.rockCrusher.getRecipes()) {
            if (!irecipe.getOutputs().containsKey(result)) continue;
            CachedRockCrusherRecipe recipe = new CachedRockCrusherRecipe(irecipe);
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ur ingredient) {
        for (IRockCrusherRecipe irecipe : RailcraftCraftingManager.rockCrusher.getRecipes()) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ur)irecipe.getInput(), (ur)ingredient) || irecipe.getOutputs().size() <= 0) continue;
            this.arecipes.add(new CachedRockCrusherRecipe(irecipe));
        }
    }

    public Rectangle getRectangleFromPositionedStack(PositionedStack stack) {
        return new Rectangle(stack.relx - 1, stack.rely - 1, 18, 18);
    }

    public List handleItemTooltip(GuiRecipe guiRecipe, ur stack, List currenttip, int recipe) {
        CachedRockCrusherRecipe crecipe = (CachedRockCrusherRecipe)((Object)this.arecipes.get(recipe));
        Point mousepos = guiRecipe.manager.getMousePosition();
        Point offset = guiRecipe.getRecipePosition(recipe);
        Point relMouse = new Point(mousepos.x - guiRecipe.n - offset.x, mousepos.y - guiRecipe.o - offset.y);
        for (int i = 0; i < 9; ++i) {
            if (crecipe.products[i] == null || !this.getRectangleFromPositionedStack(crecipe.products[i]).contains(relMouse)) continue;
            float chance = crecipe.chances[i];
            if (chance == 0.0f) {
                currenttip.add("Chance: never");
                continue;
            }
            if ((double)chance < 0.01) {
                currenttip.add("Chance < 1%");
                continue;
            }
            if (!(chance < 1.0f)) continue;
            currenttip.add("Chance: " + Integer.toString(Math.round(chance * 100.0f)) + "%");
        }
        return currenttip;
    }

    public boolean hasOverlay(avf gui, rq container, int recipe) {
        return false;
    }

    public String getGuiTexture() {
        return "/railcraft/client/textures/gui/gui_crusher.png";
    }

    public class CachedRockCrusherRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack[] products;
        float[] chances;
        ArrayList resources;

        public CachedRockCrusherRecipe(IRockCrusherRecipe recipe) {
            super((TemplateRecipeHandler)RockCrusherRecipeHandler.this);
            this.resources = new ArrayList();
            this.resources.add(new PositionedStack((Object)recipe.getInput(), 3, 10));
            this.products = new PositionedStack[9];
            this.chances = new float[9];
            for (int i = 0; i < 9; ++i) {
                this.chances[i] = 0.0f;
            }
            this.setProducts(recipe.getOutputs());
        }

        public float getProductChance(PositionedStack stack) {
            for (int i = 0; i < 9; ++i) {
                if (this.products[i] != stack) continue;
                return this.chances[i];
            }
            return 0.0f;
        }

        public void setProducts(Map iproducts) {
            int i = 0;
            for (Map.Entry product : iproducts.entrySet()) {
                if (i > 8) break;
                this.products[i] = new PositionedStack(product.getKey(), 93 + stackorder[i][0] * 18, 10 + stackorder[i][1] * 18);
                this.chances[i] = ((Float)product.getValue()).floatValue();
                ++i;
            }
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            for (int i = 1; i < 9; ++i) {
                if (this.products[i] == null) continue;
                stacks.add(this.products[i]);
            }
            return stacks;
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(RockCrusherRecipeHandler.this.cycleticks / 20, this.resources);
        }

        public boolean canProduce(ur product) {
            for (int i = 0; i < 9; ++i) {
                if (this.products[i] == null || !NEIClientUtils.areStacksSameTypeCrafting((ur)this.products[i].item, (ur)product)) continue;
                return true;
            }
            return false;
        }

        public PositionedStack getResult() {
            return this.products[0];
        }
    }
}

