@echo off
REM ##########################################
REM #                                        #
REM # Filename: RETURN.BAT                   #
REM # Purpose : Initialize environment for   #
REM #           the play of "The Return"     #
REM #                                        #
REM ##########################################
REM
REM ##########################################
REM #                                        #
REM # Check for the existance of ART files   #
REM #                                        #
REM ##########################################
REM 
IF EXIST TILES000.ART GOTO #ARTERROR
IF EXIST TILES001.ART GOTO #ARTERROR
IF EXIST TILES002.ART GOTO #ARTERROR
IF EXIST TILES003.ART GOTO #ARTERROR
IF EXIST TILES004.ART GOTO #ARTERROR
IF EXIST TILES005.ART GOTO #ARTERROR
IF EXIST TILES006.ART GOTO #ARTERROR
IF EXIST TILES007.ART GOTO #ARTERROR
IF EXIST TILES008.ART GOTO #ARTERROR
IF EXIST TILES009.ART GOTO #ARTERROR
IF EXIST TILES010.ART GOTO #ARTERROR
IF EXIST TILES011.ART GOTO #ARTERROR
IF EXIST TILES012.ART GOTO #ARTERROR
IF EXIST TILES013.ART GOTO #ARTERROR
IF EXIST TILES014.ART GOTO #ARTERROR
IF EXIST TILES015.ART GOTO #ARTERROR
IF EXIST TILES016.ART GOTO #ARTERROR
IF EXIST TILES017.ART GOTO #ARTERROR
IF EXIST TILES018.ART GOTO #ARTERROR
IF EXIST TILES019.ART GOTO #ARTERROR
IF EXIST TILES020.ART GOTO #ARTERROR
IF EXIST TILES021.ART GOTO #ARTERROR
IF EXIST TILES022.ART GOTO #ARTERROR

REM ##########################################
REM #                                        #
REM # Check for essential game files         #
REM #                                        #
REM ##########################################

IF NOT EXIST RETURN.GRP GOTO #GAMEERROR
IF NOT EXIST DUKE3D.EXE GOTO #GAMEERROR
IF NOT EXIST RGAME.CON GOTO #GAMEERROR
IF NOT EXIST RDEFS.CON GOTO #GAMEERROR
IF NOT EXIST RUSER.CON GOTO #GAMEERROR
IF NOT EXIST RETURN.CON GOTO #GAMEERROR

REM ##########################################
REM #                                        #
REM # Save user files & rename RETURN files. #
REM #                                        #
REM ##########################################

rename demo1.dmo,udemo1.dmo
rename rdemo1.dmo,demo1.dmo
rename demo2.dmo,udemo2.dmo
rename rdemo2.dmo,demo2.dmo
rename demo3.dmo,udemo3.dmo
rename rdemo3.dmo,demo3.dmo

REM ##########################################
REM #                                        #
REM # Launch Duke with RETURN Con Files      #
REM #                                        #
REM ##########################################

duke3d /xrgame.con /greturn.grp %1 %2 %3 %4 %5 %6 %7 %8

REM ##########################################
REM #                                        #
REM # Restore origninal user settings        #
REM #                                        #
REM ##########################################

rename demo1.dmo,rdemo1.dmo
rename udemo1.dmo,demo1.dmo
rename demo2.dmo,rdemo2.dmo
rename udemo2.dmo,demo2.dmo
rename demo3.dmo,rdemo3.dmo
rename udemo3.dmo,demo3.dmo
ECHO Thank you for playing and come back to The Return soon!
ECHO Level Designers: Matthew Collver-Horvath, Sean Bakmen, Brian Tarnish,
ECHO Jonathan Velman, Rory Travis.

GOTO EXIT

REM ##########################################
REM #                                        #
REM # Artwork Error Logic                    #
REM #                                        #
REM ##########################################
:#ARTERROR
CLS
ECHO The Return Could not be started because one or more default art files
ECHO exist in the directory. Rename any files named tiles000.art through
ECHO tiles022.art and try the request again!

GOTO EXIT

REM ##########################################
REM #                                        #
REM # File Not Existing Error Logic          #
REM #                                        #
REM ##########################################
:#GAMEERROR
CLS
ECHO Please put these files in the current directory; Return.grp, Duke3d.exe,
ECHO Rgame.con, Rdefs.con, Ruser.con, and Return.con. Once done, go back and
ECHO try the request again!

REM ##########################################
REM #                                        #
REM # Exit Logic                             #
REM #                                        #
REM ##########################################
:EXIT
