/*
 * Decompiled with CFR 0.152.
 */
package gui;

import connectfour.GameSession;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import server.Server;
import server.User;
import shared.Updatable;

public class ServerWindow
implements WindowListener,
ActionListener,
Runnable,
Updatable {
    private Server m_server;
    private JFrame m_frame = new JFrame("Matchmaking Server Window");
    private JTabbedPane m_mainTabbedPane;
    private JTextArea m_consoleText;
    private Font m_consoleFont;
    private JScrollPane m_consoleScrollPane;
    private JTable m_userTable;
    private JScrollPane m_userScrollPane;
    private JTable m_gameSessionTable;
    private JScrollPane m_gameSessionScrollPane;
    private JMenuBar m_menuBar;
    private JMenu m_fileMenu;
    private JMenuItem m_fileExitMenuItem;
    private JMenu m_settingsMenu;
    private JCheckBoxMenuItem m_settingsAutoScrollConsoleWindowMenuItem;
    private JMenuItem m_settingsMaxConsoleHistoryMenuItem;
    private JMenu m_helpMenu;
    private JMenuItem m_helpAboutMenuItem;
    private boolean m_initialized;
    private boolean m_running;
    private boolean m_updating;
    private boolean m_autoSizeColumns;
    private Thread m_updateThread;

    public ServerWindow() {
        this.m_frame.setDefaultCloseOperation(3);
        this.m_frame.setMinimumSize(new Dimension(320, 240));
        this.m_frame.setSize(new Dimension(640, 480));
        this.m_frame.addWindowListener(this);
        try {
            this.m_server = new Server();
        }
        catch (RemoteException e) {
            JOptionPane.showMessageDialog(this.m_frame, "Failed to create server: " + e.getMessage(), "Startup Failure", 0);
            System.exit(1);
        }
        Server.console.addTarget(this);
        this.m_initialized = false;
        this.m_running = false;
        this.m_updating = false;
        this.m_autoSizeColumns = true;
        this.initMenu();
        this.initComponents();
    }

    public boolean initialize(String serverQueueName, int registryPort, String brokerHostName) {
        if (this.m_initialized) {
            return false;
        }
        if (!this.m_server.initialize(serverQueueName, registryPort, brokerHostName)) {
            JOptionPane.showMessageDialog(null, "Unable to initialize matchmaking server.", "Initialization Error", 0);
            return false;
        }
        this.update();
        this.m_frame.setVisible(true);
        this.m_initialized = true;
        this.m_updateThread = new Thread(this);
        this.m_updateThread.start();
        return true;
    }

    private void initMenu() {
        this.m_menuBar = new JMenuBar();
        this.m_fileMenu = new JMenu("File");
        this.m_fileExitMenuItem = new JMenuItem("Exit");
        this.m_settingsMenu = new JMenu("Settings");
        this.m_settingsAutoScrollConsoleWindowMenuItem = new JCheckBoxMenuItem("Auto-scroll Console Window");
        this.m_helpMenu = new JMenu("Help");
        this.m_helpAboutMenuItem = new JMenuItem("About");
        this.m_settingsAutoScrollConsoleWindowMenuItem.setSelected(Server.console.getAutoScrollConsoleWindow());
        this.m_settingsMaxConsoleHistoryMenuItem = new JMenuItem("Max Console History");
        this.m_fileExitMenuItem.addActionListener(this);
        this.m_settingsAutoScrollConsoleWindowMenuItem.addActionListener(this);
        this.m_settingsMaxConsoleHistoryMenuItem.addActionListener(this);
        this.m_helpAboutMenuItem.addActionListener(this);
        this.m_fileMenu.add(this.m_fileExitMenuItem);
        this.m_settingsMenu.add(this.m_settingsAutoScrollConsoleWindowMenuItem);
        this.m_settingsMenu.add(this.m_settingsMaxConsoleHistoryMenuItem);
        this.m_helpMenu.add(this.m_helpAboutMenuItem);
        this.m_menuBar.add(this.m_fileMenu);
        this.m_menuBar.add(this.m_settingsMenu);
        this.m_menuBar.add(this.m_helpMenu);
        this.m_frame.setJMenuBar(this.m_menuBar);
    }

    private void initComponents() {
        this.m_mainTabbedPane = new JTabbedPane();
        this.m_consoleText = new JTextArea();
        this.m_consoleFont = new Font("Verdana", 0, 14);
        this.m_consoleText.setFont(this.m_consoleFont);
        this.m_consoleText.setEditable(false);
        this.m_consoleScrollPane = new JScrollPane(this.m_consoleText);
        this.m_mainTabbedPane.add(this.m_consoleScrollPane);
        this.m_mainTabbedPane.addTab("Console", null, this.m_consoleScrollPane, "Displays debugging output from the server.");
        this.m_frame.add(this.m_mainTabbedPane);
        this.m_userScrollPane = new JScrollPane();
        this.m_userTable = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        DefaultTableModel userTableModel = new DefaultTableModel(null, User.TABLE_HEADERS);
        this.m_userTable.setSelectionMode(0);
        this.m_userTable.setModel(userTableModel);
        this.m_userScrollPane.setViewportView(this.m_userTable);
        this.m_mainTabbedPane.addTab("Users", null, this.m_userScrollPane, "Displays the active users");
        this.m_gameSessionScrollPane = new JScrollPane();
        this.m_gameSessionTable = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        DefaultTableModel gameSessionTableModel = new DefaultTableModel(null, GameSession.TABLE_HEADERS);
        this.m_gameSessionTable.setSelectionMode(0);
        this.m_gameSessionTable.setModel(gameSessionTableModel);
        this.m_gameSessionScrollPane.setViewportView(this.m_gameSessionTable);
        this.m_mainTabbedPane.addTab("Game Sessions", null, this.m_gameSessionScrollPane, "Displays the active game sessions");
    }

    @Override
    public void update() {
        this.m_updating = true;
        this.m_settingsAutoScrollConsoleWindowMenuItem.setSelected(Server.console.getAutoScrollConsoleWindow());
        try {
            this.m_consoleText.setText(Server.console.toString());
            if (Server.console.getAutoScrollConsoleWindow()) {
                this.m_consoleText.setCaretPosition(this.m_consoleText.getText().length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_updating = false;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this.m_frame) {
            this.stop();
            this.m_server.stop();
            this.m_frame.dispose();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_updating) {
            return;
        }
        if (e.getSource() == this.m_fileExitMenuItem) {
            this.stop();
            this.m_server.stop();
            System.exit(0);
        } else if (e.getSource() == this.m_settingsAutoScrollConsoleWindowMenuItem) {
            Server.console.setAutoScrollConsoleWindow(this.m_settingsAutoScrollConsoleWindowMenuItem.isSelected());
        } else if (e.getSource() == this.m_settingsMaxConsoleHistoryMenuItem) {
            String input = JOptionPane.showInputDialog(this.m_frame, "Please enter the maximum console history size:", Server.console.getMaxConsoleHistory());
            if (input == null) {
                return;
            }
            int maxConsoleHistory = -1;
            try {
                maxConsoleHistory = Integer.parseInt(input);
            }
            catch (NumberFormatException e2) {
                JOptionPane.showMessageDialog(this.m_frame, "Invalid number entered for maximum console history.", "Invalid Number", 0);
                return;
            }
            Server.console.setMaxConsoleHistory(maxConsoleHistory);
        } else if (e.getSource() == this.m_helpAboutMenuItem) {
            JOptionPane.showMessageDialog(this.m_frame, "Connect Four Matchmaking Server\nCreated by Kevin Scroggins & Corey Faibish", "About Matchmaking Server", 1);
        }
    }

    public void updateUserTable(boolean autoSizeColumns) {
        try {
            int x = this.m_userTable.getSelectedColumn();
            int y = this.m_userTable.getSelectedRow();
            DefaultTableModel tableModel = (DefaultTableModel)this.m_userTable.getModel();
            tableModel.getDataVector().removeAllElements();
            tableModel.fireTableDataChanged();
            int i = 0;
            while (i < this.m_server.numberOfUsers()) {
                tableModel.addRow(this.m_server.getUser(i).getAsTableEntry());
                ++i;
            }
            if (x >= 0 && y >= 0 && x < this.m_userTable.getColumnCount() && y < this.m_userTable.getRowCount()) {
                this.m_userTable.getSelectionModel().setSelectionInterval(y, y);
                this.m_userTable.getColumnModel().getSelectionModel().setSelectionInterval(x, x);
            }
            if (autoSizeColumns) {
                TableCellRenderer renderer = this.m_userTable.getTableHeader().getDefaultRenderer();
                int i2 = 0;
                while (i2 < this.m_userTable.getColumnCount()) {
                    this.m_userTable.getColumnModel().getColumn(i2).setPreferredWidth(renderer.getTableCellRendererComponent((JTable)this.m_userTable, (Object)this.m_userTable.getModel().getColumnName((int)i2), (boolean)false, (boolean)false, (int)0, (int)i2).getPreferredSize().width);
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateGameSessionTable(boolean autoSizeColumns) {
        try {
            int x = this.m_gameSessionTable.getSelectedColumn();
            int y = this.m_gameSessionTable.getSelectedRow();
            DefaultTableModel tableModel = (DefaultTableModel)this.m_gameSessionTable.getModel();
            tableModel.getDataVector().removeAllElements();
            tableModel.fireTableDataChanged();
            int i = 0;
            while (i < this.m_server.numberOfSessions()) {
                tableModel.addRow(this.m_server.getSession(i).getAsTableEntry());
                ++i;
            }
            if (x >= 0 && y >= 0 && x < this.m_gameSessionTable.getColumnCount() && y < this.m_gameSessionTable.getRowCount()) {
                this.m_gameSessionTable.getSelectionModel().setSelectionInterval(y, y);
                this.m_gameSessionTable.getColumnModel().getSelectionModel().setSelectionInterval(x, x);
            }
            if (autoSizeColumns) {
                TableCellRenderer renderer = this.m_gameSessionTable.getTableHeader().getDefaultRenderer();
                int i2 = 0;
                while (i2 < this.m_gameSessionTable.getColumnCount()) {
                    this.m_gameSessionTable.getColumnModel().getColumn(i2).setPreferredWidth(renderer.getTableCellRendererComponent((JTable)this.m_gameSessionTable, (Object)this.m_gameSessionTable.getModel().getColumnName((int)i2), (boolean)false, (boolean)false, (int)0, (int)i2).getPreferredSize().width);
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        this.m_initialized = false;
        this.m_running = false;
        try {
            this.m_updateThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        if (!this.m_initialized) {
            return;
        }
        this.m_running = true;
        while (this.m_running) {
            this.updateUserTable(this.m_autoSizeColumns);
            this.updateGameSessionTable(this.m_autoSizeColumns);
            this.m_autoSizeColumns = false;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

