/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.SystemConsoleEntry;
import java.util.Vector;
import shared.Updatable;

public class SystemConsole {
    private Vector<SystemConsoleEntry> m_consoleEntries = new Vector();
    private Vector<Updatable> m_targets = new Vector();
    private boolean m_autoScrollConsoleWindow = true;
    private int m_maxConsoleHistory = 512;

    public boolean getAutoScrollConsoleWindow() {
        return this.m_autoScrollConsoleWindow;
    }

    public int getMaxConsoleHistory() {
        return this.m_maxConsoleHistory;
    }

    public void setAutoScrollConsoleWindow(boolean autoScrollConsoleWindow) {
        this.m_autoScrollConsoleWindow = autoScrollConsoleWindow;
    }

    public void setMaxConsoleHistory(int maxConsoleHistory) {
        if (maxConsoleHistory < 1) {
            return;
        }
        this.m_maxConsoleHistory = maxConsoleHistory;
    }

    public void addTarget(Updatable target) {
        if (target == null) {
            return;
        }
        if (!this.m_targets.contains(target)) {
            this.m_targets.add(target);
        }
    }

    public void removeTarget(Updatable target) {
        if (target == null) {
            return;
        }
        this.m_targets.remove(target);
    }

    public void clearTargets() {
        this.m_targets.clear();
    }

    private void updateTargets() {
        int i = 0;
        while (i < this.m_targets.size()) {
            this.m_targets.elementAt(i).update();
            ++i;
        }
    }

    public int size() {
        return this.m_consoleEntries.size();
    }

    public SystemConsoleEntry getConsoleEntry(int index) {
        if (index < 0 || index >= this.m_consoleEntries.size()) {
            return null;
        }
        return this.m_consoleEntries.elementAt(index);
    }

    public void writeLine(String text) {
        this.m_consoleEntries.add(new SystemConsoleEntry(text));
        while (this.m_consoleEntries.size() > this.m_maxConsoleHistory) {
            this.m_consoleEntries.remove(0);
        }
        this.updateTargets();
    }

    public void clear() {
        this.m_consoleEntries.clear();
        this.updateTargets();
    }

    public String toString() {
        String data = "";
        SystemConsoleEntry e = null;
        int i = 0;
        while (i < this.m_consoleEntries.size()) {
            e = this.m_consoleEntries.elementAt(i);
            data = String.valueOf(data) + e.getTimeString() + ": " + e.getText();
            if (i < this.m_consoleEntries.size() - 1) {
                data = String.valueOf(data) + "\n";
            }
            ++i;
        }
        return data;
    }
}

