/*
 * Decompiled with CFR 0.152.
 */
package dbms;

import dbms.SQLResultRow;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;

public class SQLResult {
    private SQLResultRow m_headers = new SQLResultRow();
    private Vector<SQLResultRow> m_data = new Vector();

    public SQLResult() {
    }

    public SQLResult(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            ResultSetMetaData meta = rs.getMetaData();
            if (meta == null) {
                return;
            }
            int i = 1;
            while (i <= meta.getColumnCount()) {
                this.m_headers.add(meta.getColumnName(i));
                ++i;
            }
            while (rs.next()) {
                SQLResultRow rowData = new SQLResultRow();
                int i2 = 1;
                while (i2 <= meta.getColumnCount()) {
                    rowData.add(rs.getString(i2));
                    ++i2;
                }
                this.m_data.add(rowData);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public int getColumnCount() {
        return this.m_headers.size();
    }

    public int getRowCount() {
        return this.m_data.size();
    }

    public SQLResultRow getHeaders() {
        return this.m_headers;
    }

    public String getHeader(int index) {
        if (index < 0 || index >= this.m_headers.size()) {
            return null;
        }
        return this.m_headers.elementAt(index);
    }

    public Vector<SQLResultRow> getData() {
        return this.m_data;
    }

    public SQLResultRow getRow(int row) {
        if (row < 0 || row >= this.m_data.size()) {
            return null;
        }
        return this.m_data.elementAt(row);
    }

    public String getElement(int row, int index) {
        if (row < 0 || row >= this.m_data.size()) {
            return null;
        }
        if (index < 0 || index >= this.m_data.elementAt(row).size()) {
            return null;
        }
        return this.m_data.elementAt(row).elementAt(index);
    }

    public String toString() {
        String s = this.m_headers.toString();
        int i = 0;
        while (i < this.m_data.size()) {
            s = String.valueOf(s) + "\n" + this.m_data.elementAt(i).toString();
            ++i;
        }
        return s;
    }
}

