/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import server.DatabaseServer;
import shared.Updatable;

public class DatabaseWindow
implements WindowListener,
ActionListener,
Runnable,
Updatable {
    private DatabaseServer m_server;
    private JFrame m_frame = new JFrame("Database Server Window");
    private JTabbedPane m_mainTabbedPane;
    private JTextArea m_consoleText;
    private Font m_consoleFont;
    private JScrollPane m_consoleScrollPane;
    private JTable m_userDataTable;
    private JScrollPane m_userDataScrollPane;
    private JTable m_gameHistoryTable;
    private JScrollPane m_gameHistoryScrollPane;
    private JMenuBar m_menuBar;
    private JMenu m_fileMenu;
    private JMenuItem m_fileExitMenuItem;
    private JMenu m_manageMenu;
    private JMenuItem m_manageDeleteUserMenuItem;
    private JMenuItem m_manageDeleteUserHistoryMenuItem;
    private JMenu m_settingsMenu;
    private JCheckBoxMenuItem m_settingsAutoScrollConsoleWindowMenuItem;
    private JMenuItem m_settingsMaxConsoleHistoryMenuItem;
    private JMenu m_helpMenu;
    private JMenuItem m_helpAboutMenuItem;
    private boolean m_updating;
    private boolean m_initialized;
    private boolean m_running;
    private boolean m_autoSizeColumns;
    private Thread m_updateThread;
    public static final String USER_DATA_TABLENAME = "UserData";
    public static final String GAME_HISTORY_TABLENAME = "GameHistory";

    public DatabaseWindow() {
        this.m_frame.setDefaultCloseOperation(3);
        this.m_frame.setMinimumSize(new Dimension(320, 240));
        this.m_frame.setSize(new Dimension(640, 480));
        this.m_frame.addWindowListener(this);
        this.m_server = new DatabaseServer();
        DatabaseServer.console.addTarget(this);
        this.m_initialized = false;
        this.m_running = false;
        this.m_updating = false;
        this.m_autoSizeColumns = true;
        this.initMenu();
        this.initComponents();
    }

    public boolean initialize(String databaseConfigFileName, String dbmsName, boolean integratedRegistry, int registryPort) {
        if (this.m_initialized) {
            return false;
        }
        if (!this.m_server.initialize(databaseConfigFileName, dbmsName, integratedRegistry, registryPort)) {
            JOptionPane.showMessageDialog(null, "Unable to initialize database server.", "Initialization Error", 0);
            return false;
        }
        this.update();
        this.m_frame.setVisible(true);
        this.m_initialized = true;
        this.m_updateThread = new Thread(this);
        this.m_updateThread.start();
        return true;
    }

    private void initMenu() {
        this.m_menuBar = new JMenuBar();
        this.m_fileMenu = new JMenu("File");
        this.m_fileExitMenuItem = new JMenuItem("Exit");
        this.m_manageMenu = new JMenu("Manage");
        this.m_manageDeleteUserMenuItem = new JMenuItem("Delete User");
        this.m_manageDeleteUserHistoryMenuItem = new JMenuItem("Delete User History");
        this.m_settingsMenu = new JMenu("Settings");
        this.m_settingsAutoScrollConsoleWindowMenuItem = new JCheckBoxMenuItem("Auto-scroll Console Window");
        this.m_helpMenu = new JMenu("Help");
        this.m_helpAboutMenuItem = new JMenuItem("About");
        this.m_settingsAutoScrollConsoleWindowMenuItem.setSelected(DatabaseServer.console.getAutoScrollConsoleWindow());
        this.m_settingsMaxConsoleHistoryMenuItem = new JMenuItem("Max Console History");
        this.m_fileExitMenuItem.addActionListener(this);
        this.m_manageDeleteUserMenuItem.addActionListener(this);
        this.m_manageDeleteUserHistoryMenuItem.addActionListener(this);
        this.m_settingsAutoScrollConsoleWindowMenuItem.addActionListener(this);
        this.m_settingsMaxConsoleHistoryMenuItem.addActionListener(this);
        this.m_helpAboutMenuItem.addActionListener(this);
        this.m_fileMenu.add(this.m_fileExitMenuItem);
        this.m_manageMenu.add(this.m_manageDeleteUserMenuItem);
        this.m_manageMenu.add(this.m_manageDeleteUserHistoryMenuItem);
        this.m_settingsMenu.add(this.m_settingsAutoScrollConsoleWindowMenuItem);
        this.m_settingsMenu.add(this.m_settingsMaxConsoleHistoryMenuItem);
        this.m_helpMenu.add(this.m_helpAboutMenuItem);
        this.m_menuBar.add(this.m_fileMenu);
        this.m_menuBar.add(this.m_manageMenu);
        this.m_menuBar.add(this.m_settingsMenu);
        this.m_menuBar.add(this.m_helpMenu);
        this.m_frame.setJMenuBar(this.m_menuBar);
    }

    private void initComponents() {
        this.m_mainTabbedPane = new JTabbedPane();
        this.m_consoleText = new JTextArea();
        this.m_consoleFont = new Font("Verdana", 0, 14);
        this.m_consoleText.setFont(this.m_consoleFont);
        this.m_consoleText.setEditable(false);
        this.m_consoleScrollPane = new JScrollPane(this.m_consoleText);
        this.m_mainTabbedPane.add(this.m_consoleScrollPane);
        this.m_mainTabbedPane.addTab("Console", null, this.m_consoleScrollPane, "Displays debugging output from the server.");
        this.m_frame.add(this.m_mainTabbedPane);
        this.m_userDataScrollPane = new JScrollPane();
        this.m_userDataTable = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        DefaultTableModel userDataTableModel = new DefaultTableModel(null, new String[]{"UserName", "Password", "LastLogin", "JoinDate", "Wins", "Losses", "Draws"});
        this.m_userDataTable.setSelectionMode(0);
        this.m_userDataTable.setModel(userDataTableModel);
        this.m_userDataScrollPane.setViewportView(this.m_userDataTable);
        this.m_mainTabbedPane.addTab("User Data", null, this.m_userDataScrollPane, "Displays the User Data table for debugging");
        this.m_gameHistoryScrollPane = new JScrollPane();
        this.m_gameHistoryTable = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        DefaultTableModel gameHistoryTableModel = new DefaultTableModel(null, new String[]{"GameDate", "FirstPlayer", "SecondPlayer", "Outcome"});
        this.m_gameHistoryTable.setSelectionMode(0);
        this.m_gameHistoryTable.setModel(gameHistoryTableModel);
        this.m_gameHistoryScrollPane.setViewportView(this.m_gameHistoryTable);
        this.m_mainTabbedPane.addTab("Game History", null, this.m_gameHistoryScrollPane, "Displays the Game History table for debugging");
    }

    @Override
    public void update() {
        this.m_updating = true;
        this.m_settingsAutoScrollConsoleWindowMenuItem.setSelected(DatabaseServer.console.getAutoScrollConsoleWindow());
        try {
            this.m_consoleText.setText(DatabaseServer.console.toString());
            if (DatabaseServer.console.getAutoScrollConsoleWindow()) {
                this.m_consoleText.setCaretPosition(this.m_consoleText.getText().length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_updating = false;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this.m_frame) {
            this.stop();
            this.m_server.stop();
            this.m_frame.dispose();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_updating) {
            return;
        }
        if (e.getSource() == this.m_fileExitMenuItem) {
            this.stop();
            this.m_server.stop();
            System.exit(0);
        } else if (e.getSource() == this.m_manageDeleteUserMenuItem) {
            Object[] userNames = null;
            try {
                userNames = DatabaseServer.database.getUserNames();
            }
            catch (RemoteException e2) {
                return;
            }
            if (userNames == null) {
                return;
            }
            if (userNames.length == 0) {
                JOptionPane.showMessageDialog(this.m_frame, "No users in database to delete.", "No Users", 2);
                return;
            }
            String userName = (String)JOptionPane.showInputDialog(null, "Choose a user to delete:", "Delete User", 3, null, userNames, userNames[0]);
            if (userName == null) {
                return;
            }
            try {
                DatabaseServer.database.deleteUser(userName);
            }
            catch (RemoteException remoteException) {}
        } else if (e.getSource() == this.m_manageDeleteUserHistoryMenuItem) {
            Object[] userNames = null;
            try {
                userNames = DatabaseServer.database.getUserNamesFromHistory();
            }
            catch (RemoteException e2) {
                return;
            }
            if (userNames == null) {
                return;
            }
            if (userNames.length == 0) {
                JOptionPane.showMessageDialog(this.m_frame, "No history in database to delete.", "No Users in History", 2);
                return;
            }
            String userName = (String)JOptionPane.showInputDialog(null, "Choose a user's history to delete:", "Delete User History", 3, null, userNames, userNames[0]);
            if (userName == null) {
                return;
            }
            try {
                DatabaseServer.database.deleteUserHistory(userName);
            }
            catch (RemoteException remoteException) {}
        } else if (e.getSource() == this.m_settingsAutoScrollConsoleWindowMenuItem) {
            DatabaseServer.console.setAutoScrollConsoleWindow(this.m_settingsAutoScrollConsoleWindowMenuItem.isSelected());
        } else if (e.getSource() == this.m_settingsMaxConsoleHistoryMenuItem) {
            String input = JOptionPane.showInputDialog(this.m_frame, "Please enter the maximum console history size:", DatabaseServer.console.getMaxConsoleHistory());
            if (input == null) {
                return;
            }
            int maxConsoleHistory = -1;
            try {
                maxConsoleHistory = Integer.parseInt(input);
            }
            catch (NumberFormatException e2) {
                JOptionPane.showMessageDialog(this.m_frame, "Invalid number entered for maximum console history.", "Invalid Number", 0);
                return;
            }
            DatabaseServer.console.setMaxConsoleHistory(maxConsoleHistory);
        } else if (e.getSource() == this.m_helpAboutMenuItem) {
            JOptionPane.showMessageDialog(this.m_frame, "Connect Four Database Server\nCreated by Kevin Scroggins & Corey Faibish", "About Database Server", 1);
        }
    }

    public void stop() {
        this.m_initialized = false;
        this.m_running = false;
        try {
            this.m_updateThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        if (!this.m_initialized) {
            return;
        }
        this.m_running = true;
        while (this.m_running) {
            try {
                DatabaseServer.database.updateTable(USER_DATA_TABLENAME, this.m_userDataTable, this.m_autoSizeColumns);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                DatabaseServer.database.updateTable(GAME_HISTORY_TABLENAME, this.m_gameHistoryTable, this.m_autoSizeColumns);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_autoSizeColumns = false;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

