/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.SystemConsoleEntry;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Vector;
import palette.PaletteEditor;
import utilities.Updatable;

public class SystemConsole {
    private Vector<SystemConsoleEntry> m_consoleEntries = new Vector();
    private Vector<Updatable> m_targets = new Vector();
    private boolean m_headerAddedToLogFile = false;
    public static final DateFormat LOG_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss aa");

    public void addTarget(Updatable updatable) {
        if (updatable == null) {
            return;
        }
        if (!this.m_targets.contains(updatable)) {
            this.m_targets.add(updatable);
        }
    }

    public void removeTarget(Updatable updatable) {
        if (updatable == null) {
            return;
        }
        this.m_targets.remove(updatable);
    }

    public void clearTargets() {
        this.m_targets.clear();
    }

    private void updateTargets() {
        for (int i = 0; i < this.m_targets.size(); ++i) {
            this.m_targets.elementAt(i).update();
        }
    }

    public int size() {
        return this.m_consoleEntries.size();
    }

    public SystemConsoleEntry getConsoleEntry(int n) {
        if (n < 0 || n >= this.m_consoleEntries.size()) {
            return null;
        }
        return this.m_consoleEntries.elementAt(n);
    }

    public void writeLine(boolean bl) {
        this.writeLine(bl ? "true" : "false");
    }

    public void writeLine(short s) {
        this.writeLine(Short.toString(s));
    }

    public void writeLine(int n) {
        this.writeLine(Integer.toString(n));
    }

    public void writeLine(long l) {
        this.writeLine(Long.toString(l));
    }

    public void writeLine(float f) {
        this.writeLine(Float.toString(f));
    }

    public void writeLine(double d) {
        this.writeLine(Double.toString(d));
    }

    public void writeLine(char c) {
        this.writeLine(Character.toString(c));
    }

    public void writeLine(Object object) {
        this.writeLine(object == null ? "null" : object.toString());
    }

    public void writeLine(String string) {
        this.writeLine(string, false);
    }

    private void writeLine(String string, boolean bl) {
        SystemConsoleEntry systemConsoleEntry = new SystemConsoleEntry(string);
        this.m_consoleEntries.add(systemConsoleEntry);
        while (this.m_consoleEntries.size() > PaletteEditor.settings.maxConsoleHistory) {
            this.m_consoleEntries.remove(0);
        }
        if (PaletteEditor.settings.logConsole && !bl) {
            this.addHeaderToLogFile();
            if (!this.appendToLogFile(systemConsoleEntry.getTimeAsString() + ": " + systemConsoleEntry.getText())) {
                this.writeLine("Failed to write text to console log file", true);
            }
        }
        this.updateTargets();
    }

    public void clear() {
        this.m_consoleEntries.clear();
        this.updateTargets();
    }

    public boolean createLogDirectory() {
        if (PaletteEditor.settings.logDirectoryName.length() == 0) {
            return true;
        }
        File file = new File(PaletteEditor.settings.logDirectoryName);
        if (!file.exists()) {
            try {
                return file.mkdirs();
            }
            catch (SecurityException securityException) {
                PaletteEditor.console.writeLine("Failed to create log directory, check read / write permissions.");
                return false;
            }
        }
        return true;
    }

    public void resetConsoleLogFileHeader() {
        this.m_headerAddedToLogFile = false;
    }

    private boolean addHeaderToLogFile() {
        if (this.m_headerAddedToLogFile) {
            return false;
        }
        this.createLogDirectory();
        File file = new File((PaletteEditor.settings.logDirectoryName.length() == 0 ? "" : PaletteEditor.settings.logDirectoryName + (PaletteEditor.settings.logDirectoryName.charAt(PaletteEditor.settings.logDirectoryName.length() - 1) == '/' || PaletteEditor.settings.logDirectoryName.charAt(PaletteEditor.settings.logDirectoryName.length() - 1) == '\\' ? "" : "/")) + PaletteEditor.settings.consoleLogFileName);
        PrintWriter printWriter = null;
        boolean bl = file.exists();
        try {
            printWriter = new PrintWriter(new FileWriter(file, true));
            if (bl) {
                printWriter.println();
            }
            printWriter.println("[Console Output from " + LOG_DATE_FORMAT.format(Calendar.getInstance().getTime()) + "]");
        }
        catch (IOException iOException) {
            return false;
        }
        if (printWriter != null) {
            printWriter.close();
        }
        this.m_headerAddedToLogFile = true;
        return true;
    }

    private boolean appendToLogFile(String string) {
        if (string == null) {
            return false;
        }
        this.createLogDirectory();
        File file = new File((PaletteEditor.settings.logDirectoryName.length() == 0 ? "" : PaletteEditor.settings.logDirectoryName + (PaletteEditor.settings.logDirectoryName.charAt(PaletteEditor.settings.logDirectoryName.length() - 1) == '/' || PaletteEditor.settings.logDirectoryName.charAt(PaletteEditor.settings.logDirectoryName.length() - 1) == '\\' ? "" : "/")) + PaletteEditor.settings.consoleLogFileName);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file, true));
            printWriter.println(string);
        }
        catch (IOException iOException) {
            return false;
        }
        if (printWriter != null) {
            printWriter.close();
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(512);
        SystemConsoleEntry systemConsoleEntry = null;
        for (int i = 0; i < this.m_consoleEntries.size(); ++i) {
            systemConsoleEntry = this.m_consoleEntries.elementAt(i);
            stringBuffer.append(systemConsoleEntry.getTimeAsString() + ": " + systemConsoleEntry.getText());
            if (i >= this.m_consoleEntries.size() - 1) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

