/*
 * Decompiled with CFR 0.152.
 */
package palette;

import exception.PaletteInstantiationException;
import exception.PalettePluginLoadException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import palette.Palette;
import palette.PaletteEditor;
import utilities.Utilities;
import variable.Variable;

public class PalettePlugin {
    protected String m_name = null;
    protected Vector<String> m_supportedPaletteFileTypes = new Vector();
    protected boolean m_instantiable = false;
    protected double m_pluginVersion = -1.0;
    protected String m_directoryName;
    protected String m_configFileName;
    protected String m_jarFileName;
    protected String m_paletteClassName;
    protected Class<?> m_paletteClass;
    protected HashMap<String, Class<?>> m_classes;
    protected boolean m_loaded;
    public static final String PALETTE_PLUGIN_DEFINITION_FILE_HEADER = "Palette Plugin Definition File";
    public static final String PALETTE_PLUGIN_DEFINITION_FILE_VERSION = "1.0";
    public static final String PLUGIN_VERSION = "1.0";
    public static final String PLUGIN_TYPE = "Palette";
    public static final String[] CONFIG_FILE_TYPES = new String[]{"CFG"};

    protected PalettePlugin(String string, String string2) {
        this.m_directoryName = string2 == null ? null : string2.trim();
        this.m_configFileName = string == null ? null : string.trim();
        this.m_jarFileName = null;
        this.m_paletteClassName = null;
        this.m_classes = new HashMap();
        this.m_loaded = false;
    }

    public String getName() {
        return this.m_name;
    }

    public double getPluginVersion() {
        return this.m_pluginVersion;
    }

    public int numberOfSupportedPaletteFileTypes() {
        return this.m_supportedPaletteFileTypes.size();
    }

    public String getSupportedPaletteFileType(int n) {
        if (n < 0 || n >= this.m_supportedPaletteFileTypes.size()) {
            return null;
        }
        return this.m_supportedPaletteFileTypes.elementAt(n);
    }

    public String getSupportedPaletteFileTypesAsString() {
        String string = "";
        for (int i = 0; i < this.m_supportedPaletteFileTypes.size(); ++i) {
            string = string + this.m_supportedPaletteFileTypes.elementAt(i);
            if (i >= this.m_supportedPaletteFileTypes.size() - 1) continue;
            string = string + ", ";
        }
        return string;
    }

    public Vector<String> getSupportedPaletteFileTypes() {
        return this.m_supportedPaletteFileTypes;
    }

    public boolean hasSupportedPaletteFileType(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return false;
        }
        for (int i = 0; i < this.m_supportedPaletteFileTypes.size(); ++i) {
            if (!this.m_supportedPaletteFileTypes.elementAt(i).equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSharedSupportedPaletteFileType(PalettePlugin palettePlugin) {
        if (palettePlugin == null) {
            return false;
        }
        for (int i = 0; i < palettePlugin.numberOfSupportedPaletteFileTypes(); ++i) {
            if (!this.hasSupportedPaletteFileType(palettePlugin.getSupportedPaletteFileType(i))) continue;
            return true;
        }
        return false;
    }

    public int numberOfSharedSupportedPaletteFileTypes(PalettePlugin palettePlugin) {
        if (palettePlugin == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < palettePlugin.numberOfSupportedPaletteFileTypes(); ++i) {
            if (!this.hasSupportedPaletteFileType(palettePlugin.getSupportedPaletteFileType(i))) continue;
            ++n;
        }
        return n;
    }

    public Vector<String> getSharedSupportedPaletteFileTypes(PalettePlugin palettePlugin) {
        if (palettePlugin == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < palettePlugin.numberOfSupportedPaletteFileTypes(); ++i) {
            if (!this.hasSupportedPaletteFileType(palettePlugin.getSupportedPaletteFileType(i))) continue;
            vector.add(palettePlugin.getSupportedPaletteFileType(i));
        }
        return vector;
    }

    public String getSharedSupportedPaletteFileTypesAsString(PalettePlugin palettePlugin) {
        if (palettePlugin == null) {
            return null;
        }
        String string = new String();
        for (int i = 0; i < palettePlugin.numberOfSupportedPaletteFileTypes(); ++i) {
            if (!this.hasSupportedPaletteFileType(palettePlugin.getSupportedPaletteFileType(i))) continue;
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + palettePlugin.getSupportedPaletteFileType(i);
        }
        return string;
    }

    public int indexOfSupportedPaletteFileType(String string) {
        if (string == null) {
            return -1;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return -1;
        }
        for (int i = 0; i < this.m_supportedPaletteFileTypes.size(); ++i) {
            if (!this.m_supportedPaletteFileTypes.elementAt(i).equalsIgnoreCase(string2)) continue;
            return i;
        }
        return -1;
    }

    public boolean addSupportedPaletteFileType(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return false;
        }
        for (int i = 0; i < this.m_supportedPaletteFileTypes.size(); ++i) {
            if (!this.m_supportedPaletteFileTypes.elementAt(i).equalsIgnoreCase(string2)) continue;
            return false;
        }
        this.m_supportedPaletteFileTypes.add(string2);
        return true;
    }

    public boolean isInstantiable() {
        return this.m_instantiable;
    }

    public String getDirectoryName() {
        return this.m_directoryName;
    }

    public String getConfigFileName() {
        return this.m_configFileName;
    }

    public boolean setConfigFileName(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return false;
        }
        this.m_configFileName = string;
        return true;
    }

    public String getJarFileName() {
        return this.m_jarFileName;
    }

    public String getPaletteClassName() {
        return this.m_paletteClassName;
    }

    public int numberOfClasses() {
        return this.m_classes.size();
    }

    public Class<?> getLoadedClass(String string) {
        if (string == null) {
            return null;
        }
        return this.m_classes.get(string.replaceAll("[\\\\/]", ".").replaceAll("\\.[Cc][Ll][Aa][Ss][Ss]$", ""));
    }

    public Palette getPaletteInstance(File file) throws PaletteInstantiationException {
        Constructor<?> constructor = null;
        try {
            constructor = this.m_paletteClass.getDeclaredConstructor(File.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (constructor == null) {
            throw new PaletteInstantiationException("Palette class \"" + this.m_paletteClassName + "\" must contain a constructor which takes a File as an argument.");
        }
        Palette palette = null;
        try {
            palette = (Palette)constructor.newInstance(file);
        }
        catch (Exception exception) {
            throw new PaletteInstantiationException("Failed to instantiate palette class \"" + this.m_paletteClassName + "\": " + exception.getMessage());
        }
        return palette;
    }

    public boolean isLoaded() {
        return this.m_loaded;
    }

    public boolean load() {
        if (this.m_loaded) {
            return true;
        }
        if (!this.loadClasses()) {
            return false;
        }
        this.m_loaded = true;
        return true;
    }

    protected boolean loadClasses() {
        if (this.m_loaded) {
            return true;
        }
        if (this.m_jarFileName == null) {
            return false;
        }
        ZipFile zipFile = null;
        try {
            zipFile = new JarFile(Utilities.appendSlash(PaletteEditor.settings.pluginDirectoryName) + Utilities.appendSlash(this.m_directoryName) + "/" + this.m_jarFileName);
            Pattern pattern = Pattern.compile(".*\\.class$", 2);
            Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (!pattern.matcher(jarEntry.getName()).matches()) continue;
                InputStream inputStream = ((JarFile)zipFile).getInputStream(jarEntry);
                if (inputStream.available() < 1) {
                    zipFile.close();
                    return false;
                }
                byte[] byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                String string = jarEntry.getName().replaceAll("[\\\\/]", ".").replaceAll("\\.[Cc][Ll][Aa][Ss][Ss]$", "");
                Class<?> clazz = PaletteEditor.classLoader.deserializeClass(string, byArray);
                if (clazz == null) {
                    return false;
                }
                this.m_classes.put(string, clazz);
            }
            zipFile.close();
            return true;
        }
        catch (IOException iOException) {
            try {
                zipFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    protected static String readPluginDefinitionFileVersion(BufferedReader bufferedReader, File file) throws IOException, PalettePluginLoadException {
        String string;
        String string2;
        if (bufferedReader == null || file == null) {
            return null;
        }
        do {
            if ((string = bufferedReader.readLine()) != null) continue;
            bufferedReader.close();
            throw new PalettePluginLoadException("Palette plugin definition file \"" + file.getName() + "\" incomplete or corrupted, no header found.");
        } while ((string2 = string.trim()).length() == 0);
        if (!string2.matches("^.* ([0-9]\\.?)+$")) {
            bufferedReader.close();
            throw new PalettePluginLoadException("Palette plugin definition file \"" + file.getName() + "\" has an invalid header: \"" + string2 + "\".");
        }
        String[] stringArray = new String[2];
        int n = string2.lastIndexOf(32);
        if (n < 0) {
            bufferedReader.close();
            throw new PalettePluginLoadException("Palette plugin definition file \"" + file.getName() + "\" is missing version number in header.");
        }
        stringArray[0] = string2.substring(0, n);
        stringArray[1] = string2.substring(n + 1, string2.length());
        if (!stringArray[0].trim().equalsIgnoreCase(PALETTE_PLUGIN_DEFINITION_FILE_HEADER)) {
            bufferedReader.close();
            throw new PalettePluginLoadException("Palette plugin definition file \"" + file.getName() + "\" has an invalid header: \"" + stringArray[0] + "\", expected \"" + PALETTE_PLUGIN_DEFINITION_FILE_HEADER + "\".");
        }
        return stringArray[1];
    }

    protected static boolean verifyDefinitionFileVersion(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return false;
        }
        return Utilities.compareVersions("1.0", string2) == 0;
    }

    public static boolean isPalettePlugin(File file) throws PalettePluginLoadException {
        if (file == null || !file.exists() || !file.isFile()) {
            throw new PalettePluginLoadException("Palette plugin definition file \"" + file.getName() + "\" is missing or invalid.");
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            try {
                if (!PalettePlugin.verifyDefinitionFileVersion(PalettePlugin.readPluginDefinitionFileVersion(bufferedReader, file))) {
                    bufferedReader.close();
                    throw new PalettePluginLoadException("Unsupported plugin definition file version, only version 1.0 is supported. Maybe check for updates, or verify your plugin definition files?");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Invalid plugin version specified in plugin definition file \"" + file.getName() + "\": " + illegalArgumentException.getMessage());
            }
            bufferedReader.close();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PalettePluginLoadException("Missing palette plugin definition file \"" + file.getName() + "\": " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new PalettePluginLoadException("Read exception thrown while parsing palette plugin definition file \"" + file.getName() + "\": " + iOException.getMessage());
        }
    }

    public static String getPalettePluginName(File file) throws PalettePluginLoadException {
        if (file == null || !file.exists() || !file.isFile()) {
            throw new PalettePluginLoadException("Palette plugin definition file \"" + file.getName() + "\" is missing or invalid.");
        }
        String string = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            String string3;
            bufferedReader = new BufferedReader(new FileReader(file));
            try {
                if (!PalettePlugin.verifyDefinitionFileVersion(PalettePlugin.readPluginDefinitionFileVersion(bufferedReader, file))) {
                    bufferedReader.close();
                    throw new PalettePluginLoadException("Unsupported plugin definition file version, only version 1.0 is supported. Maybe check for updates, or verify your plugin definition files?");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Invalid plugin version specified in plugin definition file \"" + file.getName() + "\": " + illegalArgumentException.getMessage());
            }
            do {
                if ((string2 = bufferedReader.readLine()) != null) continue;
                bufferedReader.close();
                throw new PalettePluginLoadException("Palette plugin definition file \"" + file.getName() + "\" incomplete or corrupted, no plugin name found.");
            } while ((string3 = string2.trim()).length() == 0);
            Variable variable = Variable.parseFrom(string3);
            if (variable == null) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Failed to parse palette plugin name variable in palette definition file: \"" + file.getName() + "\".");
            }
            if (!variable.getID().equalsIgnoreCase("Name")) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Expected palette plugin name variable, found \"" + variable.getID() + "\" instead, in palette definition file: \"" + file.getName() + "\".");
            }
            string = variable.getValue();
            if (string.length() == 0) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Invalid empty palette plugin name found in palette definition file: \"" + file.getName() + "\".");
            }
            bufferedReader.close();
            return string;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PalettePluginLoadException("Missing palette plugin definition file \"" + file.getName() + "\": " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new PalettePluginLoadException("Read exception thrown while parsing palette plugin definition file \"" + file.getName() + "\": " + iOException.getMessage());
        }
    }

    public static PalettePlugin loadFrom(File file) throws PalettePluginLoadException {
        if (file == null || !file.exists() || !file.isFile()) {
            throw new PalettePluginLoadException("Palette plugin definition file \"" + file.getName() + "\" is missing or invalid.");
        }
        PalettePlugin palettePlugin = null;
        String string = file.getPath().matches(".*[\\\\/].*") ? file.getPath().replaceAll("[\\\\/][^\\\\/]*$", "").replaceAll("^.*[\\\\/]", "") : "/";
        String string2 = Utilities.getFileExtension(file.getName());
        if (!string2.equalsIgnoreCase("cfg")) {
            throw new PalettePluginLoadException("Unsupported palette plugin configuration file type: \"" + string2 + "\".");
        }
        palettePlugin = PalettePlugin.loadFromCFGFile(file, string);
        return palettePlugin;
    }

    protected static PalettePlugin loadFromCFGFile(File file, String string) throws PalettePluginLoadException {
        if (file == null || !file.exists() || !file.isFile()) {
            throw new PalettePluginLoadException("Palette plugin definition file \"" + file.getName() + "\" is missing or invalid.");
        }
        if (string == null) {
            throw new PalettePluginLoadException("Palette plugin must have a non-null directory name.");
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            throw new PalettePluginLoadException("Palette plugin must have a non-empty directory name.");
        }
        PalettePlugin palettePlugin = new PalettePlugin(file.getName(), string2);
        try {
            String string3;
            String string4;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                if (!PalettePlugin.verifyDefinitionFileVersion(PalettePlugin.readPluginDefinitionFileVersion(bufferedReader, file))) {
                    bufferedReader.close();
                    throw new PalettePluginLoadException("Unsupported plugin definition file version, only version 1.0 is supported. Maybe check for updates, or verify your plugin definition files?");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Invalid plugin version specified in plugin definition file \"" + file.getName() + "\": " + illegalArgumentException.getMessage());
            }
            do {
                if ((string3 = bufferedReader.readLine()) != null) continue;
                bufferedReader.close();
                throw new PalettePluginLoadException("Palette plugin definition file \"" + file.getName() + "\" incomplete or corrupted, no plugin version found.");
            } while ((string4 = string3.trim()).length() == 0);
            Variable variable = Variable.parseFrom(string4);
            if (variable == null) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Failed to parse palette plugin version variable in palette definition file: \"" + file.getName() + "\".");
            }
            if (!variable.getID().equalsIgnoreCase("Plugin Version")) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Expected palette plugin version variable, found \"" + variable.getID() + "\" instead, in palette definition file: \"" + file.getName() + "\".");
            }
            String string5 = variable.getValue();
            if (string5.length() == 0) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Empty palette plugin version found in palette definition file: \"" + file.getName() + "\".");
            }
            try {
                if (Utilities.compareVersions("1.0", string5) != 0) {
                    bufferedReader.close();
                    throw new PalettePluginLoadException("Unsupported plugin version, only version 1.0 is supported. Maybe check for updates, or verify your config files?");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Invalid plugin version specified in plugin definition file \"" + file.getName() + "\": " + illegalArgumentException.getMessage());
            }
            do {
                if ((string3 = bufferedReader.readLine()) != null) continue;
                bufferedReader.close();
                throw new PalettePluginLoadException("Palette plugin definition file \"" + file.getName() + "\" incomplete or corrupted, no plugin type found.");
            } while ((string4 = string3.trim()).length() == 0);
            variable = Variable.parseFrom(string4);
            if (variable == null) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Failed to parse palette plugin type variable in palette definition file: \"" + file.getName() + "\".");
            }
            if (!variable.getID().equalsIgnoreCase("Plugin Type")) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Expected palette plugin type variable, found \"" + variable.getID() + "\" instead, in palette definition file: \"" + file.getName() + "\".");
            }
            string5 = variable.getValue();
            if (string5.length() == 0) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Empty plugin type found in palette definition file: \"" + file.getName() + "\".");
            }
            if (!string5.equalsIgnoreCase(PLUGIN_TYPE)) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Unsupported plugin type \"" + string5 + "\" found in palette definition file: \"" + file.getName() + "\", only type " + PLUGIN_TYPE + " is supported.");
            }
            do {
                if ((string3 = bufferedReader.readLine()) != null) continue;
                bufferedReader.close();
                throw new PalettePluginLoadException("Palette plugin definition file \"" + file.getName() + "\" incomplete or corrupted, no plugin name found.");
            } while ((string4 = string3.trim()).length() == 0);
            variable = Variable.parseFrom(string4);
            if (variable == null) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Failed to parse palette plugin name variable in palette definition file: \"" + file.getName() + "\".");
            }
            if (!variable.getID().equalsIgnoreCase("Plugin Name")) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Expected palette plugin name variable, found \"" + variable.getID() + "\" instead, in palette definition file: \"" + file.getName() + "\".");
            }
            palettePlugin.m_name = variable.getValue();
            if (palettePlugin.m_name.length() == 0) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Empty palette plugin name found in palette definition file: \"" + file.getName() + "\".");
            }
            do {
                if ((string3 = bufferedReader.readLine()) != null) continue;
                bufferedReader.close();
                throw new PalettePluginLoadException("Palette plugin definition file \"" + file.getName() + "\" incomplete or corrupted, no suppported palette file type list found.");
            } while ((string4 = string3.trim()).length() == 0);
            variable = Variable.parseFrom(string4);
            if (variable == null) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Failed to parse suppported palette file type list variable in palette definition file: \"" + file.getName() + "\".");
            }
            if (!variable.getID().equalsIgnoreCase("Supported Palette File Types")) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Expected suppported palette file type list variable, found \"" + variable.getID() + "\" instead, in palette definition file: \"" + file.getName() + "\".");
            }
            string5 = variable.getValue();
            if (string5.length() == 0) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Empty supported palette file type list found in palette definition file: \"" + file.getName() + "\".");
            }
            String string6 = null;
            String[] stringArray = string5.split("[;, \t]");
            for (int i = 0; i < stringArray.length; ++i) {
                string6 = stringArray[i].trim();
                if (string6.length() <= 0) continue;
                palettePlugin.addSupportedPaletteFileType(string6);
            }
            if (palettePlugin.numberOfSupportedPaletteFileTypes() == 0) {
                throw new PalettePluginLoadException("Palette plugin \"" + palettePlugin.getName() + "\" in palette definition file: \"" + file.getName() + "\" must support at least one file type.");
            }
            do {
                if ((string3 = bufferedReader.readLine()) != null) continue;
                bufferedReader.close();
                throw new PalettePluginLoadException("Palette plugin definition file \"" + file.getName() + "\" incomplete or corrupted, no instantiable property found.");
            } while ((string4 = string3.trim()).length() == 0);
            variable = Variable.parseFrom(string4);
            if (variable == null) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Failed to parse palette instantiable property in palette definition file: \"" + file.getName() + "\".");
            }
            if (!variable.getID().equalsIgnoreCase("Instantiable")) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Expected palette instantiable variable, found \"" + variable.getID() + "\" instead, in palette definition file: \"" + file.getName() + "\".");
            }
            string5 = variable.getValue();
            if (string5.length() == 0) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Empty palette instantiable property found in palette definition file: \"" + file.getName() + "\".");
            }
            if (string5.equalsIgnoreCase("true") || string5.equalsIgnoreCase("1") || string5.equalsIgnoreCase("yes") || string5.equalsIgnoreCase("enabled")) {
                palettePlugin.m_instantiable = true;
            } else if (string5.equalsIgnoreCase("false") || string5.equalsIgnoreCase("0") || string5.equalsIgnoreCase("no") || string5.equalsIgnoreCase("disabled")) {
                palettePlugin.m_instantiable = false;
            } else {
                throw new PalettePluginLoadException("Invalid palette instantiable property value found in palette definition file: \"" + file.getName() + "\", espected one of: true, false, 1, 0, yes, no, enabled, disabled.");
            }
            do {
                if ((string3 = bufferedReader.readLine()) != null) continue;
                bufferedReader.close();
                throw new PalettePluginLoadException("Palette plugin definition file \"" + file.getName() + "\" incomplete or corrupted, no jar file name found.");
            } while ((string4 = string3.trim()).length() == 0);
            variable = Variable.parseFrom(string4);
            if (variable == null) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Failed to parse palette plugin jar file name in palette definition file: \"" + file.getName() + "\".");
            }
            if (!variable.getID().equalsIgnoreCase("Plugin Jar File Name")) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Expected palette plugin jar file name variable, found \"" + variable.getID() + "\" instead, in palette definition file: \"" + file.getName() + "\".");
            }
            palettePlugin.m_jarFileName = variable.getValue();
            if (palettePlugin.m_jarFileName.length() == 0) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Empty palette plugin jar file name found in palette definition file: \"" + file.getName() + "\".");
            }
            do {
                if ((string3 = bufferedReader.readLine()) != null) continue;
                bufferedReader.close();
                throw new PalettePluginLoadException("Palette plugin definition file \"" + file.getName() + "\" incomplete or corrupted, no jar file name found.");
            } while ((string4 = string3.trim()).length() == 0);
            variable = Variable.parseFrom(string4);
            if (variable == null) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Failed to parse palette plugin jar file name in palette definition file: \"" + file.getName() + "\".");
            }
            if (!variable.getID().equalsIgnoreCase("Palette Class Name")) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Expected palette plugin jar file name variable, found \"" + variable.getID() + "\" instead, in palette definition file: \"" + file.getName() + "\".");
            }
            palettePlugin.m_paletteClassName = variable.getValue();
            if (palettePlugin.m_paletteClassName.length() == 0) {
                bufferedReader.close();
                throw new PalettePluginLoadException("Empty palette plugin jar file name found in palette definition file: \"" + file.getName() + "\".");
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PalettePluginLoadException("Missing palette plugin definition file \"" + file.getName() + "\": " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new PalettePluginLoadException("Read exception thrown while parsing palette plugin definition file \"" + file.getName() + "\": " + iOException.getMessage());
        }
        if (!palettePlugin.load()) {
            throw new PalettePluginLoadException("Failed to load palette plugin \"" + palettePlugin.m_jarFileName + "\".");
        }
        palettePlugin.m_paletteClass = null;
        try {
            palettePlugin.m_paletteClass = PaletteEditor.classLoader.loadClass(palettePlugin.m_paletteClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PalettePluginLoadException("Class " + palettePlugin.m_paletteClassName + " is missing or not loaded.");
        }
        if (!Palette.class.isAssignableFrom(palettePlugin.m_paletteClass)) {
            throw new PalettePluginLoadException("Class " + palettePlugin.m_paletteClassName + " does not extend Palette class.");
        }
        return palettePlugin;
    }

    public static int numberOfConfigFileTypes() {
        return CONFIG_FILE_TYPES.length;
    }

    public static String getConfigFileType(int n) {
        if (n < 0 || n >= CONFIG_FILE_TYPES.length) {
            return null;
        }
        return CONFIG_FILE_TYPES[n];
    }

    public static String getConfigFileTypesAsString() {
        String string = "";
        for (int i = 0; i < CONFIG_FILE_TYPES.length; ++i) {
            string = string + CONFIG_FILE_TYPES[i];
            if (i >= CONFIG_FILE_TYPES.length - 1) continue;
            string = string + ", ";
        }
        return string;
    }

    public static boolean hasConfigFileType(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return false;
        }
        for (int i = 0; i < CONFIG_FILE_TYPES.length; ++i) {
            if (!CONFIG_FILE_TYPES[i].equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public static int indexOfConfigFileType(String string) {
        if (string == null) {
            return -1;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return -1;
        }
        for (int i = 0; i < CONFIG_FILE_TYPES.length; ++i) {
            if (!CONFIG_FILE_TYPES[i].equalsIgnoreCase(string2)) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PalettePlugin)) {
            return false;
        }
        PalettePlugin palettePlugin = (PalettePlugin)object;
        if (this.m_name == null || palettePlugin.m_name == null) {
            return false;
        }
        return this.m_name.equalsIgnoreCase(palettePlugin.m_name);
    }

    public String toString() {
        return this.m_name;
    }
}

