/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Vector;

public class Serializer {
    private Serializer() {
    }

    public static byte[] serializeBoolean(boolean bl) {
        byte[] byArray = new byte[]{(byte)(bl ? 1 : 0)};
        return byArray;
    }

    public static boolean deserializeBoolean(byte[] byArray) {
        if (byArray == null || byArray.length != 1) {
            return false;
        }
        return byArray[0] != 0;
    }

    public static byte[] serializeShort(short s) {
        byte[] byArray = new byte[]{(byte)(s >> 8), (byte)s};
        return byArray;
    }

    public static short deserializeShort(byte[] byArray) {
        if (byArray == null || byArray.length != 2) {
            return -1;
        }
        return (short)(byArray[0] << 8 | byArray[1] & 0xFF);
    }

    public static byte[] serializeInteger(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        return byArray;
    }

    public static int deserializeInteger(byte[] byArray) {
        if (byArray == null || byArray.length != 4) {
            return -1;
        }
        return byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public static byte[] serializeLong(long l) {
        byte[] byArray = new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
        return byArray;
    }

    public static long deserializeLong(byte[] byArray) {
        if (byArray == null || byArray.length != 8) {
            return -1L;
        }
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l |= ((long)byArray[i] & 0xFFL) << (8 - i - 1 << 3);
        }
        return l;
    }

    public static byte[] serializeFloat(float f) {
        return Serializer.serializeInteger(Float.floatToIntBits(f));
    }

    public static float deserializeFloat(byte[] byArray) {
        return Float.intBitsToFloat(Serializer.deserializeInteger(byArray));
    }

    public static byte[] serializeDouble(double d) {
        return Serializer.serializeLong(Double.doubleToLongBits(d));
    }

    public static double deserializeDouble(byte[] byArray) {
        return Double.longBitsToDouble(Serializer.deserializeLong(byArray));
    }

    public static byte serializeByteCharacter(char c) {
        return (byte)c;
    }

    public static char deserializeByteCharacter(byte by) {
        return (char)(by & 0xFF);
    }

    public static byte[] serializeCharacter(char c) {
        byte[] byArray = new byte[]{(byte)(c >> 8), (byte)c};
        return byArray;
    }

    public static char deserializeCharacter(byte[] byArray) {
        if (byArray == null || byArray.length != 2) {
            return '\u0000';
        }
        return (char)(byArray[0] << 8 | byArray[1] & 0xFF);
    }

    public static byte[] serializeByteString(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        byte[] byArray = new byte[string.length()];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            byArray[n++] = (byte)string.charAt(i);
        }
        return byArray;
    }

    public static String deserializeByteString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return null;
        }
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            string = string + (char)(byArray[i] & 0xFF);
        }
        return string;
    }

    public static byte[] serializeString(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        byte[] byArray = new byte[string.length() * 2];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            byArray[n++] = (byte)(string.charAt(i) >> 8);
            byArray[n++] = (byte)string.charAt(i);
        }
        return byArray;
    }

    public static String deserializeString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0 || byArray.length % 2 != 0) {
            return null;
        }
        String string = "";
        for (int i = 0; i < byArray.length; i += 2) {
            string = string + (char)(byArray[i] << 8 | byArray[i + 1] & 0xFF);
        }
        return string;
    }

    public static byte[] serializeObject(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserializeObject(byte[] byArray) throws IOException {
        Object object;
        if (byArray == null || byArray.length < 1) {
            return null;
        }
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            object = objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
        return object;
    }

    public static byte[] serializeArray(Object[] objectArray) throws IOException {
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        Vector<byte[]> vector = new Vector<byte[]>(objectArray.length);
        int n = 4;
        byte[] byArray = null;
        for (int i = 0; i < objectArray.length; ++i) {
            byArray = Serializer.serializeObject(objectArray[i]);
            if (byArray == null) {
                throw new IOException("error serializing object");
            }
            n += 4 + byArray.length;
            vector.add(byArray);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        byteArrayOutputStream.write(Serializer.serializeInteger(vector.size()));
        for (int i = 0; i < vector.size(); ++i) {
            byteArrayOutputStream.write(Serializer.serializeInteger(((byte[])vector.elementAt(i)).length));
            byteArrayOutputStream.write((byte[])vector.elementAt(i));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Object[] deserializeArray(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        int n = -1;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray2 = new byte[4];
        byteArrayInputStream.read(byArray2);
        n = Serializer.deserializeInteger(byArray2);
        if (n < 1) {
            return null;
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            byArray2 = new byte[4];
            byteArrayInputStream.read(byArray2);
            int n2 = Serializer.deserializeInteger(byArray2);
            if (n2 < 1) {
                return null;
            }
            byArray2 = new byte[n2];
            byteArrayInputStream.read(byArray2);
            objectArray[i] = Serializer.deserializeObject(byArray2);
            if (objectArray[i] != null) continue;
            return null;
        }
        return objectArray;
    }

    public static boolean readBoolean(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return false;
        }
        byte[] byArray = new byte[1];
        inputStream.read(byArray);
        return Serializer.deserializeBoolean(byArray);
    }

    public static boolean writeBoolean(boolean bl, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            return false;
        }
        byte[] byArray = Serializer.serializeBoolean(bl);
        outputStream.write(byArray, 0, byArray.length);
        return true;
    }

    public static short readShort(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return -1;
        }
        byte[] byArray = new byte[2];
        inputStream.read(byArray);
        return Serializer.deserializeShort(byArray);
    }

    public static boolean writeShort(short s, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            return false;
        }
        byte[] byArray = Serializer.serializeShort(s);
        outputStream.write(byArray, 0, byArray.length);
        return true;
    }

    public static int readInteger(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return -1;
        }
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        return Serializer.deserializeInteger(byArray);
    }

    public static boolean writeInteger(int n, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            return false;
        }
        byte[] byArray = Serializer.serializeInteger(n);
        outputStream.write(byArray, 0, byArray.length);
        return true;
    }

    public static long readLong(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return -1L;
        }
        byte[] byArray = new byte[8];
        inputStream.read(byArray);
        return Serializer.deserializeLong(byArray);
    }

    public static boolean writeLong(long l, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            return false;
        }
        byte[] byArray = Serializer.serializeLong(l);
        outputStream.write(byArray, 0, byArray.length);
        return true;
    }

    public static float readFloat(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return -1.0f;
        }
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        return Serializer.deserializeFloat(byArray);
    }

    public static boolean writeFloat(float f, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            return false;
        }
        byte[] byArray = Serializer.serializeFloat(f);
        outputStream.write(byArray, 0, byArray.length);
        return true;
    }

    public static double readDouble(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return -1.0;
        }
        byte[] byArray = new byte[8];
        inputStream.read(byArray);
        return Serializer.deserializeDouble(byArray);
    }

    public static boolean writeDouble(double d, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            return false;
        }
        byte[] byArray = Serializer.serializeDouble(d);
        outputStream.write(byArray, 0, byArray.length);
        return true;
    }

    public static char readByteCharacter(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return '\u0000';
        }
        byte[] byArray = new byte[1];
        inputStream.read(byArray);
        return (char)(byArray[0] & 0xFF);
    }

    public static boolean writeByteCharacter(char c, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            return false;
        }
        byte[] byArray = new byte[]{(byte)c};
        outputStream.write(byArray, 0, byArray.length);
        return true;
    }

    public static char readCharacter(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return '\u0000';
        }
        byte[] byArray = new byte[2];
        inputStream.read(byArray);
        return Serializer.deserializeCharacter(byArray);
    }

    public static boolean writeCharacter(char c, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            return false;
        }
        byte[] byArray = Serializer.serializeCharacter(c);
        outputStream.write(byArray, 0, byArray.length);
        return true;
    }

    public static String readLine(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        char c = '\u0000';
        String string = new String("");
        byte[] byArray = new byte[2];
        while (true) {
            inputStream.read(byArray);
            c = Serializer.deserializeCharacter(byArray);
            if (c == '\n' || c == '\r') break;
            string = string + c;
        }
        return string;
    }

    public static String readToken(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        char c = '\u0000';
        String string = new String("");
        byte[] byArray = new byte[2];
        while (true) {
            inputStream.read(byArray);
            c = Serializer.deserializeCharacter(byArray);
            if (c == '\n' || c == '\r' || c == '\t' || c == ' ') break;
            string = string + c;
        }
        return string;
    }

    public static boolean writeByteString(String string, OutputStream outputStream) throws IOException {
        if (string == null || outputStream == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            byte[] byArray = new byte[]{(byte)string.charAt(i)};
            outputStream.write(byArray, 0, byArray.length);
        }
        return true;
    }

    public static boolean writeString(String string, OutputStream outputStream) throws IOException {
        if (string == null || outputStream == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            byte[] byArray = Serializer.serializeCharacter(string.charAt(i));
            outputStream.write(byArray, 0, byArray.length);
        }
        return true;
    }

    public static Object readObject(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        int n = Serializer.deserializeInteger(byArray);
        if (n < 1) {
            return null;
        }
        byte[] byArray2 = new byte[n];
        inputStream.read(byArray2);
        return Serializer.deserializeObject(byArray2);
    }

    public static boolean writeObject(Object object, OutputStream outputStream) throws IOException {
        if (object == null || outputStream == null) {
            return false;
        }
        byte[] byArray = Serializer.serializeObject(object);
        if (byArray == null) {
            return false;
        }
        byte[] byArray2 = Serializer.serializeInteger(byArray.length);
        if (byArray2 == null) {
            return false;
        }
        outputStream.write(byArray2, 0, byArray.length);
        outputStream.write(byArray, 0, byArray.length);
        return true;
    }

    public static Object[] readArray(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        int n = Serializer.deserializeInteger(byArray);
        if (n < 1) {
            return null;
        }
        byte[] byArray2 = new byte[n];
        inputStream.read(byArray2);
        return Serializer.deserializeArray(byArray2);
    }

    public static boolean writeArray(Object[] objectArray, OutputStream outputStream) throws IOException {
        if (objectArray == null || outputStream == null) {
            return false;
        }
        byte[] byArray = Serializer.serializeArray(objectArray);
        if (byArray == null) {
            return false;
        }
        byte[] byArray2 = Serializer.serializeInteger(byArray.length);
        if (byArray2 == null) {
            return false;
        }
        outputStream.write(byArray2, 0, byArray.length);
        outputStream.write(byArray, 0, byArray.length);
        return true;
    }
}

