/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.util.Vector;
import utilities.TaskListener;

public class Task {
    private int m_progress;
    private int m_length;
    private boolean m_cancelled;
    private Vector<TaskListener> m_listeners;

    public Task(int n) {
        this(n, null);
    }

    public Task(int n, TaskListener taskListener) {
        if (n <= 0) {
            throw new IllegalArgumentException("Task length must be greater than zero");
        }
        this.m_progress = 0;
        this.m_length = n;
        this.m_cancelled = false;
        this.m_listeners = new Vector();
        this.addListener(taskListener);
    }

    public int getProgress() {
        return this.m_progress;
    }

    public double getPercentCompleted() {
        return (double)this.m_progress / (double)this.m_length * 100.0;
    }

    public int getTaskLength() {
        return this.m_length;
    }

    public boolean isCompleted() {
        return this.m_progress >= this.m_length;
    }

    public boolean isCancelled() {
        return this.m_cancelled;
    }

    public boolean addProgress(int n) {
        if (n <= 0) {
            return false;
        }
        this.m_progress += n;
        this.notifyListeners();
        return true;
    }

    public boolean setProgress(int n) {
        if (n < 0) {
            return false;
        }
        this.m_progress = n;
        this.notifyListeners();
        return true;
    }

    public void setCompleted() {
        this.m_progress = this.m_length;
        this.notifyListeners();
    }

    public void cancel() {
        this.m_cancelled = true;
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            this.m_listeners.elementAt(i).taskCancelled(this);
        }
    }

    public boolean addListener(TaskListener taskListener) {
        if (taskListener == null) {
            return false;
        }
        this.m_listeners.add(taskListener);
        return true;
    }

    public boolean removeListener(TaskListener taskListener) {
        if (taskListener == null) {
            return false;
        }
        return this.m_listeners.remove(taskListener);
    }

    public void clearListeners() {
        this.m_listeners.clear();
    }

    public void notifyListeners() {
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            this.m_listeners.elementAt(i).taskProgressChanged(this);
        }
    }
}

