/*
 * Decompiled with CFR 0.152.
 */
package variable;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import variable.Variable;

public class VariableSystem {
    private Vector<Variable> m_variables = new Vector();
    private Vector<String> m_categories = new Vector();

    public int addCategory(String string) {
        if (string == null) {
            return -1;
        }
        String string2 = string.trim();
        if (string.length() == 0) {
            return -1;
        }
        for (int i = 0; i < this.m_categories.size(); ++i) {
            if (!string2.equalsIgnoreCase(this.m_categories.elementAt(i))) continue;
            return i;
        }
        this.m_categories.add(string2);
        return this.m_categories.size() - 1;
    }

    public int indexOfCategory(String string) {
        if (string == null || this.m_categories.size() == 0) {
            return -1;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return -1;
        }
        for (int i = 0; i < this.m_categories.size(); ++i) {
            if (!string2.equalsIgnoreCase(this.m_categories.elementAt(i))) continue;
            return i;
        }
        return -1;
    }

    public String categoryAt(int n) {
        if (n < 0 || n >= this.m_categories.size()) {
            return null;
        }
        return this.m_categories.elementAt(n);
    }

    public int size() {
        return this.m_variables.size();
    }

    public boolean contains(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return false;
        }
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (!this.m_variables.elementAt(i).getID().equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        String string3 = string.trim();
        if (string3.length() == 0) {
            return false;
        }
        int n = this.indexOfCategory(string2);
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (n != this.m_variables.elementAt(i).getCategory() || !this.m_variables.elementAt(i).getID().equalsIgnoreCase(string3)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Variable variable) {
        if (variable == null) {
            return false;
        }
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (this.m_variables.elementAt(i).getCategory() != variable.getCategory() || !this.m_variables.elementAt(i).getID().equalsIgnoreCase(variable.getID())) continue;
            return true;
        }
        return false;
    }

    public int indexOf(String string) {
        if (string == null) {
            return -1;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return -1;
        }
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (!this.m_variables.elementAt(i).getID().equalsIgnoreCase(string2)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(String string, String string2) {
        if (string == null) {
            return -1;
        }
        String string3 = string.trim();
        if (string3.length() == 0) {
            return -1;
        }
        int n = this.indexOfCategory(string2);
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (this.m_variables.elementAt(i).getCategory() != n || !this.m_variables.elementAt(i).getID().equalsIgnoreCase(string3)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(Variable variable) {
        if (variable == null) {
            return -1;
        }
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (this.m_variables.elementAt(i).getCategory() != variable.getCategory() || !this.m_variables.elementAt(i).getID().equalsIgnoreCase(variable.getID())) continue;
            return i;
        }
        return -1;
    }

    public Variable variableAt(int n) {
        if (n < 0 || n >= this.m_variables.size()) {
            return null;
        }
        return this.m_variables.elementAt(n);
    }

    public Variable getVariable(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return null;
        }
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (!this.m_variables.elementAt(i).getID().equalsIgnoreCase(string2)) continue;
            return this.m_variables.elementAt(i);
        }
        return null;
    }

    public Variable getVariable(String string, String string2) {
        if (string == null) {
            return null;
        }
        String string3 = string.trim();
        if (string3.length() == 0) {
            return null;
        }
        int n = this.indexOfCategory(string2);
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (this.m_variables.elementAt(i).getCategory() != n || !this.m_variables.elementAt(i).getID().equalsIgnoreCase(string3)) continue;
            return this.m_variables.elementAt(i);
        }
        return null;
    }

    public String getValue(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return null;
        }
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (!this.m_variables.elementAt(i).getID().equalsIgnoreCase(string2)) continue;
            return this.m_variables.elementAt(i).getValue();
        }
        return null;
    }

    public String getValue(String string, String string2) {
        if (string == null) {
            return null;
        }
        String string3 = string.trim();
        if (string3.length() == 0) {
            return null;
        }
        int n = this.indexOfCategory(string2);
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (this.m_variables.elementAt(i).getCategory() != n || !this.m_variables.elementAt(i).getID().equalsIgnoreCase(string3)) continue;
            return this.m_variables.elementAt(i).getValue();
        }
        return null;
    }

    public Vector<Variable> getVariablesInCategory(String string) {
        if (string == null) {
            return null;
        }
        int n = this.indexOfCategory(string);
        Vector<Variable> vector = new Vector<Variable>();
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (n != this.m_variables.elementAt(i).getCategory()) continue;
            vector.add(this.m_variables.elementAt(i));
        }
        return vector;
    }

    public boolean add(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (!this.contains(string, "")) {
            this.m_variables.add(new Variable(string, string2, -1));
            return true;
        }
        return false;
    }

    public boolean add(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return false;
        }
        if (!this.contains(string, string3)) {
            int n = this.addCategory(string3);
            this.m_variables.add(new Variable(string, string2, n));
            return true;
        }
        return false;
    }

    public boolean add(Variable variable) {
        if (variable == null || variable.getID().length() == 0) {
            return false;
        }
        if (!this.contains(variable) && variable.getCategory() < this.m_categories.size()) {
            this.m_variables.add(variable);
            return true;
        }
        return false;
    }

    public void add(Variable[] variableArray) {
        if (variableArray == null) {
            return;
        }
        for (int i = 0; i < variableArray.length; ++i) {
            this.add(variableArray[i]);
        }
    }

    public void add(Vector<Variable> vector) {
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.add(vector.elementAt(i));
        }
    }

    public void add(VariableSystem variableSystem) {
        if (variableSystem == null) {
            return;
        }
        for (int i = 0; i < variableSystem.m_variables.size(); ++i) {
            this.add(variableSystem.m_variables.elementAt(i));
        }
    }

    public void setValue(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        String string3 = string.trim();
        if (string.length() == 0) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (!string3.equalsIgnoreCase(this.m_variables.elementAt(i).getID())) continue;
            this.m_variables.elementAt(i).setValue(string2);
            bl = true;
        }
        if (!bl) {
            this.add(string, string2);
        }
    }

    public void setValue(String string, boolean bl) {
        this.setValue(string, bl ? "true" : "false");
    }

    public void setValue(String string, char c) {
        this.setValue(string, Character.toString(c));
    }

    public void setValue(String string, byte by) {
        this.setValue(string, Byte.toString(by));
    }

    public void setValue(String string, short s) {
        this.setValue(string, Short.toString(s));
    }

    public void setValue(String string, int n) {
        this.setValue(string, Integer.toString(n));
    }

    public void setValue(String string, long l) {
        this.setValue(string, Long.toString(l));
    }

    public void setValue(String string, float f) {
        this.setValue(string, Float.toString(f));
    }

    public void setValue(String string, double d) {
        this.setValue(string, Double.toString(d));
    }

    public void setValue(String string, Object object) {
        this.setValue(string, object == null ? "null" : object.toString());
    }

    public void setValue(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return;
        }
        String string4 = string.trim();
        if (string4.length() == 0) {
            return;
        }
        int n = this.indexOfCategory(string3);
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (n != this.m_variables.elementAt(i).getCategory() || !string4.equalsIgnoreCase(this.m_variables.elementAt(i).getID())) continue;
            this.m_variables.elementAt(i).setValue(string2);
            return;
        }
        this.add(string, string2, string3);
    }

    public void setValue(String string, boolean bl, String string2) {
        this.setValue(string, bl ? "true" : "false", string2);
    }

    public void setValue(String string, char c, String string2) {
        this.setValue(string, Character.toString(c), string2);
    }

    public void setValue(String string, short s, String string2) {
        this.setValue(string, Short.toString(s), string2);
    }

    public void setValue(String string, int n, String string2) {
        this.setValue(string, Integer.toString(n), string2);
    }

    public void setValue(String string, long l, String string2) {
        this.setValue(string, Long.toString(l), string2);
    }

    public void setValue(String string, float f, String string2) {
        this.setValue(string, Float.toString(f), string2);
    }

    public void setValue(String string, double d, String string2) {
        this.setValue(string, Double.toString(d), string2);
    }

    public void setValue(String string, Object object, String string2) {
        this.setValue(string, object == null ? "null" : object.toString(), string2);
    }

    public boolean remove(int n) {
        if (n < 0 || n >= this.m_variables.size()) {
            return false;
        }
        this.m_variables.remove(n);
        return true;
    }

    public boolean remove(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return false;
        }
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (!this.m_variables.elementAt(i).getID().equalsIgnoreCase(string2)) continue;
            this.m_variables.remove(i);
            return true;
        }
        return false;
    }

    public boolean remove(String string, String string2) {
        if (string == null) {
            return false;
        }
        String string3 = string.trim();
        if (string3.length() == 0) {
            return false;
        }
        int n = this.indexOfCategory(string2);
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (n != this.m_variables.elementAt(i).getCategory() || !this.m_variables.elementAt(i).getID().equalsIgnoreCase(string3)) continue;
            this.m_variables.remove(i);
            return true;
        }
        return false;
    }

    public boolean remove(Variable variable) {
        if (variable == null) {
            return false;
        }
        String string = variable.getID().trim();
        if (string.length() == 0) {
            return false;
        }
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (variable.getCategory() != this.m_variables.elementAt(i).getCategory() || !this.m_variables.elementAt(i).getID().equalsIgnoreCase(string)) continue;
            this.m_variables.remove(i);
            return true;
        }
        return false;
    }

    public void removeCategory(String string) {
        if (string == null) {
            return;
        }
        String string2 = string.trim();
        int n = this.indexOfCategory(string2);
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (n != this.m_variables.elementAt(i).getCategory()) continue;
            this.m_variables.remove(i);
            --i;
        }
    }

    public void clear() {
        this.m_variables.clear();
        this.m_categories.clear();
    }

    public void sort() {
        for (int i = 0; i < this.m_variables.size(); ++i) {
            for (int j = i; j < this.m_variables.size(); ++j) {
                if (this.m_variables.elementAt(i).getCategory() <= this.m_variables.elementAt(j).getCategory()) continue;
                Variable variable = this.m_variables.elementAt(i);
                this.m_variables.set(i, this.m_variables.elementAt(j));
                this.m_variables.set(j, variable);
            }
        }
    }

    public static VariableSystem readFrom(String string) {
        if (string == null) {
            return null;
        }
        return VariableSystem.readFrom(new File(string));
    }

    public static VariableSystem readFrom(File file) {
        VariableSystem variableSystem;
        if (file == null || !file.exists() || !file.isFile()) {
            return null;
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            variableSystem = new VariableSystem();
            String string2 = null;
            int n = -1;
            while ((string = bufferedReader.readLine()) != null) {
                String string3 = string.trim();
                if (string3.length() == 0) {
                    string2 = null;
                    n = -1;
                    continue;
                }
                if (string3.length() >= 2 && string3.charAt(0) == '[' && string3.charAt(string3.length() - 1) == ']') {
                    string2 = string3.substring(1, string3.length() - 1).trim();
                    n = variableSystem.addCategory(string2);
                    continue;
                }
                Variable variable = Variable.parseFrom(string3);
                if (variable == null) continue;
                variable.setCategory(n);
                variableSystem.add(variable);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return variableSystem;
    }

    public boolean writeTo(String string) {
        return this.writeTo(new File(string));
    }

    public boolean writeTo(File file) {
        if (file == null) {
            return false;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            this.writeTo(printWriter);
            printWriter.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void writeTo(PrintWriter printWriter) throws IOException {
        int n = -1;
        boolean bl = true;
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (n == -1 || n != this.m_variables.elementAt(i).getCategory()) {
                if (this.m_variables.elementAt(i).getCategory() != -1) {
                    if (!bl) {
                        printWriter.println();
                    }
                    printWriter.println("[" + this.m_categories.elementAt(this.m_variables.elementAt(i).getCategory()) + "]");
                    bl = false;
                }
                n = this.m_variables.elementAt(i).getCategory();
            }
            this.m_variables.elementAt(i).writeTo(printWriter);
            bl = false;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof VariableSystem)) {
            return false;
        }
        VariableSystem variableSystem = (VariableSystem)object;
        if (this.m_variables.size() != this.m_variables.size()) {
            return false;
        }
        for (int i = 0; i < this.m_variables.size(); ++i) {
            if (variableSystem.contains(this.m_variables.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String string = new String();
        for (int i = 0; i < this.m_variables.size(); ++i) {
            string = string + this.m_variables.elementAt(i);
            if (i >= this.m_variables.size() - 1) continue;
            string = string + ", ";
        }
        return string;
    }
}

