/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.regex.Pattern;

public class ExtendedClassLoader
extends ClassLoader {
    public ExtendedClassLoader() {
        this(ClassLoader.getSystemClassLoader());
    }

    public ExtendedClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, true);
    }

    @Override
    public Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.findSystemClass(string);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.findClass(string);
        return clazz;
    }

    public byte[] serializeClass(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        String string2 = string.trim();
        if (!Pattern.compile(".*\\.class$", 2).matcher(string2).matches()) {
            string2 = string2 + ".class";
        }
        int n = 0;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) != '.') continue;
            ++n;
        }
        String[] stringArray = string2.split("[.]", n);
        string2 = "bin";
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 + "/" + stringArray[i];
        }
        try {
            File file = new File(string2);
            if (!file.exists()) {
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            byArray = new byte[(int)file.length()];
            dataInputStream.readFully(byArray);
            dataInputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return byArray;
    }

    public Class<?> deserializeClass(String string, byte[] byArray) {
        return this.deserializeClass(string, byArray, true);
    }

    public Class<?> deserializeClass(String string, byte[] byArray, boolean bl) {
        Class<?> clazz;
        if (string == null || byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            try {
                clazz = this.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
            if (clazz == null) {
                try {
                    clazz = this.defineClass(string, byArray, 0, byArray.length);
                }
                catch (ClassFormatError classFormatError) {
                    return null;
                }
            }
            if (bl) {
                this.resolveClass(clazz);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return clazz;
    }
}

