/*
 * Decompiled with CFR 0.152.
 */
package variable;

import java.io.IOException;
import java.io.PrintWriter;

public class Variable {
    private int m_category = -1;
    private String m_id;
    private String m_value;
    public static final String SEPARATORS = ":=";
    public static final int NO_CATEGORY = -1;

    public Variable() {
        this("", "", -1);
    }

    public Variable(String string, String string2) {
        this(string, string2, -1);
    }

    public Variable(String string, String string2, int n) {
        this.m_id = string == null ? "" : string.trim();
        this.m_value = string2 == null ? "" : string2.trim();
        this.m_category = n < -1 ? -1 : n;
    }

    public int getCategory() {
        return this.m_category;
    }

    public String getID() {
        return this.m_id;
    }

    public String getValue() {
        return this.m_value;
    }

    public void setCategory(int n) {
        this.m_category = n < -1 ? -1 : n;
    }

    public void setID(String string) {
        this.m_id = string == null ? "" : string.trim();
    }

    public void setValue(String string) {
        this.m_value = string == null ? "" : string.trim();
    }

    public void setValue(boolean bl) {
        this.setValue(bl ? "true" : "false");
    }

    public void setValue(char c) {
        this.setValue(Character.toString(c));
    }

    public void setValue(byte by) {
        this.setValue(Byte.toString(by));
    }

    public void setValue(short s) {
        this.setValue(Short.toString(s));
    }

    public void setValue(int n) {
        this.setValue(Integer.toString(n));
    }

    public void setValue(long l) {
        this.setValue(Long.toString(l));
    }

    public void setValue(float f) {
        this.setValue(Float.toString(f));
    }

    public void setValue(double d) {
        this.setValue(Double.toString(d));
    }

    public void removeCategory() {
        this.m_category = -1;
    }

    public static Variable parseFrom(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.replaceAll("([\n\r]+|^[\t ]+|[\t ]+$)", "").split("[\t ]*[:=][\t ]*", 2);
        if (stringArray.length != 2) {
            return null;
        }
        return new Variable(stringArray[0], stringArray[1], -1);
    }

    public void writeTo(PrintWriter printWriter) throws IOException {
        this.writeTo(printWriter, SEPARATORS.charAt(0));
    }

    public void writeTo(PrintWriter printWriter, char c) throws IOException {
        if (printWriter == null || c == '\u0000') {
            return;
        }
        printWriter.println(this.m_id + c + (c == ':' ? " " : "") + this.m_value);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Variable)) {
            return false;
        }
        Variable variable = (Variable)object;
        return this.m_id.equalsIgnoreCase(variable.m_id);
    }

    public String toString() {
        return this.m_id + SEPARATORS.charAt(0) + " " + this.m_value;
    }
}

