/*
 * Decompiled with CFR 0.152.
 */
package palette;

import exception.PaletteReadException;
import exception.PaletteWriteException;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import palette.Palette;
import utilities.Utilities;

public class PaletteACT
extends Palette {
    protected byte[] m_data = null;
    public static final int BPP = 3;
    public static final int PALETTE_SIZE_RGB = 768;
    public static final String FILE_TYPE = "ACT";
    public static final String PALETTE_DESCRIPTION = "Default";

    public PaletteACT() {
        this(null);
    }

    public PaletteACT(File file) {
        super(file);
    }

    public int numberOfFileTypes() {
        return 1;
    }

    public String getFileType(int n) {
        return n == 0 ? FILE_TYPE : null;
    }

    public int indexOfFileType(String string) {
        if (string == null) {
            return -1;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return -1;
        }
        return FILE_TYPE.equalsIgnoreCase(string2) ? 0 : -1;
    }

    public String getPaletteDescription(int n) {
        return n == 0 ? PALETTE_DESCRIPTION : null;
    }

    public Color getPixel(int n, int n2, int n3) {
        if (!this.m_loaded || this.m_data == null || n2 < 0 || n3 < 0 || n2 > 15 || n3 > 15 || n != 0) {
            return null;
        }
        int n4 = n3 * 16 * 3 + n2 * 3;
        int n5 = this.m_data[n4] & 0xFF;
        int n6 = this.m_data[n4 + 1] & 0xFF;
        int n7 = this.m_data[n4 + 2] & 0xFF;
        if (n5 < 0 || n5 > 255) {
            System.out.println("Red channel exceeded 0-255 boundary in ACT file \"" + this.m_file.getName() + "\" with value: " + n5 + " at offset: " + n4);
        }
        if (n6 < 0 || n6 > 255) {
            System.out.println("Green channel exceeded 0-255 boundary in ACT file \"" + this.m_file.getName() + "\" with value: " + n6 + " at offset: " + n4 + 1);
        }
        if (n7 < 0 || n7 > 255) {
            System.out.println("Blue channel exceeded 0-255 boundary in ACT file \"" + this.m_file.getName() + "\" with value: " + n7 + " at offset: " + n4 + 2);
        }
        return new Color(n5 < 0 ? 0 : (n5 > 255 ? 255 : n5), n6 < 0 ? 0 : (n6 > 255 ? 255 : n6), n7 < 0 ? 0 : (n7 > 255 ? 255 : n7));
    }

    public boolean updatePixel(int n, int n2, Color color, int n3) {
        if (!this.m_loaded || this.m_data == null || color == null || n < 0 || n2 < 0 || n > 15 || n2 > 15 || n3 != 0) {
            return false;
        }
        int n4 = n2 * 16 * 3 + n * 3;
        this.m_data[n4] = (byte)color.getRed();
        this.m_data[n4 + 1] = (byte)color.getGreen();
        this.m_data[n4 + 2] = (byte)color.getBlue();
        return true;
    }

    public Color[] getColourData(int n) {
        if (n != 0 || !this.m_loaded || this.m_data == null) {
            return null;
        }
        Color[] colorArray = new Color[256];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                colorArray[i * 16 + j] = this.getPixel(j, i);
            }
        }
        return colorArray;
    }

    public boolean updateColourData(int n, int n2, Color[] colorArray) {
        if (n != 0) {
            return false;
        }
        int n3 = n2 * 256;
        if (colorArray.length - n3 < 256) {
            return false;
        }
        if (!this.m_loaded) {
            if (this.isInstantiable()) {
                this.m_data = new byte[768];
                this.m_loaded = true;
            } else {
                return false;
            }
        }
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                n4 = i * 16 * 3 + j * 3;
                n5 = n3 + i * 16 + j;
                this.m_data[n4] = (byte)colorArray[n5].getRed();
                this.m_data[n4 + 1] = (byte)colorArray[n5].getGreen();
                this.m_data[n4 + 2] = (byte)colorArray[n5].getBlue();
            }
        }
        return true;
    }

    public boolean fillWithColour(Color color, int n) {
        if (n > 0 || color == null) {
            return false;
        }
        if (!this.m_loaded) {
            if (this.isInstantiable()) {
                this.m_data = new byte[768];
                this.m_loaded = true;
            } else {
                return false;
            }
        }
        int n2 = 0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                n2 = i * 16 * 3 + j * 3;
                this.m_data[n2] = (byte)color.getRed();
                this.m_data[n2 + 1] = (byte)color.getGreen();
                this.m_data[n2 + 2] = (byte)color.getBlue();
            }
        }
        return true;
    }

    public boolean load() throws PaletteReadException {
        if (this.m_file == null || !this.m_file.exists()) {
            return false;
        }
        String string = Utilities.getFileExtension((String)this.m_file.getName());
        if (string == null) {
            throw new PaletteReadException("File " + this.m_file.getName() + " has no extension.");
        }
        if (!string.equalsIgnoreCase(FILE_TYPE)) {
            throw new PaletteReadException("File " + this.m_file.getName() + " has unsupported extension: " + string);
        }
        if (this.m_file.length() > Integer.MAX_VALUE) {
            throw new PaletteReadException("File \"" + this.m_file.getName() + "\" is too large to store in memory.");
        }
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[(int)this.m_file.length()];
        try {
            fileInputStream = new FileInputStream(this.m_file);
            ((InputStream)fileInputStream).read(byArray);
            ((InputStream)fileInputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PaletteReadException("File \"" + this.m_file.getName() + "\" not found.");
        }
        catch (IOException iOException) {
            throw new PaletteReadException("Error reading file \"" + this.m_file.getName() + "\": " + iOException.getMessage());
        }
        if (byArray.length < 768) {
            throw new PaletteReadException("Palette file \"" + this.m_file.getName() + " is incomplete or corrupted.");
        }
        this.m_data = byArray;
        this.m_loaded = true;
        return true;
    }

    public boolean save(String string) throws PaletteWriteException {
        if (!this.m_loaded || this.m_file == null) {
            throw new PaletteWriteException("Palette ACT file must be loaded and initialized with a file to be saved.");
        }
        String string2 = null;
        string2 = string == null ? this.getDefaultFileType() : string.trim();
        if (!this.hasFileType(string2)) {
            throw new PaletteWriteException("ACT palette file type \"" + string2 + "\" is not supported for writing.");
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.m_file));
            ((OutputStream)bufferedOutputStream).write(this.m_data);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PaletteWriteException("File " + this.m_file.getName() + " not found.");
        }
        catch (IOException iOException) {
            throw new PaletteWriteException("Error writing to file " + this.m_file.getName() + ": " + iOException.getMessage());
        }
        return true;
    }
}

