/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import logger.CommandLogEntry;
import logger.SystemLogEntry;
import server.SQLResult;
import server.Server;
import server.TableUpdateThread;
import shared.MessageBoxSystem;

public class ServerWindow
extends JFrame {
    private Server m_server = new Server();
    private TableUpdateThread m_tableUpdateThread;
    private MessageBoxSystem m_messageBoxSystem = new MessageBoxSystem();
    private JMenuBar serverMenuBar;
    private JMenu serverFileMenu;
    private JMenuItem serverFileConnectMenuItem;
    private JMenuItem serverFileDisconnectMenuItem;
    private JMenuItem serverFileExitMenuItem;
    private JMenu serverDatabaseMenu;
    private JMenuItem serverDatabaseDeleteUserMenuItem;
    private JMenuItem serverDatabaseExecuteQueryMenuItem;
    private JMenuItem serverDatabaseExecuteUpdateMenuItem;
    private JMenu serverTablesMenu;
    private JMenuItem serverTablesCreateMenuItem;
    private JMenuItem serverTablesDeleteMenuItem;
    private JMenuItem serverTablesResetMenuItem;
    private JTabbedPane serverTabbedPane;
    private JPanel systemLogPanel;
    private JScrollPane systemLogScrollPane;
    private JTable systemLogTable;
    private DefaultTableModel systemLogTableModel;
    private JPanel commandLogPanel;
    private JScrollPane commandLogScrollPane;
    private JTable commandLogTable;
    private DefaultTableModel commandLogTableModel;
    private JPanel userDataPanel;
    private JScrollPane userDataScrollPane;
    private JTable userDataTable;
    private JPanel userProfilePanel;
    private JScrollPane userProfileScrollPane;
    private JTable userProfileTable;
    private JPanel userContactPanel;
    private JScrollPane userContactScrollPane;
    private JTable userContactTable;
    private JPanel userGroupPanel;
    private JScrollPane userGroupScrollPane;
    private JTable userGroupTable;
    private static final long serialVersionUID = 1L;

    public ServerWindow() {
        this.m_tableUpdateThread = new TableUpdateThread();
        this.initComponents();
    }

    public void initialize() {
        this.initialize(25500);
    }

    public void initialize(int port) {
        this.m_server.initialize(port, this);
        this.m_messageBoxSystem.initialize();
        this.m_tableUpdateThread.initialize(this.m_server.getDBMS(), this.userDataTable, this.userProfileTable, this.userContactTable, this.userGroupTable);
        this.setVisible(true);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.setTitle("Serious Messenger Server");
        this.setCursor(new Cursor(0));
        this.setMinimumSize(new Dimension(640, 480));
        this.setName("ServerWindow");
        this.serverMenuBar = new JMenuBar();
        this.serverFileMenu = new JMenu();
        this.serverFileConnectMenuItem = new JMenuItem();
        this.serverFileDisconnectMenuItem = new JMenuItem();
        this.serverFileExitMenuItem = new JMenuItem();
        this.serverDatabaseMenu = new JMenu();
        this.serverDatabaseDeleteUserMenuItem = new JMenuItem();
        this.serverDatabaseExecuteQueryMenuItem = new JMenuItem();
        this.serverDatabaseExecuteUpdateMenuItem = new JMenuItem();
        this.serverTablesMenu = new JMenu();
        this.serverTablesCreateMenuItem = new JMenuItem();
        this.serverTablesDeleteMenuItem = new JMenuItem();
        this.serverTablesResetMenuItem = new JMenuItem();
        this.serverTabbedPane = new JTabbedPane();
        this.systemLogPanel = new JPanel();
        this.systemLogScrollPane = new JScrollPane();
        this.systemLogTable = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.commandLogPanel = new JPanel();
        this.commandLogScrollPane = new JScrollPane();
        this.commandLogTable = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.userDataPanel = new JPanel();
        this.userDataScrollPane = new JScrollPane();
        this.userDataTable = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.userProfilePanel = new JPanel();
        this.userProfileScrollPane = new JScrollPane();
        this.userProfileTable = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.userContactPanel = new JPanel();
        this.userContactScrollPane = new JScrollPane();
        this.userContactTable = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.userGroupPanel = new JPanel();
        this.userGroupScrollPane = new JScrollPane();
        this.userGroupTable = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.systemLogTableModel = new DefaultTableModel(null, new String[]{"Time", "Type", "Message"});
        this.systemLogTable.setModel(this.systemLogTableModel);
        this.systemLogScrollPane.setViewportView(this.systemLogTable);
        GroupLayout commandLogPanelLayout = new GroupLayout(this.systemLogPanel);
        this.systemLogPanel.setLayout(commandLogPanelLayout);
        commandLogPanelLayout.setHorizontalGroup(commandLogPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.systemLogScrollPane, -1, 795, Short.MAX_VALUE));
        commandLogPanelLayout.setVerticalGroup(commandLogPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.systemLogScrollPane, -1, 551, Short.MAX_VALUE));
        this.serverTabbedPane.addTab("System Log", this.systemLogPanel);
        this.commandLogTableModel = new DefaultTableModel(null, new String[]{"Time", "UserName", "Command"});
        this.commandLogTable.setModel(this.commandLogTableModel);
        this.commandLogScrollPane.setViewportView(this.commandLogTable);
        GroupLayout errorLogPanelLayout = new GroupLayout(this.commandLogPanel);
        this.commandLogPanel.setLayout(errorLogPanelLayout);
        errorLogPanelLayout.setHorizontalGroup(errorLogPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commandLogScrollPane, -1, 795, Short.MAX_VALUE));
        errorLogPanelLayout.setVerticalGroup(errorLogPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commandLogScrollPane, -1, 551, Short.MAX_VALUE));
        this.serverTabbedPane.addTab("Command Log", this.commandLogPanel);
        DefaultTableModel userDataTableModel = new DefaultTableModel(null, new String[]{"UserName", "Password", "IPAddress", "LastLogin", "JoinDate"});
        this.userDataTable.setModel(userDataTableModel);
        this.userDataScrollPane.setViewportView(this.userDataTable);
        GroupLayout userDataPanelLayout = new GroupLayout(this.userDataPanel);
        this.userDataPanel.setLayout(userDataPanelLayout);
        userDataPanelLayout.setHorizontalGroup(userDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userDataScrollPane, -1, 795, Short.MAX_VALUE));
        userDataPanelLayout.setVerticalGroup(userDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userDataScrollPane, -1, 551, Short.MAX_VALUE));
        this.serverTabbedPane.addTab("User Data", this.userDataPanel);
        DefaultTableModel userProfileTableModel = new DefaultTableModel(null, new String[]{"UserName", "FirstName", "MiddleName", "LastName", "Gender", "BirthDate", "Email", "HomePhone", "MobilePhone", "WorkPhone", "Country", "StateProv", "ZipPostal"});
        this.userProfileTable.setModel(userProfileTableModel);
        this.userProfileScrollPane.setViewportView(this.userProfileTable);
        GroupLayout userProfilePanelLayout = new GroupLayout(this.userProfilePanel);
        this.userProfilePanel.setLayout(userProfilePanelLayout);
        userProfilePanelLayout.setHorizontalGroup(userProfilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userProfileScrollPane, -1, 795, Short.MAX_VALUE));
        userProfilePanelLayout.setVerticalGroup(userProfilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userProfileScrollPane, -1, 551, Short.MAX_VALUE));
        this.serverTabbedPane.addTab("User Profile", this.userProfilePanel);
        DefaultTableModel userContactTableModel = new DefaultTableModel(null, new String[]{"UserName", "Contact", "GroupName", "Blocked"});
        this.userContactTable.setModel(userContactTableModel);
        this.userContactScrollPane.setViewportView(this.userContactTable);
        GroupLayout userContactPanelLayout = new GroupLayout(this.userContactPanel);
        this.userContactPanel.setLayout(userContactPanelLayout);
        userContactPanelLayout.setHorizontalGroup(userContactPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userContactScrollPane, -1, 795, Short.MAX_VALUE));
        userContactPanelLayout.setVerticalGroup(userContactPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userContactScrollPane, -1, 551, Short.MAX_VALUE));
        this.serverTabbedPane.addTab("User Contact", this.userContactPanel);
        DefaultTableModel userGroupTableModel = new DefaultTableModel(null, new String[]{"UserName", "UserGroup"});
        this.userGroupTable.setModel(userGroupTableModel);
        this.userGroupScrollPane.setViewportView(this.userGroupTable);
        GroupLayout userGroupPanelLayout = new GroupLayout(this.userGroupPanel);
        this.userGroupPanel.setLayout(userGroupPanelLayout);
        userGroupPanelLayout.setHorizontalGroup(userGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userGroupScrollPane, -1, 795, Short.MAX_VALUE));
        userGroupPanelLayout.setVerticalGroup(userGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userGroupScrollPane, -1, 551, Short.MAX_VALUE));
        this.serverTabbedPane.addTab("User Group", this.userGroupPanel);
        this.serverFileMenu.setText("File");
        this.serverFileConnectMenuItem.setText("Connect to SQL Database");
        this.serverFileConnectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerWindow.this.serverFileConnectMenuItemActionPerformed(evt);
            }
        });
        this.serverFileMenu.add(this.serverFileConnectMenuItem);
        this.serverFileDisconnectMenuItem.setText("Disconnect from SQL Database");
        this.serverFileDisconnectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerWindow.this.serverFileDisconnectMenuItemActionPerformed(evt);
            }
        });
        this.serverFileMenu.add(this.serverFileDisconnectMenuItem);
        this.serverFileExitMenuItem.setText("Exit");
        this.serverFileExitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerWindow.this.serverFileExitMenuItemActionPerformed(evt);
            }
        });
        this.serverFileMenu.add(this.serverFileExitMenuItem);
        this.serverMenuBar.add(this.serverFileMenu);
        this.serverDatabaseMenu.setText("Database");
        this.serverDatabaseDeleteUserMenuItem.setText("Delete User");
        this.serverDatabaseDeleteUserMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerWindow.this.serverDatabaseDeleteUserMenuItemActionPerformed(evt);
            }
        });
        this.serverDatabaseMenu.add(this.serverDatabaseDeleteUserMenuItem);
        this.serverDatabaseExecuteQueryMenuItem.setText("Execute Query");
        this.serverDatabaseExecuteQueryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerWindow.this.serverDatabaseExecuteQueryMenuItemActionPerformed(evt);
            }
        });
        this.serverDatabaseMenu.add(this.serverDatabaseExecuteQueryMenuItem);
        this.serverDatabaseExecuteUpdateMenuItem.setText("Execute Update");
        this.serverDatabaseExecuteUpdateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerWindow.this.serverDatabaseExecuteUpdateMenuItemActionPerformed(evt);
            }
        });
        this.serverDatabaseMenu.add(this.serverDatabaseExecuteUpdateMenuItem);
        this.serverMenuBar.add(this.serverDatabaseMenu);
        this.serverTablesMenu.setText("Tables");
        this.serverTablesCreateMenuItem.setText("Create");
        this.serverTablesCreateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerWindow.this.serverTablesCreateMenuItemActionPerformed(evt);
            }
        });
        this.serverTablesMenu.add(this.serverTablesCreateMenuItem);
        this.serverTablesDeleteMenuItem.setText("Delete");
        this.serverTablesDeleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerWindow.this.serverTablesDeleteMenuItemActionPerformed(evt);
            }
        });
        this.serverTablesMenu.add(this.serverTablesDeleteMenuItem);
        this.serverTablesResetMenuItem.setText("Reset");
        this.serverTablesResetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerWindow.this.serverTablesResetMenuItemActionPerformed(evt);
            }
        });
        this.serverTablesMenu.add(this.serverTablesResetMenuItem);
        this.serverMenuBar.add(this.serverTablesMenu);
        this.setJMenuBar(this.serverMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serverTabbedPane, -1, 800, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serverTabbedPane, GroupLayout.Alignment.TRAILING, -1, 579, Short.MAX_VALUE));
        this.pack();
    }

    public void addSystemLogEntry(SystemLogEntry e) {
        if (e == null) {
            return;
        }
        this.systemLogTableModel.addRow(this.m_server.getLastSystemLogEntryAsArray());
    }

    public void addCommandLogEntry(CommandLogEntry e) {
        if (e == null) {
            return;
        }
        this.commandLogTableModel.addRow(this.m_server.getLastCommandLogEntryAsArray());
    }

    private void serverFileConnectMenuItemActionPerformed(ActionEvent evt) {
        if (!this.m_server.databaseConnnected()) {
            this.m_server.databaseConnect();
            this.m_tableUpdateThread.setDBMS(this.m_server.getDBMS());
        } else {
            this.m_messageBoxSystem.show(null, "Already connected to database.", "Already Connected", 1);
        }
    }

    private void serverFileDisconnectMenuItemActionPerformed(ActionEvent evt) {
        if (this.m_server.databaseConnnected()) {
            this.m_server.databaseDisconnect();
            this.m_tableUpdateThread.setDBMS(null);
        } else {
            this.m_messageBoxSystem.show(null, "Not connected to database.", "Not Connected", 1);
        }
    }

    private void serverFileExitMenuItemActionPerformed(ActionEvent evt) {
        this.m_server.databaseDisconnect();
        System.exit(0);
    }

    private void serverDatabaseDeleteUserMenuItemActionPerformed(ActionEvent evt) {
        String userName = JOptionPane.showInputDialog(null, "Username:", "Delete User", 3);
        if (userName == null) {
            return;
        }
        boolean userDeleted = this.m_server.deleteUser(userName);
        if (userDeleted) {
            this.m_messageBoxSystem.show(null, "User deleted successfully!", "User Deleted", 1);
        } else {
            this.m_messageBoxSystem.show(null, "Unable to delete user.", "Unable to Delete User", 1);
        }
    }

    private void serverDatabaseExecuteQueryMenuItemActionPerformed(ActionEvent evt) {
        String query = JOptionPane.showInputDialog(null, "What do you wish to query?", "Query Database", 3);
        if (query == null) {
            return;
        }
        SQLResult result = this.m_server.executeQuery(query);
        this.m_messageBoxSystem.show(null, result, "Query Results", 1);
    }

    private void serverDatabaseExecuteUpdateMenuItemActionPerformed(ActionEvent evt) {
        String query = JOptionPane.showInputDialog(null, "Update Database", "What do you wish to update?", 3);
        if (query == null) {
            return;
        }
        int updated = this.m_server.executeUpdate(query);
        this.m_messageBoxSystem.show(null, "Update result: " + updated, "Update Results", 1);
    }

    private void serverTablesCreateMenuItemActionPerformed(ActionEvent evt) {
        int result = JOptionPane.showConfirmDialog(null, "Are you sure you wish to create all tables?", "Create Tables", 1);
        if (result == 0) {
            this.m_server.createTables();
        }
    }

    private void serverTablesDeleteMenuItemActionPerformed(ActionEvent evt) {
        int result = JOptionPane.showConfirmDialog(null, "Are you sure you wish to delete all tables?", "Delete Tables", 1);
        if (result == 0) {
            this.m_server.dropTables();
        }
    }

    private void serverTablesResetMenuItemActionPerformed(ActionEvent evt) {
        int result = JOptionPane.showConfirmDialog(null, "Are you sure you wish to reset (clear) all tables?", "Reset Tables", 1);
        if (result == 0) {
            this.m_server.resetTables();
        }
    }
}

