/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import signal.Signal;

public class BlockContactSignal
extends Signal {
    private String m_userName;
    private boolean m_blocked;
    public static final int LENGTH = 73;

    private BlockContactSignal() {
        super(16);
    }

    public BlockContactSignal(String userName, boolean blocked) {
        super(16);
        this.m_userName = userName;
        this.m_blocked = blocked;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public boolean getBlocked() {
        return this.m_blocked;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_userName, 32);
        return checksum += ByteStream.getChecksum(this.m_blocked);
    }

    public static BlockContactSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        BlockContactSignal s2 = new BlockContactSignal();
        s2.m_userName = byteStream.nextString(32);
        s2.m_blocked = byteStream.nextBoolean();
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addStringFixedLength(this.m_userName, 32);
        byteStream.addBoolean(this.m_blocked);
        byteStream.addLong(this.checksum());
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return BlockContactSignal.readFrom(byteStream);
    }
}

