/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import signal.Signal;

public class PasswordChangedSignal
extends Signal {
    private boolean m_passwordChanged;
    public static final int LENGTH = 9;

    private PasswordChangedSignal() {
        super(11);
    }

    public PasswordChangedSignal(boolean passwordChanged) {
        super(11);
        this.m_passwordChanged = passwordChanged;
    }

    public boolean getPasswordChanged() {
        return this.m_passwordChanged;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        return checksum += ByteStream.getChecksum(this.m_passwordChanged);
    }

    public static PasswordChangedSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        PasswordChangedSignal s2 = new PasswordChangedSignal();
        s2.m_passwordChanged = byteStream.nextBoolean();
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addBoolean(this.m_passwordChanged);
        byteStream.addLong(this.checksum());
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return PasswordChangedSignal.readFrom(byteStream);
    }
}

