/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import signal.Signal;

public class UserCreatedSignal
extends Signal {
    private boolean m_created;
    public static final int LENGTH = 9;

    private UserCreatedSignal() {
        super(22);
    }

    public UserCreatedSignal(boolean created) {
        super(22);
        this.m_created = created;
    }

    public boolean getCreated() {
        return this.m_created;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        return checksum += ByteStream.getChecksum(this.m_created);
    }

    public static UserCreatedSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        UserCreatedSignal s2 = new UserCreatedSignal();
        s2.m_created = byteStream.nextBoolean();
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addBoolean(this.m_created);
        byteStream.addLong(this.checksum());
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return UserCreatedSignal.readFrom(byteStream);
    }
}

