/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import signal.Signal;

public class UserTypingSignal
extends Signal {
    private boolean m_typing;
    private String m_userName;
    private String m_contactUserName;
    public static final int LENGTH = 137;

    private UserTypingSignal() {
        super(8);
    }

    public UserTypingSignal(boolean typing, String userName, String contactUserName) {
        super(8);
        this.m_typing = typing;
        this.m_userName = userName;
        this.m_contactUserName = contactUserName;
    }

    public boolean getTyping() {
        return this.m_typing;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getContactUserName() {
        return this.m_contactUserName;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_typing);
        checksum += ByteStream.getChecksum(this.m_userName, 32);
        return checksum += ByteStream.getChecksum(this.m_contactUserName, 32);
    }

    public static UserTypingSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        UserTypingSignal s2 = new UserTypingSignal();
        s2.m_typing = byteStream.nextBoolean();
        s2.m_userName = byteStream.nextString(32);
        s2.m_contactUserName = byteStream.nextString(32);
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addBoolean(this.m_typing);
        byteStream.addStringFixedLength(this.m_userName, 32);
        byteStream.addStringFixedLength(this.m_contactUserName, 32);
        byteStream.addLong(this.checksum());
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return UserTypingSignal.readFrom(byteStream);
    }
}

