/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ClientState;
import client.ClientThread;
import client.ClientWindow;
import client.ConversationWindow;
import client.Message;
import client.ServerDisconnectHandler;
import client.ServerInputSignalQueue;
import client.ServerOutputSignalQueue;
import client.User;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import shared.MessageBoxSystem;
import shared.StatusType;
import shared.UserNetworkData;
import signal.AddContactSignal;
import signal.BlockContactSignal;
import signal.BroadcastLoginSignal;
import signal.ChangeNicknameSignal;
import signal.ChangePasswordSignal;
import signal.ChangePersonalMessageSignal;
import signal.ChangeStatusSignal;
import signal.CreateUserSignal;
import signal.DeleteContactSignal;
import signal.LoginRequestSignal;
import signal.LogoutSignal;
import signal.MessageSignal;
import signal.Signal;

public class Client
extends User {
    private int m_state = 0;
    private Socket m_connection;
    private DataInputStream m_in;
    private DataOutputStream m_out;
    private ServerInputSignalQueue m_inSignalQueue = null;
    private ServerOutputSignalQueue m_outSignalQueue = null;
    private ClientThread m_clientThread = null;
    private MessageBoxSystem m_messageBoxSystem = null;
    private String m_hostName;
    private int m_port;
    private ServerDisconnectHandler m_disconnectHandler = null;
    private int m_timeElapsed = 0;
    private boolean m_awaitingResponse = false;
    private ClientWindow m_clientWindow;

    public Client(ClientWindow clientWindow) {
        this.m_clientWindow = clientWindow;
        this.m_messageBoxSystem = new MessageBoxSystem();
    }

    public void initialize() {
        this.initialize("localhost", 25500);
    }

    public void initialize(String hostName, int port) {
        this.m_hostName = hostName == null ? "localhost" : hostName;
        this.m_port = port < 0 || port > 65355 ? 25500 : port;
    }

    public Socket getConnection() {
        return this.m_connection;
    }

    public boolean isConnected() {
        return this.m_state > 0 && !this.timeout();
    }

    public DataInputStream getInputStream() {
        return this.m_in;
    }

    public DataOutputStream getOutputStream() {
        return this.m_out;
    }

    public int getClientState() {
        return this.m_state;
    }

    public void connect() {
        if (this.m_state != 0) {
            return;
        }
        this.setState((byte)1);
        this.m_timeElapsed = 0;
        this.m_awaitingResponse = false;
        this.m_messageBoxSystem.initialize();
        try {
            this.m_connection = new Socket(this.m_hostName, this.m_port);
            this.m_out = new DataOutputStream(this.m_connection.getOutputStream());
            this.m_in = new DataInputStream(this.m_connection.getInputStream());
            if (this.m_outSignalQueue == null || this.m_outSignalQueue.isTerminated()) {
                this.m_outSignalQueue = new ServerOutputSignalQueue();
                this.m_outSignalQueue.initialize(this, this.m_clientWindow, this.m_out);
            }
            if (this.m_inSignalQueue == null || this.m_inSignalQueue.isTerminated()) {
                this.m_inSignalQueue = new ServerInputSignalQueue();
                this.m_inSignalQueue.initialize(this, this.m_clientWindow, this.m_in, this.m_outSignalQueue, this.m_messageBoxSystem);
            }
            if (this.m_clientThread == null || this.m_clientThread.isTerminated()) {
                this.m_clientThread = new ClientThread();
                this.m_clientThread.initialize(this);
            }
            if (this.m_disconnectHandler == null || this.m_disconnectHandler.isTerminated()) {
                this.m_disconnectHandler = new ServerDisconnectHandler();
                this.m_disconnectHandler.initialize(this, this.m_messageBoxSystem);
            }
        }
        catch (IOException e) {
            this.disconnect();
            this.m_messageBoxSystem.show(null, "Unable to connect to Serious Server at " + this.m_hostName + ":" + this.m_port + ": " + e.getMessage(), "Error Connecting to Server", 0);
        }
    }

    public void disconnect() {
        this.setState((byte)0);
        try {
            if (this.m_out != null) {
                this.m_out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.m_in != null) {
                this.m_in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.m_connection != null) {
                this.m_connection.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_out = null;
        this.m_in = null;
        this.m_connection = null;
    }

    public void createAccount(String userName, String password) {
        if (this.m_state != 1) {
            return;
        }
        this.m_outSignalQueue.addSignal(new CreateUserSignal(userName, password));
    }

    public void login(String userName, String password) {
        if (this.m_state != 1) {
            return;
        }
        this.m_userName = userName;
        this.m_password = password;
        this.m_outSignalQueue.addSignal(new LoginRequestSignal(userName, password));
        this.setState((byte)2);
    }

    public void logout() {
        if (this.m_state == 0) {
            return;
        }
        this.m_outSignalQueue.addSignal(new LogoutSignal(this.m_userName));
    }

    public void authenticated() {
        this.setState((byte)3);
        this.setStatus((byte)1);
        this.m_outSignalQueue.addSignal(new BroadcastLoginSignal(this));
    }

    public void changePassword(String oldPassword, String newPassword) {
        if (oldPassword == null || newPassword == null) {
            return;
        }
        this.m_outSignalQueue.addSignal(new ChangePasswordSignal(this.m_userName, oldPassword, newPassword));
    }

    public void addContact(String contactUserName) {
        if (contactUserName == null) {
            return;
        }
        this.m_outSignalQueue.addSignal(new AddContactSignal(contactUserName));
    }

    public void deleteContact(String contactUserName) {
        if (contactUserName == null) {
            return;
        }
        this.m_outSignalQueue.addSignal(new DeleteContactSignal(contactUserName));
    }

    public void blockContact(String contactUserName) {
        if (contactUserName == null) {
            return;
        }
        this.m_outSignalQueue.addSignal(new BlockContactSignal(contactUserName, true));
    }

    public void unblockContact(String contactUserName) {
        if (contactUserName == null) {
            return;
        }
        this.m_outSignalQueue.addSignal(new BlockContactSignal(contactUserName, false));
    }

    public void updateNickName(String nickName) {
        if (nickName == null) {
            return;
        }
        this.setNickName(nickName);
        this.m_outSignalQueue.addSignal(new ChangeNicknameSignal(this.m_userName, this.m_nickName));
    }

    public void updatePersonalMessage(String personalMessage) {
        if (personalMessage == null) {
            return;
        }
        this.setPersonalMessage(personalMessage);
        this.m_outSignalQueue.addSignal(new ChangePersonalMessageSignal(this.m_userName, this.m_personalMessage));
    }

    public void updateStatus(byte status) {
        if (!StatusType.isValid(status)) {
            return;
        }
        this.setStatus(status);
        this.m_outSignalQueue.addSignal(new ChangeStatusSignal(this.m_userName, this.m_status));
    }

    public void updateUserNickName(String userName, String nickName) {
        if (nickName == null) {
            return;
        }
        UserNetworkData contact = this.getContact(userName);
        if (contact != null) {
            contact.setNickName(nickName);
        }
    }

    public void updateUserPersonalMessage(String userName, String personalMessage) {
        if (personalMessage == null) {
            return;
        }
        UserNetworkData contact = this.getContact(userName);
        if (contact != null) {
            contact.setPersonalMessage(personalMessage);
        }
    }

    public void updateUserStatus(String userName, byte status) {
        if (!StatusType.isValid(status)) {
            return;
        }
        UserNetworkData contact = this.getContact(userName);
        if (contact != null) {
            contact.setStatus(status);
        }
    }

    public void sendMessage(String message, long messageID, String userName, String contactUserName) {
        this.m_outSignalQueue.addSignal(new MessageSignal(message, messageID, userName, contactUserName));
    }

    public void receiveMessage(String message, long messageID, String contactUserName) {
        ConversationWindow conversationWindow = this.m_clientWindow.startConversation(contactUserName);
        if (conversationWindow != null) {
            conversationWindow.receiveMessage(message, messageID, contactUserName);
        }
    }

    public void announce(String message) {
        if (message == null) {
            return;
        }
        int i = 0;
        while (i < this.m_contacts.size()) {
            if (((UserNetworkData)this.m_contacts.elementAt(i)).getStatus() != 0) {
                this.m_outSignalQueue.addSignal(new MessageSignal(message, Message.nextID(), this.m_userName, ((UserNetworkData)this.m_contacts.elementAt(i)).getUserName()));
            }
            ++i;
        }
    }

    public boolean ping() {
        if (!this.m_awaitingResponse && (long)this.m_timeElapsed >= 5000L) {
            this.m_timeElapsed = 0;
            this.m_awaitingResponse = true;
            this.m_outSignalQueue.addSignal(new Signal(1));
            return true;
        }
        return false;
    }

    public void pong() {
        this.m_timeElapsed = 0;
        this.m_awaitingResponse = false;
    }

    public boolean awaitingResponse() {
        return this.m_awaitingResponse;
    }

    public int timeElapsed() {
        return this.m_timeElapsed;
    }

    public void addTime(long time) {
        if (time <= 0L) {
            return;
        }
        this.m_timeElapsed = (int)((long)this.m_timeElapsed + time);
    }

    public boolean timeout() {
        return this.m_awaitingResponse && (long)this.m_timeElapsed >= 7500L;
    }

    public boolean setState(byte newState) {
        if (!ClientState.isValid(newState)) {
            return false;
        }
        if (this.m_state == newState) {
            return true;
        }
        if (this.m_state == 0) {
            if (newState == 1) {
                this.m_state = newState;
                this.m_status = 0;
                return true;
            }
            return false;
        }
        if (this.m_state == 1) {
            if (newState == 2) {
                this.m_state = newState;
                this.m_status = 0;
                return true;
            }
            if (newState == 0) {
                this.m_state = newState;
                this.m_status = 0;
                return true;
            }
            return false;
        }
        if (this.m_state == 2) {
            if (newState == 3) {
                this.m_state = newState;
                this.m_status = 1;
                return true;
            }
            if (newState == 0) {
                this.m_state = newState;
                this.m_status = 0;
            }
        } else if (this.m_state == 3 && newState == 0) {
            this.m_state = newState;
            this.m_status = 0;
        }
        return true;
    }

    public void readSignal() {
        this.m_inSignalQueue.readSignal();
    }
}

