/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.Client;
import client.ContactPanel;
import client.Conversation;
import client.ConversationWindow;
import client.ProfileWindow;
import client.UserPanel;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import shared.StatusType;
import shared.UserData;
import shared.UserNetworkData;

public class ClientWindow
extends JFrame
implements ActionListener,
KeyListener {
    private Client m_client = new Client(this);
    private Vector<ConversationWindow> m_conversationWindows = new Vector();
    private JButton announceButton;
    private JPanel contactListPanel;
    private JScrollPane contactListScrollPane;
    private JLabel displayPicIconLabel;
    private Vector<ContactPanel> contactPanels;
    private JTabbedPane groupsTabbedPane;
    private JTextField nickNameTextField;
    private JTextField personalMessageTextField;
    private JLabel searchLabel;
    private JTextField searchTextField;
    private JComboBox statusComboBox;
    private JPanel userInfoPanel;
    private JPanel utilityPanel;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem fileSignInMenuItem;
    private JMenuItem fileSignOutMenuItem;
    private JMenuItem fileCreateAccountMenuItem;
    private JMenuItem fileChangePasswordMenuItem;
    private JMenuItem fileExitMenuItem;
    private JMenu contactsMenu;
    private JMenuItem contactsStartConversationMenuItem;
    private JMenuItem contactsAddContactMenuItem;
    private JMenuItem contactsDeleteContactMenuItem;
    private JMenuItem contactsBlockContactMenuItem;
    private JMenuItem contactsUnblockContactMenuItem;
    private JMenu settingsMenu;
    private JMenuItem settingsProfileMenuItem;
    private JMenu helpMenu;
    private JMenuItem helpAboutMenuItem;
    private static final long serialVersionUID = 1L;

    public ClientWindow() {
        this.initMenu();
        this.initComponents();
        this.initLayouts();
        this.setTitle("Serious Messenger");
        this.setDefaultCloseOperation(3);
        this.setSize(508, 492);
        this.setResizable(false);
    }

    public void initialize() {
        this.initialize("localhost", 25500);
    }

    public void initialize(String hostName, int port) {
        this.m_client.initialize(hostName, port);
        this.setVisible(true);
    }

    public int numberOfConversations() {
        return this.m_conversationWindows.size();
    }

    public Conversation getConversation(int index) {
        if (index < 0 || index >= this.m_conversationWindows.size()) {
            return null;
        }
        return this.m_conversationWindows.elementAt(index).getConversation();
    }

    public ConversationWindow getConversationWindow(int index) {
        if (index < 0 || index >= this.m_conversationWindows.size()) {
            return null;
        }
        return this.m_conversationWindows.elementAt(index);
    }

    private void initMenu() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.fileSignInMenuItem = new JMenuItem("Sign In");
        this.fileSignOutMenuItem = new JMenuItem("Sign Out");
        this.fileCreateAccountMenuItem = new JMenuItem("Create Account");
        this.fileChangePasswordMenuItem = new JMenuItem("Change Password");
        this.fileExitMenuItem = new JMenuItem("Exit");
        this.contactsMenu = new JMenu("Contacts");
        this.contactsStartConversationMenuItem = new JMenuItem("Start Conversation");
        this.contactsAddContactMenuItem = new JMenuItem("Add Contact");
        this.contactsDeleteContactMenuItem = new JMenuItem("Delete Contact");
        this.contactsBlockContactMenuItem = new JMenuItem("Block Contact");
        this.contactsUnblockContactMenuItem = new JMenuItem("Unblock Contact");
        this.settingsMenu = new JMenu("Settings");
        this.settingsProfileMenuItem = new JMenuItem("View/Edit Profile");
        this.helpMenu = new JMenu("Help");
        this.helpAboutMenuItem = new JMenuItem("About");
        this.fileSignInMenuItem.addActionListener(this);
        this.fileSignOutMenuItem.addActionListener(this);
        this.fileCreateAccountMenuItem.addActionListener(this);
        this.fileChangePasswordMenuItem.addActionListener(this);
        this.fileExitMenuItem.addActionListener(this);
        this.contactsStartConversationMenuItem.addActionListener(this);
        this.contactsAddContactMenuItem.addActionListener(this);
        this.contactsDeleteContactMenuItem.addActionListener(this);
        this.contactsBlockContactMenuItem.addActionListener(this);
        this.contactsUnblockContactMenuItem.addActionListener(this);
        this.settingsProfileMenuItem.addActionListener(this);
        this.helpAboutMenuItem.addActionListener(this);
        this.fileMenu.add(this.fileSignInMenuItem);
        this.fileMenu.add(this.fileSignOutMenuItem);
        this.fileMenu.add(this.fileCreateAccountMenuItem);
        this.fileMenu.add(this.fileChangePasswordMenuItem);
        this.fileMenu.add(this.fileExitMenuItem);
        this.contactsMenu.add(this.contactsStartConversationMenuItem);
        this.contactsMenu.add(this.contactsAddContactMenuItem);
        this.contactsMenu.add(this.contactsDeleteContactMenuItem);
        this.contactsMenu.add(this.contactsBlockContactMenuItem);
        this.contactsMenu.add(this.contactsUnblockContactMenuItem);
        this.settingsMenu.add(this.settingsProfileMenuItem);
        this.helpMenu.add(this.helpAboutMenuItem);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.contactsMenu);
        this.menuBar.add(this.settingsMenu);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
    }

    private void initComponents() {
        this.contactPanels = new Vector();
        this.userInfoPanel = new JPanel();
        this.nickNameTextField = new JTextField();
        this.nickNameTextField.addKeyListener(this);
        this.displayPicIconLabel = new JLabel();
        this.personalMessageTextField = new JTextField();
        this.personalMessageTextField.addKeyListener(this);
        this.personalMessageTextField.setFont(new Font("Tahoma", 2, 11));
        this.statusComboBox = new JComboBox();
        this.utilityPanel = new JPanel();
        this.announceButton = new JButton("Announce");
        this.announceButton.addActionListener(this);
        this.searchTextField = new JTextField("Type here to search through the contact list...");
        this.searchLabel = new JLabel("Search:");
        this.groupsTabbedPane = new JTabbedPane();
        this.displayPicIconLabel.setIcon(new ImageIcon("img/serious_logo.png"));
        this.statusComboBox.setModel(new DefaultComboBoxModel<String>(StatusType.statusTypes));
        this.statusComboBox.setToolTipText("Use this drop down box to select your status");
        this.statusComboBox.addActionListener(this);
        this.searchTextField.setFont(new Font("Tahoma", 2, 11));
        this.searchTextField.setToolTipText("Type here to search through the contact list...");
        this.contactListPanel = new JPanel();
        this.contactListScrollPane = new JScrollPane();
        this.contactListPanel.setToolTipText("Group: All Contacts");
        this.contactListPanel.setPreferredSize(new Dimension(450, 268));
        this.contactListScrollPane.setToolTipText("Contact List");
        this.contactListScrollPane.setViewportView(this.contactListPanel);
        this.contactListScrollPane.setHorizontalScrollBarPolicy(31);
        this.contactListScrollPane.setVerticalScrollBarPolicy(22);
        this.groupsTabbedPane.setToolTipText("Group: All Contacts");
        this.groupsTabbedPane.setFont(new Font("Tahoma", 1, 11));
        this.groupsTabbedPane.addTab("All Contacts", this.contactListScrollPane);
    }

    public void initLayouts() {
        GroupLayout userInfoPanelLayout = new GroupLayout(this.userInfoPanel);
        this.userInfoPanel.setLayout(userInfoPanelLayout);
        userInfoPanelLayout.setHorizontalGroup(userInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(userInfoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.displayPicIconLabel).addGap(18, 18, 18).addGroup(userInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(userInfoPanelLayout.createSequentialGroup().addComponent(this.nickNameTextField, -2, 290, -2).addGap(18, 18, 18).addComponent(this.statusComboBox, -2, 89, -2)).addComponent(this.personalMessageTextField)).addContainerGap(30, Short.MAX_VALUE)));
        userInfoPanelLayout.setVerticalGroup(userInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(userInfoPanelLayout.createSequentialGroup().addContainerGap().addGroup(userInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.displayPicIconLabel).addGroup(userInfoPanelLayout.createSequentialGroup().addGroup(userInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nickNameTextField, -2, -1, -2).addComponent(this.statusComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.personalMessageTextField, -2, -1, -2))).addContainerGap()));
        GroupLayout utilityPanelLayout = new GroupLayout(this.utilityPanel);
        this.utilityPanel.setLayout(utilityPanelLayout);
        utilityPanelLayout.setHorizontalGroup(utilityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(utilityPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.searchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.searchTextField, -2, 280, -2).addGap(29, 29, 29).addComponent(this.announceButton).addContainerGap(-1, Short.MAX_VALUE)));
        utilityPanelLayout.setVerticalGroup(utilityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(utilityPanelLayout.createSequentialGroup().addContainerGap().addGroup(utilityPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchLabel).addComponent(this.searchTextField, -2, -1, -2).addComponent(this.announceButton)).addContainerGap()));
        GroupLayout contactListPanelLayout = new GroupLayout(this.contactListPanel);
        this.contactListPanel.setLayout(contactListPanelLayout);
        contactListPanelLayout.setHorizontalGroup(contactListPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contactListPanelLayout.createSequentialGroup().addContainerGap()));
        contactListPanelLayout.setVerticalGroup(contactListPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contactListPanelLayout.createSequentialGroup()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userInfoPanel, -2, -1, -2).addComponent(this.groupsTabbedPane, -2, -1, -2).addComponent(this.utilityPanel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.userInfoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupsTabbedPane, -2, -1, -2).addGap(2, 2, 2).addComponent(this.utilityPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.fileSignInMenuItem) {
            if (this.m_client.getClientState() != 0) {
                JOptionPane.showMessageDialog(null, "Please log out first.", "Already Logged In", 2);
                return;
            }
            String userName = JOptionPane.showInputDialog(null, "Username:", "Username", 3);
            if (userName == null) {
                return;
            }
            String password = JOptionPane.showInputDialog(null, "Password:", "Password", 3);
            if (password == null) {
                return;
            }
            this.m_client.connect();
            this.m_client.login(userName, password);
        } else if (e.getSource() == this.fileSignOutMenuItem) {
            if (this.m_client.getClientState() == 0) {
                JOptionPane.showMessageDialog(null, "Unable to log out, you are not logged in.", "Not Logged In", 2);
                return;
            }
            this.m_client.logout();
        } else if (e.getSource() == this.fileCreateAccountMenuItem) {
            if (this.m_client.getClientState() != 0) {
                JOptionPane.showMessageDialog(null, "Please log out before creating an account.", "Please Log Out", 2);
                return;
            }
            String userName = JOptionPane.showInputDialog(null, "Username:", "Username", 3);
            String password = JOptionPane.showInputDialog(null, "Password:", "Password", 3);
            this.m_client.connect();
            this.m_client.createAccount(userName, password);
        } else if (e.getSource() == this.fileChangePasswordMenuItem) {
            if (this.m_client.getClientState() < 3) {
                JOptionPane.showMessageDialog(null, "Please log in first.", "Not Logged In", 2);
                return;
            }
            String oldPassword = JOptionPane.showInputDialog(null, "Old Password:", "Old Password", 3);
            if (oldPassword == null) {
                return;
            }
            String newPassword = JOptionPane.showInputDialog(null, "New Password:", "New Password", 3);
            if (newPassword == null) {
                return;
            }
            String confirmNewPassword = JOptionPane.showInputDialog(null, "Confirm New Password:", "Confirm New Password", 3);
            if (oldPassword == null || newPassword == null || confirmNewPassword == null) {
                JOptionPane.showMessageDialog(null, "Please fill out all information fields.", "Missing Information", 2);
                return;
            }
            if (!newPassword.equals(confirmNewPassword)) {
                JOptionPane.showMessageDialog(null, "New password does not match.", "Mismatched Passwords", 2);
                return;
            }
            this.m_client.changePassword(oldPassword, newPassword);
        } else if (e.getSource() == this.fileExitMenuItem) {
            System.exit(0);
        } else if (e.getSource() == this.contactsStartConversationMenuItem) {
            if (this.m_client.getClientState() < 3) {
                JOptionPane.showMessageDialog(null, "Please log in first.", "Not Logged In", 2);
                return;
            }
            UserData contact = null;
            String contactUserName = JOptionPane.showInputDialog(null, "Who would you like to start a conversation with?", "Start Conversation with User", 3);
            if (contactUserName == null) {
                return;
            }
            int i = 0;
            while (i < this.m_client.numberOfContacts()) {
                if (contactUserName.equalsIgnoreCase(this.m_client.getContact(i).getUserName())) {
                    contact = this.m_client.getContact(i);
                    break;
                }
                ++i;
            }
            if (contact == null) {
                JOptionPane.showMessageDialog(null, "Unable to find contact on your contact list.", "Invalid Contact", 2);
                return;
            }
            if (contact.getStatus() == 0) {
                JOptionPane.showMessageDialog(null, "Contact is not online.", "Contact Offline", 2);
                return;
            }
            this.startConversation((UserNetworkData)contact);
        } else if (e.getSource() == this.contactsAddContactMenuItem) {
            if (this.m_client.getClientState() < 3) {
                JOptionPane.showMessageDialog(null, "Please log in first.", "Not Logged In", 2);
                return;
            }
            String contactUserName = JOptionPane.showInputDialog(null, "Contact's User Name:", "Contact User Name", 3);
            this.m_client.addContact(contactUserName);
        } else if (e.getSource() == this.contactsDeleteContactMenuItem) {
            if (this.m_client.getClientState() < 3) {
                JOptionPane.showMessageDialog(null, "Please log in first.", "Not Logged In", 2);
                return;
            }
            String contactUserName = JOptionPane.showInputDialog(null, "Contact's User Name:", "Contact User Name", 3);
            this.m_client.deleteContact(contactUserName);
        } else if (e.getSource() == this.contactsBlockContactMenuItem) {
            if (this.m_client.getClientState() < 3) {
                JOptionPane.showMessageDialog(null, "Please log in first.", "Not Logged In", 2);
                return;
            }
            String contactUserName = JOptionPane.showInputDialog(null, "Contact's User Name:", "Contact User Name", 3);
            this.m_client.blockContact(contactUserName);
        } else if (e.getSource() == this.contactsUnblockContactMenuItem) {
            if (this.m_client.getClientState() < 3) {
                JOptionPane.showMessageDialog(null, "Please log in first.", "Not Logged In", 2);
                return;
            }
            String contactUserName = JOptionPane.showInputDialog(null, "Contact's User Name:", "Contact User Name", 3);
            this.m_client.unblockContact(contactUserName);
        } else if (e.getSource() == this.settingsProfileMenuItem) {
            if (this.m_client.getClientState() < 3) {
                JOptionPane.showMessageDialog(null, "Please log in first.", "Not Logged In", 2);
                return;
            }
            ProfileWindow profileWindow = new ProfileWindow(this.m_client);
            profileWindow.setVisible(true);
        } else if (e.getSource() == this.helpAboutMenuItem) {
            JOptionPane.showMessageDialog(null, "Serious Messenger.\n\nSerious about delivering messages.", "About Serious Messenger", 1);
        } else if (e.getSource() == this.statusComboBox) {
            Object selectedItem = this.statusComboBox.getSelectedItem();
            if (selectedItem != null) {
                this.m_client.updateStatus(StatusType.getStatus(selectedItem.toString()));
            }
        } else if (e.getSource() == this.announceButton) {
            this.announce();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.nickNameTextField) {
            if (e.getKeyChar() == '\n' && this.nickNameTextField.getText().length() != 0) {
                this.m_client.updateNickName(this.nickNameTextField.getText());
            }
        } else if (e.getSource() == this.personalMessageTextField && e.getKeyChar() == '\n') {
            this.m_client.updatePersonalMessage(this.personalMessageTextField.getText());
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void announce() {
        String message = JOptionPane.showInputDialog(null, "Announcement Message:", "Announce", 3);
        int i = 0;
        while (i < this.numberOfConversations()) {
            this.m_conversationWindows.elementAt(i).addMessage(message, this.m_client.getUserName());
            ++i;
        }
        this.m_client.announce(message);
    }

    public ConversationWindow startConversation(String contactUserName) {
        return this.startConversation(this.m_client.getContact(contactUserName));
    }

    public ConversationWindow startConversation(UserNetworkData contact) {
        if (contact == null) {
            return null;
        }
        if (contact.isBlocked()) {
            return null;
        }
        int i = 0;
        while (i < this.numberOfConversations()) {
            if (this.getConversation(i).hasParticipant(contact.getUserName())) {
                this.m_conversationWindows.elementAt(i).setVisible(true);
                return this.m_conversationWindows.elementAt(i);
            }
            ++i;
        }
        ConversationWindow conversationWindow = new ConversationWindow(this.m_client, contact, this);
        conversationWindow.setVisible(true);
        this.m_conversationWindows.add(conversationWindow);
        return conversationWindow;
    }

    public void resetContactPanels() {
        this.contactListPanel = new JPanel();
        this.contactListPanel.setToolTipText("Group: All Contacts");
        this.contactListPanel.setPreferredSize(new Dimension(450, 268));
        this.contactPanels = new Vector();
        ContactPanel panel = null;
        int i = 0;
        while (i < this.m_client.numberOfContacts()) {
            panel = new ContactPanel(this.m_client.getContact(i));
            this.contactPanels.add(panel);
            this.contactListPanel.add(panel);
            ++i;
        }
        this.contactListScrollPane.setViewportView(this.contactListPanel);
        this.contactListScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.contactListPanel.setLayout(new FlowLayout());
        if (this.contactPanels.size() > 0) {
            this.contactListPanel.setPreferredSize(new Dimension(440, 80 * this.contactPanels.size()));
        }
        this.update();
    }

    public void update() {
        this.nickNameTextField.setText(this.m_client.getNickName());
        this.personalMessageTextField.setText(this.m_client.getPersonalMessage());
        this.displayPicIconLabel.setIcon(UserPanel.getDisplayPicture(this.m_client.getUserName()));
        int i = 0;
        while (i < this.contactPanels.size()) {
            this.contactPanels.elementAt(i).update();
            ++i;
        }
        i = 0;
        while (i < this.m_conversationWindows.size()) {
            this.m_conversationWindows.elementAt(i).update();
            ++i;
        }
    }
}

