/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.Client;
import client.ClientWindow;
import client.Conversation;
import client.UserPanel;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import shared.StatusType;
import shared.UserNetworkData;

public class ConversationWindow
extends JFrame
implements ActionListener,
KeyListener {
    private Conversation m_conversation;
    private Client m_client;
    private UserNetworkData m_contact;
    private ClientWindow m_clientWindow;
    private JMenuBar menuBar;
    private JButton announceButton;
    private JButton clearButton;
    private JMenu contactMenu;
    private JTextPane conversationOutputTextPane;
    private JLabel displayPicIconLabel;
    private JMenu editMenu;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JPanel inputPanel;
    private JScrollPane jScrollPane1;
    private JTextField nickNameTextField;
    private JTextField personalMessageTextField;
    private JButton sendButton;
    private JTextField statusTextField;
    private JPanel userInfoPanel;
    private JTextField userInputTextField;
    private JTextField userTypingTextField;
    private static final long serialVersionUID = 1L;

    public ConversationWindow() {
        this(null, null, null);
    }

    public ConversationWindow(Client client, UserNetworkData contact, ClientWindow clientWindow) {
        this.m_client = client;
        this.m_contact = contact;
        this.m_clientWindow = clientWindow;
        this.m_conversation = new Conversation(this.m_client, this.m_contact, this.m_client, this);
        this.initComponents();
        this.update();
        this.setDefaultCloseOperation(2);
        this.setTitle("Conversation");
        this.setSize(434, 528);
        this.setResizable(false);
    }

    public Conversation getConversation() {
        return this.m_conversation;
    }

    public void receiveMessage(String message, long messageID, String contactUserName) {
        this.m_conversation.receiveMessage(message, messageID, contactUserName);
    }

    public void addMessage(String message, String contactName) {
        this.conversationOutputTextPane.setText(String.valueOf(this.conversationOutputTextPane.getText().length() == 0 ? "" : String.valueOf(this.conversationOutputTextPane.getText()) + "\n") + contactName + ": " + message);
    }

    public void update() {
        if (this.m_contact == null) {
            return;
        }
        this.displayPicIconLabel.setIcon(UserPanel.getDisplayPicture(this.m_contact.getUserName()));
        this.nickNameTextField.setText(this.m_contact.getNickName());
        this.personalMessageTextField.setText(this.m_contact.getPersonalMessage());
        this.statusTextField.setText(StatusType.getStatus(this.m_contact.getStatus()));
    }

    private void initComponents() {
        this.userInfoPanel = new JPanel();
        this.statusTextField = new JTextField();
        this.nickNameTextField = new JTextField();
        this.displayPicIconLabel = new JLabel();
        this.personalMessageTextField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.conversationOutputTextPane = new JTextPane();
        this.inputPanel = new JPanel();
        this.clearButton = new JButton();
        this.announceButton = new JButton();
        this.sendButton = new JButton();
        this.userInputTextField = new JTextField();
        this.userTypingTextField = new JTextField();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.editMenu = new JMenu();
        this.contactMenu = new JMenu();
        this.helpMenu = new JMenu();
        this.displayPicIconLabel.setIcon(new ImageIcon("img/serious_logo.png"));
        this.statusTextField.setEditable(false);
        this.nickNameTextField.setEditable(false);
        this.personalMessageTextField.setEditable(false);
        this.personalMessageTextField.setFont(new Font("Tahoma", 2, 11));
        this.sendButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.announceButton.addActionListener(this);
        this.userInputTextField.addKeyListener(this);
        GroupLayout userInfoPanelLayout = new GroupLayout(this.userInfoPanel);
        this.userInfoPanel.setLayout(userInfoPanelLayout);
        userInfoPanelLayout.setHorizontalGroup(userInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(userInfoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.displayPicIconLabel).addGap(18, 18, 18).addGroup(userInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, userInfoPanelLayout.createSequentialGroup().addComponent(this.nickNameTextField, -1, 220, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.statusTextField, -2, 75, -2)).addComponent(this.personalMessageTextField, -1, 310, Short.MAX_VALUE)).addContainerGap()));
        userInfoPanelLayout.setVerticalGroup(userInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(userInfoPanelLayout.createSequentialGroup().addContainerGap().addGroup(userInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.displayPicIconLabel).addGroup(userInfoPanelLayout.createSequentialGroup().addGroup(userInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nickNameTextField, -2, -1, -2).addComponent(this.statusTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.personalMessageTextField, -2, -1, -2))).addContainerGap()));
        this.jScrollPane1.setViewportView(this.conversationOutputTextPane);
        this.clearButton.setText("Clear");
        this.announceButton.setText("Announce");
        this.sendButton.setText("Send");
        this.userInputTextField.setCursor(new Cursor(2));
        GroupLayout inputPanelLayout = new GroupLayout(this.inputPanel);
        this.inputPanel.setLayout(inputPanelLayout);
        inputPanelLayout.setHorizontalGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.userInputTextField, -2, 280, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.announceButton, -1, -1, Short.MAX_VALUE).addComponent(this.sendButton).addComponent(this.clearButton, GroupLayout.Alignment.TRAILING, -1, 81, Short.MAX_VALUE)).addContainerGap()));
        inputPanelLayout.linkSize(0, this.announceButton, this.clearButton, this.sendButton);
        inputPanelLayout.setVerticalGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addContainerGap().addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addComponent(this.sendButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.announceButton)).addComponent(this.userInputTextField, -1, 81, Short.MAX_VALUE)).addContainerGap()));
        inputPanelLayout.linkSize(1, this.announceButton, this.clearButton, this.sendButton);
        this.userTypingTextField.setEditable(false);
        this.userTypingTextField.setFont(new Font("Tahoma", 3, 11));
        this.fileMenu.setText("File");
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.menuBar.add(this.editMenu);
        this.contactMenu.setText("Contact");
        this.menuBar.add(this.contactMenu);
        this.helpMenu.setText("Help");
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.inputPanel, -2, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.userTypingTextField, -2, 387, -2)).addComponent(this.userInfoPanel, -2, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jScrollPane1, -2, 388, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.userInfoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 234, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputPanel, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userTypingTextField, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    public void sendMessage() {
        this.m_conversation.sendMessage(this.userInputTextField.getText());
        this.addMessage(this.userInputTextField.getText(), this.m_client.getUserName());
        this.userInputTextField.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.sendButton) {
            this.sendMessage();
        } else if (e.getSource() == this.clearButton) {
            this.userInputTextField.setText("");
        } else if (e.getSource() == this.announceButton) {
            this.m_clientWindow.announce();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.userInputTextField && e.getKeyChar() == '\n') {
            this.sendMessage();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

