/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.Client;
import client.ClientWindow;
import client.ServerOutputSignalQueue;
import java.io.DataInputStream;
import java.util.ArrayDeque;
import shared.ByteStream;
import shared.MessageBoxSystem;
import shared.UserNetworkData;
import signal.BroadcastLoginSignal;
import signal.ChangeNicknameSignal;
import signal.ChangePersonalMessageSignal;
import signal.ChangeStatusSignal;
import signal.ContactAddedSignal;
import signal.ContactBlockedSignal;
import signal.ContactDeletedSignal;
import signal.ContactListSignal;
import signal.LoginAuthenticatedSignal;
import signal.MessageSignal;
import signal.PasswordChangedSignal;
import signal.Signal;
import signal.UserCreatedSignal;

public class ServerInputSignalQueue
extends Thread {
    private ArrayDeque<Signal> m_inSignalQueue = new ArrayDeque();
    private DataInputStream m_in;
    private ServerOutputSignalQueue m_outSignalQueue;
    private Client m_client;
    private MessageBoxSystem m_messageBoxSystem;
    private ClientWindow m_clientWindow;

    public void initialize(Client client, ClientWindow clientWindow, DataInputStream in, ServerOutputSignalQueue out, MessageBoxSystem messageBoxSystem) {
        this.m_client = client;
        this.m_clientWindow = clientWindow;
        this.m_in = in;
        this.m_outSignalQueue = out;
        this.m_messageBoxSystem = messageBoxSystem;
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    public boolean isTerminated() {
        return this.getState() == Thread.State.TERMINATED;
    }

    public void addSignal(Signal s) {
        if (s == null) {
            return;
        }
        this.m_inSignalQueue.add(s);
    }

    private void sendSignal(Signal s) {
        if (s == null) {
            return;
        }
        this.m_outSignalQueue.addSignal(s);
    }

    public void readSignal() {
        if (!this.m_client.isConnected()) {
            return;
        }
        Signal s = Signal.readFrom(ByteStream.readFrom(this.m_in, 12));
        Signal s2 = null;
        if (s == null) {
            return;
        }
        if (s.getSignalType() == 1) {
            s2 = s;
        } else if (s.getSignalType() == 2) {
            s2 = s;
        } else if (s.getSignalType() == 4) {
            s2 = LoginAuthenticatedSignal.readFrom(ByteStream.readFrom(this.m_in, 928));
        } else if (s.getSignalType() == 6) {
            s2 = BroadcastLoginSignal.readFrom(ByteStream.readFrom(this.m_in, 932));
        } else if (s.getSignalType() == 7) {
            s2 = MessageSignal.readFrom(ByteStream.readFrom(this.m_in, 148), this.m_in);
        } else if (s.getSignalType() == 11) {
            s2 = PasswordChangedSignal.readFrom(ByteStream.readFrom(this.m_in, 9));
        } else if (s.getSignalType() == 13) {
            s2 = ContactAddedSignal.readFrom(ByteStream.readFrom(this.m_in, 933));
        } else if (s.getSignalType() == 15) {
            s2 = ContactDeletedSignal.readFrom(ByteStream.readFrom(this.m_in, 73));
        } else if (s.getSignalType() == 17) {
            s2 = ContactBlockedSignal.readFrom(ByteStream.readFrom(this.m_in, 74));
        } else if (s.getSignalType() == 18) {
            s2 = ChangeNicknameSignal.readFrom(ByteStream.readFrom(this.m_in, 328));
        } else if (s.getSignalType() == 19) {
            s2 = ChangePersonalMessageSignal.readFrom(ByteStream.readFrom(this.m_in, 584));
        } else if (s.getSignalType() == 20) {
            s2 = ChangeStatusSignal.readFrom(ByteStream.readFrom(this.m_in, 73));
        } else if (s.getSignalType() == 22) {
            s2 = UserCreatedSignal.readFrom(ByteStream.readFrom(this.m_in, 9));
        } else if (s.getSignalType() == 23) {
            s2 = ContactListSignal.readFrom(ByteStream.readFrom(this.m_in, 12), this.m_in);
        } else {
            return;
        }
        this.addSignal(s2);
    }

    @Override
    public void run() {
        while (this.m_client.isConnected()) {
            if (!this.m_inSignalQueue.isEmpty()) {
                Signal s2;
                Signal s = this.m_inSignalQueue.remove();
                if (s == null) continue;
                if (s.getSignalType() == 1) {
                    this.sendSignal(new Signal(2));
                } else if (s.getSignalType() == 2) {
                    this.m_client.pong();
                } else if (s.getSignalType() == 4) {
                    s2 = (LoginAuthenticatedSignal)s;
                    if (((LoginAuthenticatedSignal)s2).getAuthenticated()) {
                        this.m_client.setNickName(((LoginAuthenticatedSignal)s2).getData().getNickName());
                        this.m_client.setPersonalMessage(((LoginAuthenticatedSignal)s2).getData().getPersonalMessage());
                        this.m_client.authenticated();
                        this.m_messageBoxSystem.show(null, "Successfully logged in!", "Logged In", 1);
                    } else {
                        this.m_messageBoxSystem.show(null, "Unable to log in.", "Login Failed", 2);
                        this.m_client.disconnect();
                    }
                } else if (s.getSignalType() == 6) {
                    s2 = (BroadcastLoginSignal)s;
                    this.m_client.updateContact(((BroadcastLoginSignal)s2).getData());
                    this.m_clientWindow.resetContactPanels();
                } else if (s.getSignalType() == 7) {
                    s2 = (MessageSignal)s;
                    if (((MessageSignal)s2).getUserName().equalsIgnoreCase(this.m_client.getUserName())) {
                        this.m_client.receiveMessage(((MessageSignal)s2).getMessage(), ((MessageSignal)s2).getMessageID(), ((MessageSignal)s2).getContactUserName());
                    }
                } else if (s.getSignalType() == 11) {
                    s2 = (PasswordChangedSignal)s;
                    if (((PasswordChangedSignal)s2).getPasswordChanged()) {
                        this.m_messageBoxSystem.show(null, "Password changed successfully!", "Password Change Succeeded", 1);
                    } else {
                        this.m_messageBoxSystem.show(null, "Unable to change password.", "Password Change Failed", 2);
                    }
                } else if (s.getSignalType() == 13) {
                    s2 = (ContactAddedSignal)s;
                    if (((ContactAddedSignal)s2).getAdded()) {
                        this.m_client.addContact(new UserNetworkData(((ContactAddedSignal)s2).getData()));
                        this.m_messageBoxSystem.show(null, "Contact " + ((ContactAddedSignal)s2).getData().getUserName() + " added successfully!", "Contact Added", 1);
                    } else {
                        this.m_messageBoxSystem.show(null, "Unable to add contact " + ((ContactAddedSignal)s2).getData().getUserName(), "Unable to Add Contact", 2);
                    }
                    this.m_clientWindow.resetContactPanels();
                } else if (s.getSignalType() == 15) {
                    s2 = (ContactDeletedSignal)s;
                    if (((ContactDeletedSignal)s2).getDeleted()) {
                        this.m_client.removeContact(((ContactDeletedSignal)s2).getUserName());
                        this.m_messageBoxSystem.show(null, "Contact " + ((ContactDeletedSignal)s2).getUserName() + " deleted successfully!", "Contact Deleted", 1);
                    } else {
                        this.m_messageBoxSystem.show(null, "Unable to delete contact " + ((ContactDeletedSignal)s2).getUserName(), "Unable to Delete Contact", 2);
                    }
                    this.m_clientWindow.resetContactPanels();
                } else if (s.getSignalType() == 17) {
                    s2 = (ContactBlockedSignal)s;
                    if (((ContactBlockedSignal)s2).getSucceeded()) {
                        this.m_messageBoxSystem.show(null, "Contact " + ((ContactBlockedSignal)s2).getUserName() + " is now " + (((ContactBlockedSignal)s2).getBlocked() ? "" : "un") + "blocked.", "Contact " + (((ContactBlockedSignal)s2).getBlocked() ? "Blocked" : "Unblocked"), 1);
                    } else {
                        this.m_messageBoxSystem.show(null, "Unable to block/unblock contact " + ((ContactBlockedSignal)s2).getUserName(), "Unable to Block/Unblock", 2);
                    }
                } else if (s.getSignalType() == 18) {
                    s2 = (ChangeNicknameSignal)s;
                    this.m_client.updateUserNickName(((ChangeNicknameSignal)s2).getUserName(), ((ChangeNicknameSignal)s2).getNickName());
                    this.m_clientWindow.update();
                } else if (s.getSignalType() == 19) {
                    s2 = (ChangePersonalMessageSignal)s;
                    this.m_client.updateUserPersonalMessage(((ChangePersonalMessageSignal)s2).getUserName(), ((ChangePersonalMessageSignal)s2).getPersonalMessage());
                    this.m_clientWindow.update();
                } else if (s.getSignalType() == 20) {
                    s2 = (ChangeStatusSignal)s;
                    this.m_client.updateUserStatus(((ChangeStatusSignal)s2).getUserName(), ((ChangeStatusSignal)s2).getStatus());
                    this.m_clientWindow.update();
                } else if (s.getSignalType() == 22) {
                    s2 = (UserCreatedSignal)s;
                    if (((UserCreatedSignal)s2).getCreated()) {
                        this.m_messageBoxSystem.show(null, "Successfully created user account!\n\nYou can now sign in with your username and password.", "Created Account", 1);
                    } else {
                        this.m_messageBoxSystem.show(null, "Unable to create user account.", "Create User Account Failed", 2);
                    }
                    this.m_client.disconnect();
                } else if (s.getSignalType() == 23) {
                    s2 = (ContactListSignal)s;
                    this.m_client.updateContacts(((ContactListSignal)s2).getContacts());
                    this.m_clientWindow.resetContactPanels();
                }
            }
            try {
                ServerInputSignalQueue.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

