/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.Client;
import client.ClientWindow;
import java.io.DataOutputStream;
import java.util.ArrayDeque;
import signal.Signal;

public class ServerOutputSignalQueue
extends Thread {
    private ArrayDeque<Signal> m_outSignalQueue = new ArrayDeque();
    private DataOutputStream m_out;
    private Client m_client;
    private ClientWindow m_clientWindow;

    public void initialize(Client client, ClientWindow clientWindow, DataOutputStream out) {
        this.m_client = client;
        this.m_clientWindow = clientWindow;
        this.m_out = out;
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    public boolean isTerminated() {
        return this.getState() == Thread.State.TERMINATED;
    }

    public void addSignal(Signal s) {
        if (s == null) {
            return;
        }
        this.m_outSignalQueue.add(s);
    }

    @Override
    public void run() {
        while (this.m_client.isConnected()) {
            if (!this.m_outSignalQueue.isEmpty()) {
                Signal s = this.m_outSignalQueue.remove();
                if (s.getSignalType() == 1) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 2) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 3) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 5) {
                    s.writeTo(this.m_out);
                    this.m_client.disconnect();
                    this.m_client.setUserName(null);
                    this.m_client.setNickName("");
                    this.m_client.setPersonalMessage("");
                    this.m_client.clearContacts();
                    this.m_clientWindow.resetContactPanels();
                    this.m_clientWindow.update();
                } else if (s.getSignalType() == 6) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 7) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 10) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 12) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 14) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 16) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 18) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 19) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 20) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 21) {
                    s.writeTo(this.m_out);
                }
            }
            try {
                ServerOutputSignalQueue.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

