/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.awt.Color;
import java.awt.Font;
import shared.ByteStream;
import shared.FontStyle;
import shared.Globals;
import shared.StatusType;

public class UserData {
    protected String m_userName;
    protected String m_nickName;
    protected String m_personalMessage;
    protected byte m_status;
    protected FontStyle m_font;
    public static final int LENGTH = 915;

    public UserData(String userName, String nickName, String personalMessage, byte status, FontStyle font) {
        this.m_userName = userName;
        this.m_nickName = nickName == null ? "" : nickName;
        this.m_personalMessage = personalMessage == null ? "" : personalMessage;
        this.m_status = StatusType.isValid(status) ? status : (byte)0;
        this.m_font = font == null ? Globals.DEFAULT_FONTSTYLE : font;
    }

    public UserData(String userName, String nickName, String personalMessage, byte status, Font font, Color colour) {
        this(userName, nickName, personalMessage, status, new FontStyle(font, colour));
    }

    public UserData(String userName, String nickName, String personalMessage, byte status, Font font) {
        this(userName, nickName, personalMessage, status, new FontStyle(font));
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getNickName() {
        return this.m_nickName;
    }

    public String getPersonalMessage() {
        return this.m_personalMessage;
    }

    public byte getStatus() {
        return this.m_status;
    }

    public FontStyle getFont() {
        return this.m_font;
    }

    public void setUserName(String userName) {
        this.m_userName = userName;
    }

    public void setNickName(String nickName) {
        if (nickName != null) {
            this.m_nickName = nickName;
        }
    }

    public void setPersonalMessage(String personalMessage) {
        if (personalMessage != null) {
            this.m_personalMessage = personalMessage;
        }
    }

    public void setStatus(byte status) {
        if (StatusType.isValid(status)) {
            this.m_status = status;
        }
    }

    public void setFont(FontStyle font) {
        if (font != null) {
            this.m_font = font;
        }
    }

    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_userName, 32);
        checksum += ByteStream.getChecksum(this.m_nickName, 128);
        checksum += ByteStream.getChecksum(this.m_personalMessage, 256);
        checksum += ByteStream.getChecksum(this.m_status);
        return checksum += this.m_font.checksum();
    }

    public static UserData readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        String userName = byteStream.nextString(32);
        String nickName = byteStream.nextString(128);
        String personalMessage = byteStream.nextString(256);
        byte status = byteStream.nextByte();
        FontStyle font = FontStyle.readFrom(byteStream);
        return new UserData(userName, nickName, personalMessage, status, font);
    }

    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        byteStream.addStringFixedLength(this.m_userName, 32);
        byteStream.addStringFixedLength(this.m_nickName, 128);
        byteStream.addStringFixedLength(this.m_personalMessage, 256);
        byteStream.addByte(this.m_status);
        this.m_font.writeTo(byteStream);
    }
}

