/*
 * Decompiled with CFR 0.152.
 */
package signal;

import java.awt.Color;
import java.awt.Font;
import shared.ByteStream;
import shared.FontStyle;
import shared.Globals;
import signal.Signal;

public class ChangeFontSignal
extends Signal {
    private FontStyle m_font;
    private String m_userName;
    private String m_contactUserName;
    public static final int LENGTH = 1114;

    private ChangeFontSignal() {
        super(9);
    }

    public ChangeFontSignal(FontStyle font, String userName, String contactUserName) {
        super(9);
        this.m_font = font == null ? Globals.DEFAULT_FONTSTYLE : font;
        this.m_userName = userName;
        this.m_contactUserName = contactUserName;
    }

    public ChangeFontSignal(Font font, Color colour, String userName, String contactUserName) {
        super(9);
        this.m_font = new FontStyle(font, colour);
        this.m_userName = userName;
        this.m_contactUserName = contactUserName;
    }

    public ChangeFontSignal(String face, int size, boolean bold, boolean italic, Color colour, String userName, String contactUserName) {
        super(9);
        this.m_font = new FontStyle(face, size, bold, italic, colour);
        this.m_userName = userName;
        this.m_contactUserName = contactUserName;
    }

    public FontStyle getFont() {
        return this.m_font;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getContactUserName() {
        return this.m_contactUserName;
    }

    @Override
    public long checksum() {
        long checksum = this.m_font.checksum();
        checksum += ByteStream.getChecksum(this.m_contactUserName, 32);
        return checksum += ByteStream.getChecksum(this.m_userName, 32);
    }

    public static ChangeFontSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        ChangeFontSignal s2 = new ChangeFontSignal();
        s2.m_font = FontStyle.readFrom(byteStream);
        s2.m_userName = byteStream.nextString(32);
        s2.m_contactUserName = byteStream.nextString(32);
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        this.m_font.writeTo(byteStream);
        byteStream.addStringFixedLength(this.m_userName, 32);
        byteStream.addStringFixedLength(this.m_contactUserName, 32);
        byteStream.addLong(this.checksum());
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return ChangeFontSignal.readFrom(byteStream);
    }
}

