/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import signal.Signal;

public class ChangePasswordSignal
extends Signal {
    private String m_userName;
    private String m_oldPassword;
    private String m_newPassword;
    public static final int LENGTH = 200;

    private ChangePasswordSignal() {
        super(10);
    }

    public ChangePasswordSignal(String userName, String oldPassword, String newPassword) {
        super(10);
        this.m_userName = userName;
        this.m_oldPassword = oldPassword;
        this.m_newPassword = newPassword;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getOldPassword() {
        return this.m_oldPassword;
    }

    public String getNewPassword() {
        return this.m_newPassword;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_userName, 32);
        checksum += ByteStream.getChecksum(this.m_oldPassword, 32);
        return checksum += ByteStream.getChecksum(this.m_newPassword, 32);
    }

    public static ChangePasswordSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        ChangePasswordSignal s2 = new ChangePasswordSignal();
        s2.m_userName = byteStream.nextString(32);
        s2.m_oldPassword = byteStream.nextString(32);
        s2.m_newPassword = byteStream.nextString(32);
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addStringFixedLength(this.m_userName, 32);
        byteStream.addStringFixedLength(this.m_oldPassword, 32);
        byteStream.addStringFixedLength(this.m_newPassword, 32);
        byteStream.addLong(this.checksum());
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return ChangePasswordSignal.readFrom(byteStream);
    }
}

