/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import signal.Signal;

public class ChangeStatusSignal
extends Signal {
    private String m_userName;
    private byte m_status;
    public static final int LENGTH = 73;

    private ChangeStatusSignal() {
        super(20);
    }

    public ChangeStatusSignal(String userName, byte status) {
        super(20);
        this.m_userName = userName;
        this.m_status = status;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public byte getStatus() {
        return this.m_status;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_userName, 32);
        return checksum += ByteStream.getChecksum(this.m_status);
    }

    public static ChangeStatusSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        ChangeStatusSignal s2 = new ChangeStatusSignal();
        s2.m_userName = byteStream.nextString(32);
        s2.m_status = byteStream.nextByte();
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addStringFixedLength(this.m_userName, 32);
        byteStream.addByte(this.m_status);
        byteStream.addLong(this.checksum());
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return ChangeStatusSignal.readFrom(byteStream);
    }
}

