/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import signal.Signal;

public class LoginRequestSignal
extends Signal {
    private String m_userName;
    private String m_password;
    public static final int LENGTH = 136;

    private LoginRequestSignal() {
        super(3);
    }

    public LoginRequestSignal(String userName, String password) {
        super(3);
        this.m_userName = userName;
        this.m_password = password;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getPassword() {
        return this.m_password;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_userName, 32);
        return checksum += ByteStream.getChecksum(this.m_password, 32);
    }

    public static LoginRequestSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        LoginRequestSignal s2 = new LoginRequestSignal();
        s2.m_userName = byteStream.nextString(32);
        s2.m_password = byteStream.nextString(32);
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addStringFixedLength(this.m_userName, 32);
        byteStream.addStringFixedLength(this.m_password, 32);
        byteStream.addLong(this.checksum());
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return LoginRequestSignal.readFrom(byteStream);
    }
}

