/*
 * Decompiled with CFR 0.152.
 */
package com.rbcapp.bluetooth;

import com.rbcapp.RBCApp;
import com.rbcapp.server.RBCServer;
import com.rbcapp.settings.RBCSettings;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.LinkedList;

public class BluetoothComm {
    protected RBCApp app;
    protected volatile LinkedList<int[]> queue;
    protected ArrayList<Integer> imageData;
    protected RBCSettings settings;
    protected int currentFlag = 0;

    protected BluetoothComm(RBCSettings setts) {
        this.settings = setts;
    }

    public void startServer() throws Exception {
    }

    protected void startListening(BufferedReader bReader, DataOutputStream pWriter) throws Exception {
        int counter = 0;
        int mode = 0;
        int command = -1;
        int size = -1;
        String dataRead = new String();
        boolean proceed = false;
        try {
            Thread.sleep(0L);
            this.app.changeStatusBar("Connected to robot " + this.app.getSettings().robotId, Color.GREEN.darker().darker());
            this.app.enableStartButton();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        while (true) {
            block24: {
                int input;
                block22: {
                    int temp;
                    block23: {
                        try {
                            Thread.sleep(0L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                        if (this.queue.size() > 0) {
                            int[] sendToRobot = this.queue.poll();
                            int thisSize = sendToRobot.length;
                            int i = 0;
                            while (i < thisSize) {
                                pWriter.write(sendToRobot[i]);
                                ++i;
                            }
                            pWriter.flush();
                            sendToRobot = null;
                        }
                        if (!bReader.ready()) continue;
                        input = bReader.read() & 0xFF;
                        if (mode != 0) break block22;
                        temp = input;
                        if (temp != 2) break block23;
                        mode = 1;
                        break block24;
                    }
                    if (temp != 6) break block24;
                    mode = 5;
                    this.imageData = new ArrayList();
                    break block24;
                }
                if (mode == 1) {
                    command = input;
                    if (command == 7 || command == 8 || command == 9 || command == 12) {
                        mode = 0;
                        counter = 0;
                        proceed = true;
                    } else {
                        mode = command == 5 ? 6 : 2;
                    }
                } else if (mode == 6) {
                    this.currentFlag = input;
                    mode = 2;
                } else if (mode == 2) {
                    size = input;
                    mode = 3;
                } else if (mode == 3) {
                    char tempChar = (char)input;
                    dataRead = String.valueOf(dataRead) + tempChar;
                    if (++counter >= size) {
                        proceed = true;
                        counter = 0;
                        mode = 4;
                        mode = 0;
                    }
                } else if (mode == 5) {
                    this.imageData.add(new Integer(input));
                    if (input == 3) {
                        this.handleImage();
                        mode = 0;
                        continue;
                    }
                }
            }
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            if (!proceed) continue;
            this.handleData(command, dataRead.getBytes());
            dataRead = "";
            command = -1;
            size = -1;
            proceed = false;
        }
        pWriter.close();
        bReader.close();
    }

    public void sendData(byte[] data, boolean addCommand) {
        int[] data2;
        int length = data.length;
        int inc = 0;
        if (addCommand) {
            data2 = new int[length + 2];
            data2[0] = 2;
            data2[1] = length;
            inc = 2;
        } else {
            data2 = new int[length];
        }
        int i = 0;
        while (i < length) {
            data2[i + inc] = data[i];
            ++i;
        }
        this.queue.add(data2);
    }

    public void sendDebugData(byte[] data) {
        int length = data.length;
        int inc = 0;
        int[] data2 = new int[length + 2];
        data2[0] = 3;
        data2[1] = length;
        inc = 2;
        int i = 0;
        while (i < length) {
            data2[i + inc] = data[i];
            ++i;
        }
        this.queue.add(data2);
    }

    private void handleData(int command, byte[] data) {
        if (command == 1) {
            this.app.appendDebug(data);
        } else if (command == 2) {
            this.app.appendLineDebug(data);
        } else if (command == 5) {
            this.app.receivedPlannerData(data, this.currentFlag);
        } else if (command == 7) {
            this.app.enableInput();
        } else if (command == 8) {
            this.app.disableInput();
        } else if (command == 9) {
            this.app.clearDebug();
        } else if (command == 10) {
            ArrayList<Integer> dat = new ArrayList<Integer>();
            dat.add(new Integer(data[0] & 0xFF));
            dat.add(new Integer(data[1] & 0xFF));
            dat.add(new Integer(data[2] & 0xFF));
            dat.add(new Integer(data[3] & 0xFF));
            this.app.outputImageTrace(dat);
        } else if (command == 13) {
            this.app.imageColor(data[0] & 0xFF, data[1] & 0xFF, data[2] & 0xFF);
        } else if (command == 12) {
            this.app.clearImage();
        } else if (command == 11) {
            byte[] data2 = new byte[data.length + 2];
            data2[0] = 2;
            data2[1] = data[0];
            data2[2] = (byte)(data.length - 1);
            int i = 1;
            while (i < data.length) {
                data2[i + 2] = data[i];
                ++i;
            }
            RBCServer.sendRobotData(data[0] & 0xFF, data2, this.settings);
        }
    }

    private void handleImage() {
        this.app.outputImage(this.imageData);
    }
}

