/*
 * Decompiled with CFR 0.152.
 */
package com.rbcapp.bluetooth;

import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;

public class BluetoothDeviceFinder
implements DiscoveryListener,
Runnable {
    private static final UUID uuid = new UUID("1101", true);
    private Vector<RemoteDevice> devices;
    private Vector<ServiceRecord> records;
    private Vector<String> urls;
    private Vector<String> addresses;
    private boolean scanCompleted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> scanForBtDevice() {
        this.scanCompleted = false;
        this.devices = new Vector();
        this.urls = new Vector();
        this.addresses = new Vector();
        new Thread(this).start();
        BluetoothDeviceFinder bluetoothDeviceFinder = this;
        synchronized (bluetoothDeviceFinder) {
            try {
                LocalDevice.getLocalDevice().getDiscoveryAgent().startInquiry(10390323, (DiscoveryListener)this);
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (BluetoothStateException e) {
                e.printStackTrace();
            }
        }
        Enumeration<RemoteDevice> enum_d = this.devices.elements();
        while (enum_d.hasMoreElements()) {
            RemoteDevice d = enum_d.nextElement();
            System.out.println("[BLUETOOTH LOG] discovered address: " + d.getBluetoothAddress());
            BluetoothDeviceFinder bluetoothDeviceFinder2 = this;
            synchronized (bluetoothDeviceFinder2) {
                this.records = new Vector();
                try {
                    LocalDevice.getLocalDevice().getDiscoveryAgent().searchServices(new int[]{256, 257, 160, 161, 162, 163, 164}, new UUID[]{uuid}, d, (DiscoveryListener)this);
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                catch (BluetoothStateException e) {
                    e.printStackTrace();
                }
            }
            Enumeration<ServiceRecord> enum_r = this.records.elements();
            while (enum_r.hasMoreElements()) {
                ServiceRecord r = enum_r.nextElement();
                String name = null;
                DataElement nameDataElement = r.getAttributeValue(256);
                if (nameDataElement != null) {
                    name = nameDataElement.getValue().toString();
                }
                System.out.println("[BLUETOOTH LOG] Name attribute: " + name);
                String url = r.getConnectionURL(0, false);
                System.out.println("[BLUETOOTH LOG] url: " + url);
                this.urls.add(url);
                this.addresses.add(String.valueOf(d.getBluetoothAddress()) + " (" + name + ")");
            }
        }
        return this.addresses;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (!this.scanCompleted) {
            System.out.println("[BLUETOOTH LOG] Scanning timed out");
            try {
                if (LocalDevice.getLocalDevice().getDiscoveryAgent().cancelInquiry((DiscoveryListener)this)) {
                    System.out.println("[BLUETOOTH LOG] Scan cancelled");
                }
            }
            catch (BluetoothStateException bse) {
                System.out.println("[BLUETOOTH LOG] Got BluetoothStateException: " + (Object)((Object)bse));
            }
        }
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        this.devices.addElement(btDevice);
    }

    public synchronized void inquiryCompleted(int discType) {
        this.scanCompleted = true;
        this.notifyAll();
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        int i = 0;
        while (i < servRecord.length) {
            this.records.addElement(servRecord[i]);
            ++i;
        }
    }

    public synchronized void serviceSearchCompleted(int transID, int respCode) {
        this.notifyAll();
    }
}

