/*
 * Decompiled with CFR 0.152.
 */
package com.rbcapp.bluetooth;

import com.rbcapp.RBCApp;
import com.rbcapp.bluetooth.BluetoothComm;
import com.rbcapp.bluetooth.BluetoothServer;
import com.rbcapp.bluetooth.BluetoothServerEasyBlue;
import com.rbcapp.settings.RBCSettings;

public class RBCBlue
extends Thread {
    private BluetoothComm server;
    private boolean useEasyBlue;

    public RBCBlue(RBCApp app2, RBCSettings settings, boolean easyBlue) {
        this.useEasyBlue = easyBlue;
        this.server = !this.useEasyBlue ? new BluetoothServer(app2, settings) : new BluetoothServerEasyBlue(app2, settings);
    }

    public void setURL(String url) {
        if (this.useEasyBlue) {
            ((BluetoothServerEasyBlue)this.server).setURL(url);
        }
    }

    public void sendData(byte[] data) {
        this.server.sendData(data, true);
    }

    public void sendDebugData(byte[] data) {
        this.server.sendDebugData(data);
    }

    public void sendSpecificData(byte[] data) {
        this.server.sendData(data, false);
    }

    @Override
    public void run() {
        try {
            this.server.startServer();
        }
        catch (Exception e) {
            System.err.println(e.toString());
            System.err.println(e.getStackTrace());
            e.printStackTrace();
        }
    }
}

