/*
 * Decompiled with CFR 0.152.
 */
package com.rbcapp.planner;

import com.rbcapp.planner.Pose;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class RBCTracker {
    public static final int SERVER_PORT = 6000;
    private static final int INPUT_BUFFER_LIMIT = 400;

    public static void sendData(byte[] data) {
        InetAddress localHost;
        DatagramSocket socket = null;
        DatagramPacket sendPacket = null;
        try {
            localHost = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            return;
        }
        try {
            socket = new DatagramSocket();
            sendPacket = new DatagramPacket(data, data.length, localHost, 6000);
            socket.send(sendPacket);
            socket.close();
        }
        catch (Exception e) {
            System.out.println("[ERROR] Unable to send data to Tracker.");
        }
    }

    public static Pose getPose(int id) throws IOException {
        InetAddress localHost;
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        DatagramSocket socket = null;
        DatagramPacket receivePacket = null;
        byte[] sendBuffer = new byte[2];
        byte[] receiveBuffer = new byte[400];
        try {
            localHost = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            return null;
        }
        socket = new DatagramSocket();
        sendBuffer[0] = 1;
        sendBuffer[1] = (byte)(id - 1);
        DatagramPacket sendPacket = new DatagramPacket(sendBuffer, 2, localHost, 6000);
        socket.send(sendPacket);
        try {
            receivePacket = new DatagramPacket(receiveBuffer, receiveBuffer.length);
            socket.setSoTimeout(2000);
            socket.receive(receivePacket);
            StringTokenizer result = new StringTokenizer(new String(receivePacket.getData(), 0, receivePacket.getLength()), ",");
            Pose robotPose = new Pose(Integer.parseInt(result.nextToken()), Integer.parseInt(result.nextToken()), Integer.parseInt(result.nextToken()));
            socket.close();
            return robotPose;
        }
        catch (SocketTimeoutException e) {
            socket.close();
            System.out.println("[ERROR] Unable to retrieve robot data for robot " + id + ", trying again.");
            return RBCTracker.getPose(id);
        }
    }

    public static byte[] getDesiredPath() throws IOException {
        InetAddress localHost;
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        System.out.println("asking for desired path.");
        DatagramSocket socket = null;
        DatagramPacket receivePacket = null;
        byte[] sendBuffer = new byte[2];
        byte[] receiveBuffer = new byte[400];
        try {
            localHost = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            return null;
        }
        socket = new DatagramSocket();
        sendBuffer[0] = 10;
        sendBuffer[1] = 1;
        DatagramPacket sendPacket = new DatagramPacket(sendBuffer, 2, localHost, 6000);
        socket.send(sendPacket);
        try {
            receivePacket = new DatagramPacket(receiveBuffer, receiveBuffer.length);
            socket.setSoTimeout(2000);
            socket.receive(receivePacket);
            byte[] data = receivePacket.getData();
            socket.close();
            return data;
        }
        catch (SocketTimeoutException e) {
            socket.close();
            System.out.println("[ERROR] Unable to retrieve desired path. Trying again.");
            return RBCTracker.getDesiredPath();
        }
    }
}

