/*
 * Decompiled with CFR 0.152.
 */
package com.rbcapp.settings;

import com.rbcapp.settings.RBCSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class RBCBluetoothAddsWindow
extends JDialog {
    private static final long serialVersionUID = -5131818516360294183L;
    private RBCSettings settings;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel buttonBar;
    private JButton addButton;
    private JButton removeButton;
    private JButton okButton;
    private JButton cancelButton;
    private JScrollPane scrollPane;
    private JTable listOfAdds;

    public RBCBluetoothAddsWindow(RBCSettings setts) {
        this.settings = setts;
        this.initComponents();
        this.inputSettings();
    }

    private void initComponents() {
        this.setModal(true);
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.listOfAdds = new JTable();
        this.scrollPane = new JScrollPane();
        this.buttonBar = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.listOfAdds = new JTable(new BlueAddressTableModel());
        this.setMinimumSize(new Dimension(160, 36));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.contentPanel.getLayout()).columnWidths = new int[3];
        ((GridBagLayout)this.contentPanel.getLayout()).rowHeights = new int[6];
        ((GridBagLayout)this.contentPanel.getLayout()).columnWeights = new double[]{0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.contentPanel.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.listOfAdds.getColumnModel().getColumn(0).setPreferredWidth(15);
        this.listOfAdds.getColumnModel().getColumn(0).setResizable(false);
        this.listOfAdds.getColumnModel().setColumnSelectionAllowed(false);
        this.listOfAdds.setDragEnabled(false);
        this.listOfAdds.setCellSelectionEnabled(false);
        this.listOfAdds.setRowSelectionAllowed(true);
        this.listOfAdds.setAutoCreateRowSorter(false);
        this.scrollPane.setViewportView(this.listOfAdds);
        this.listOfAdds.getTableHeader().setReorderingAllowed(false);
        this.listOfAdds.getTableHeader().setResizingAllowed(false);
        this.listOfAdds.setSelectionMode(0);
        this.contentPanel.add((Component)this.scrollPane, new GridBagConstraints(0, 0, 3, 5, 0.0, 40.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCBluetoothAddsWindow.this.addButtonHit();
            }
        });
        this.contentPanel.add((Component)this.addButton, new GridBagConstraints(0, 6, 1, 1, 1.5, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCBluetoothAddsWindow.this.removeButtonHit();
            }
        });
        this.contentPanel.add((Component)this.removeButton, new GridBagConstraints(1, 6, 1, 1, 1.5, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        int[] nArray = new int[3];
        nArray[1] = 85;
        nArray[2] = 80;
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = nArray;
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCBluetoothAddsWindow.this.okButtonHit();
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCBluetoothAddsWindow.this.cancelButtonHit();
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(245, 284);
        this.setResizable(false);
        this.setLocationRelativeTo(this.getOwner());
        this.setTitle("Robot Addresses");
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e) {
                RBCBluetoothAddsWindow.this.cancelButtonHit();
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.setDefaultCloseOperation(2);
    }

    private void addValue(int id, String address) {
        ((BlueAddressTableModel)this.listOfAdds.getModel()).addValue(id, address);
    }

    private void removeRow(int row) {
        ((BlueAddressTableModel)this.listOfAdds.getModel()).removeValue(row);
    }

    private void removeButtonHit() {
        int id;
        int n;
        if (this.listOfAdds.getSelectedRow() > -1 && (n = JOptionPane.showConfirmDialog(this, "Are you sure you wish to remove robot " + (id = ((Integer)this.listOfAdds.getModel().getValueAt(this.listOfAdds.getSelectedRow(), 0)).intValue()) + "?", "Remove Robot Address", 0)) == 0) {
            this.removeRow(this.listOfAdds.getSelectedRow());
        }
    }

    private void addButtonHit() {
        String input = JOptionPane.showInputDialog(this, (Object)"Enter the robot's id:");
        if (input != null && input != "") {
            try {
                int id = Integer.parseInt(input);
                this.addValue(id, "000000000000");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "ERROR: The robot's id must be an integer.", "Error Adding Robot", 0);
            }
        }
    }

    private void inputSettings() {
        Object[] keys = this.settings.robotAddresses.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            int id = (Integer)keys[i];
            String value = this.settings.robotAddresses.get(id);
            this.addValue(id, value);
            ++i;
        }
    }

    private void cancelButtonHit() {
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonHit() {
        TableModel model = this.listOfAdds.getModel();
        int rows = this.listOfAdds.getModel().getRowCount();
        this.settings.robotAddresses = new TreeMap();
        int i = 0;
        while (i < rows) {
            Integer id = (Integer)model.getValueAt(i, 0);
            String value = (String)model.getValueAt(i, 1);
            this.settings.robotAddresses.put(id, value);
            ++i;
        }
        this.cancelButtonHit();
        this.settings.saveSettings("settings.ini");
    }

    class BlueAddressTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 8936841443456418365L;
        private String[] columnNames = new String[]{"Robot Id", "Bluetooth Address"};
        private Vector<String> addresses = new Vector();
        private Vector<Integer> ids = new Vector();

        BlueAddressTableModel() {
        }

        public void addRow(int id, String address) {
            this.ids.add(new Integer(id));
            this.addresses.add(new String(address));
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.ids.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public boolean addValue(int id, String address) {
            int size = this.ids.size();
            int i = 0;
            while (i < size) {
                if (this.ids.get(i) > id) {
                    this.ids.add(i, new Integer(id));
                    this.addresses.add(i, new String(address));
                    this.fireTableDataChanged();
                    return true;
                }
                if (this.ids.get(i) == id) {
                    return false;
                }
                ++i;
            }
            this.ids.add(new Integer(id));
            this.addresses.add(new String(address));
            this.fireTableDataChanged();
            return true;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.ids.get(row);
            }
            return this.addresses.get(row);
        }

        public void removeValue(int row) {
            if (row < this.ids.size()) {
                this.ids.remove(row);
                this.addresses.remove(row);
                this.fireTableDataChanged();
            }
        }

        @Override
        public void setValueAt(Object o, int row, int col) {
            if (col == 0) {
                try {
                    this.ids.set(row, (Integer)o);
                }
                catch (Exception e) {
                    System.out.println("[ERROR] Received a non int for id.");
                }
            } else if (((String)o).matches("\\p{Alnum}+")) {
                this.addresses.set(row, new String("" + o));
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col >= 1;
        }
    }
}

