/*
 * Decompiled with CFR 0.152.
 */
package com.rbcapp.window;

import com.rbcapp.RBCApp;
import com.rbcapp.bluetooth.BluetoothDeviceFinder;
import com.rbcapp.camera.CameraImage;
import com.rbcapp.settings.RBCBluetoothAddsWindow;
import com.rbcapp.settings.RBCSettings;
import com.rbcapp.settings.RBCSettingsWindow;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.sql.Time;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.BevelBorder;
import javax.swing.filechooser.FileFilter;

public class RBCWindow
extends JFrame {
    private static final long serialVersionUID = 5579666370124525967L;
    public RBCSettings settings;
    private RBCApp app;
    private boolean newLine = true;
    private boolean usingEasyBlue = false;
    private JMenuBar menuBar1;
    private JPopupMenu debugPopMenu;
    private JPopupMenu logPopMenu;
    private JTextField inputField;
    private JMenu optionsMenu;
    private JLabel imagePanel;
    private JScrollPane scrollPane1;
    private JTextArea debugOutput;
    private JScrollPane scrollPane2;
    private JTextArea logOutput;
    private JLabel label1;
    private JLabel label2;
    private JLabel logLabel;
    private JMenuItem resetBlue;
    private JSeparator sep;
    private JLabel statusBar;
    private JLabel statusBar2;
    private JMenuItem stopButton;
    private JMenuItem startButton;
    private JMenuItem changeSettings;
    private JCheckBoxMenuItem setTimeStamp;
    private JCheckBoxMenuItem viewCamera;
    private JCheckBoxMenuItem viewLog;
    private JCheckBoxMenuItem viewDebug;
    private JCheckBoxMenuItem viewDebugInput;
    private JMenuItem clearDebug;
    private JMenuItem clearLog;
    private JMenu viewMenu;
    private JDialog cameraFrame;
    private JMenu plannerMenu;
    private JMenuItem loadPlanner;
    private JMenuItem unloadPlanner;
    private JMenu cameraMenu;
    private JMenuItem saveImage;
    private JMenuItem resetImage;
    private JMenuItem scanButton;
    private JMenu scanMenu;
    private JMenuItem robotAddresses;
    private JLabel debugLabel;
    private JFrame me;
    private JLabel onLabel;
    private JLabel offLabel;
    private boolean plannerLoaded = false;
    private ImageIcon standbyIcon = new ImageIcon(this.getClass().getResource("/com/rbcapp/images/standby.gif"));
    private ImageIcon offIcon = new ImageIcon(this.getClass().getResource("/com/rbcapp/images/off.gif"));
    private ImageIcon onIcon = new ImageIcon(this.getClass().getResource("/com/rbcapp/images/on.gif"));

    public RBCWindow(RBCApp app2, RBCSettings settings1) {
        this.app = app2;
        this.settings = settings1;
        this.me = this;
        this.initComponents();
    }

    private void initComponents() {
        this.debugPopMenu = new JPopupMenu();
        this.logPopMenu = new JPopupMenu();
        this.inputField = new JTextField();
        this.menuBar1 = new JMenuBar();
        this.optionsMenu = new JMenu();
        this.resetBlue = new JMenuItem();
        this.sep = new JSeparator();
        this.changeSettings = new JMenuItem();
        this.stopButton = new JMenuItem();
        this.startButton = new JMenuItem();
        this.statusBar = new JLabel();
        this.statusBar2 = new JLabel();
        this.imagePanel = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.debugOutput = new JTextArea();
        this.scrollPane2 = new JScrollPane();
        this.logOutput = new JTextArea();
        this.logLabel = new JLabel();
        this.label1 = new JLabel();
        this.label2 = new JLabel();
        this.setTimeStamp = new JCheckBoxMenuItem();
        this.viewCamera = new JCheckBoxMenuItem();
        this.viewLog = new JCheckBoxMenuItem();
        this.viewDebug = new JCheckBoxMenuItem();
        this.viewDebugInput = new JCheckBoxMenuItem();
        this.clearDebug = new JMenuItem();
        this.clearLog = new JMenuItem();
        this.cameraFrame = new JDialog((Frame)this, "Camera");
        this.viewMenu = new JMenu("View");
        this.plannerMenu = new JMenu();
        this.loadPlanner = new JMenuItem();
        this.unloadPlanner = new JMenuItem();
        this.cameraMenu = new JMenu();
        this.saveImage = new JMenuItem();
        this.resetImage = new JMenuItem();
        this.scanButton = new JMenuItem();
        this.scanMenu = new JMenu();
        this.robotAddresses = new JMenuItem();
        this.debugLabel = new JLabel();
        this.onLabel = new JLabel(new ImageIcon(this.getClass().getResource("/com/rbcapp/images/play.gif")), 0);
        this.offLabel = new JLabel();
        this.scanButton.setText("Open Scanner");
        this.scanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCWindow.this.scanButtonPressed();
            }
        });
        this.scanMenu.setText("Scanner");
        this.debugOutput.setEditable(false);
        this.logOutput.setEditable(false);
        this.viewCamera.setText("View Camera Output");
        this.viewCamera.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCWindow.this.toggleCameraWindow();
            }
        });
        this.viewCamera.setState(this.settings.viewCamera);
        this.viewMenu.add(this.viewCamera);
        this.viewLog.setText("View Log Output");
        this.viewLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCWindow.this.toggleLogView();
            }
        });
        this.viewLog.setState(this.settings.viewLog);
        this.viewMenu.add(this.viewLog);
        this.viewDebug = new JCheckBoxMenuItem();
        this.viewDebug.setText("View Debug Output");
        this.viewDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCWindow.this.toggleDebugView();
            }
        });
        this.viewDebug.setState(this.settings.viewDebug);
        this.viewMenu.add(this.viewDebug);
        this.viewDebugInput = new JCheckBoxMenuItem();
        this.viewDebugInput.setText("View Debug Input");
        this.viewDebugInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCWindow.this.toggleDebugInputView();
            }
        });
        this.viewDebugInput.setState(this.settings.viewDebugInput);
        this.viewMenu.add(this.viewDebugInput);
        this.menuBar1.add(this.viewMenu);
        this.clearDebug.setText("Clear Debug Output");
        this.clearDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCWindow.this.clearDebug();
            }
        });
        this.debugPopMenu.add(this.clearDebug);
        this.clearLog.setText("Clear Log Output");
        this.clearLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCWindow.this.clearLog();
            }
        });
        this.logPopMenu.add(this.clearLog);
        this.optionsMenu.setText("Options");
        this.setTimeStamp.setText("Timestamp Debug Output");
        this.setTimeStamp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCWindow.this.switchTimestamp();
            }
        });
        this.setTimeStamp.setState(this.settings.timeStamped);
        this.optionsMenu.add(this.setTimeStamp);
        this.optionsMenu.add(new JSeparator());
        this.robotAddresses.setText("Configure Robot Addresses");
        this.robotAddresses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCWindow.this.configureAddresses();
            }
        });
        this.optionsMenu.add(this.robotAddresses);
        this.changeSettings.setText("Change Settings");
        this.changeSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCWindow.this.openSettingWindow();
            }
        });
        this.optionsMenu.add(this.changeSettings);
        this.optionsMenu.add(this.sep);
        this.resetBlue.setText("Reset Bluetooth Connections");
        this.resetBlue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCWindow.this.stopButtonHit();
            }
        });
        this.optionsMenu.add(this.resetBlue);
        this.menuBar1.add(this.optionsMenu);
        this.plannerMenu.setText("Start");
        this.loadPlanner.setText("Load Planner");
        this.loadPlanner.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCWindow.this.loadPlanner();
            }
        });
        this.unloadPlanner.setText("Unload Planner");
        this.unloadPlanner.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCWindow.this.unloadPlanner();
            }
        });
        this.unloadPlanner.setEnabled(false);
        this.plannerMenu.add(this.loadPlanner);
        this.plannerMenu.add(this.unloadPlanner);
        this.plannerMenu.add(new JSeparator());
        this.stopButton.setIcon(new ImageIcon(this.getClass().getResource("/com/rbcapp/images/stop.gif")));
        this.stopButton.setText("Stop Robot");
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCWindow.this.stopButtonHit();
            }
        });
        this.startButton.setIcon(new ImageIcon(this.getClass().getResource("/com/rbcapp/images/play.gif")));
        this.startButton.setText("Start Robot");
        this.startButton.setEnabled(false);
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCWindow.this.startButtonHit();
            }
        });
        this.plannerMenu.add(this.startButton);
        this.plannerMenu.add(this.stopButton);
        this.menuBar1.add(this.plannerMenu);
        this.cameraMenu.setText("Camera");
        this.saveImage.setText("Save Current Camera Image");
        this.saveImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCWindow.this.saveCurrentImage();
            }
        });
        this.cameraMenu.add(this.saveImage);
        this.cameraMenu.add(new JSeparator());
        this.resetImage.setText("Reset Camera Image");
        this.resetImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RBCWindow.this.resetCurrentImage();
            }
        });
        this.cameraMenu.add(this.resetImage);
        this.menuBar1.add(this.cameraMenu);
        this.setJMenuBar(this.menuBar1);
        this.imagePanel.setIcon(new ImageIcon(CameraImage.getColorImaged(Color.BLACK)));
        this.cameraFrame.setLayout(new FlowLayout());
        this.cameraFrame.add(this.label2);
        this.cameraFrame.add(this.imagePanel);
        this.cameraFrame.setResizable(false);
        this.cameraFrame.setSize(180, 204);
        this.debugOutput.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    RBCWindow.this.debugPopMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.scrollPane1.setViewportView(this.debugOutput);
        this.logOutput.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    RBCWindow.this.logPopMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.scrollPane2.setViewportView(this.logOutput);
        this.label1.setText("Data Input (Press enter to send):");
        this.debugLabel.setText("Debug Output");
        this.label2.setText("Camera Output:");
        this.label2.setSize(15, 180);
        this.logLabel.setText("Log Output:");
        this.statusBar.setText("Robot Disconnected");
        this.statusBar.setForeground(Color.red);
        this.statusBar.setBorder(new BevelBorder(1));
        this.statusBar.setHorizontalTextPosition(10);
        this.statusBar.setHorizontalAlignment(0);
        this.statusBar2.setText("Planner Not Loaded");
        this.statusBar2.setForeground(Color.red);
        this.statusBar2.setBorder(new BevelBorder(1));
        this.statusBar2.setHorizontalTextPosition(10);
        this.statusBar2.setHorizontalAlignment(0);
        this.onLabel.setIcon(this.standbyIcon);
        this.offLabel.setIcon(this.offIcon);
        this.inputField.setEnabled(false);
        this.inputField.setToolTipText("Data to send to robot");
        this.inputField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    RBCWindow.this.enterHit();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.setTitle("RBCApp");
        this.setMinimumSize(this.getSize());
        this.addLogAndDebug();
        this.setLocationRelativeTo(this.getOwner());
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e) {
                RBCWindow.this.app.closed();
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.cameraFrame.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e) {
                RBCWindow.this.cameraWindowClosed();
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.setDefaultCloseOperation(3);
        if (this.settings.viewCamera) {
            this.toggleCameraWindow();
        } else {
            this.cameraWindowClosed();
        }
        if (!this.settings.viewLog) {
            this.settings.viewLog = true;
            this.toggleLogView();
        }
        if (!this.settings.viewDebug) {
            this.settings.viewDebug = true;
            this.toggleDebugView();
        }
        if (!this.settings.viewDebugInput) {
            this.settings.viewDebugInput = true;
            this.toggleDebugInputView();
        }
    }

    private void toggleCameraWindow() {
        if (this.cameraFrame.isVisible()) {
            this.cameraFrame.setVisible(false);
        } else {
            this.cameraFrame.setLocation(this.me.getX() + this.me.getWidth() + 5, this.me.getY() + 5);
            this.cameraFrame.setVisible(true);
            this.viewCamera.setState(true);
            this.cameraMenu.setVisible(true);
            this.settings.viewCamera = true;
            this.settings.saveSettings("settings.ini");
        }
    }

    private void toggleLogView() {
        if (this.settings.viewLog) {
            this.settings.viewLog = false;
            this.logLabel.setVisible(false);
            this.scrollPane2.setVisible(false);
            this.me.setSize(this.me.getWidth(), this.me.getHeight() - this.scrollPane2.getHeight() - this.logLabel.getHeight() - 6);
            this.settings.saveSettings("settings.ini");
        } else {
            this.settings.viewLog = true;
            this.logLabel.setVisible(true);
            this.scrollPane2.setVisible(true);
            if (this.settings.viewDebug) {
                this.me.setSize(this.me.getWidth(), this.me.getHeight() + this.scrollPane1.getHeight() + this.debugLabel.getHeight() + 12);
            } else {
                this.me.setSize(this.me.getWidth(), this.me.getHeight() + 249);
            }
            this.settings.saveSettings("settings.ini");
        }
    }

    private void toggleDebugView() {
        if (this.settings.viewDebug) {
            this.settings.viewDebug = false;
            this.debugLabel.setVisible(false);
            this.scrollPane1.setVisible(false);
            this.me.setSize(this.me.getWidth(), this.me.getHeight() - this.scrollPane1.getHeight() - this.debugLabel.getHeight() - 12);
            this.settings.saveSettings("settings.ini");
        } else {
            this.settings.viewDebug = true;
            this.debugLabel.setVisible(true);
            this.scrollPane1.setVisible(true);
            if (this.settings.viewLog) {
                this.me.setSize(this.me.getWidth(), this.me.getHeight() + this.scrollPane2.getHeight() + this.logLabel.getHeight() + 12);
            } else {
                this.me.setSize(this.me.getWidth(), this.me.getHeight() + 249);
            }
            this.settings.saveSettings("settings.ini");
        }
    }

    private void toggleDebugInputView() {
        if (this.settings.viewDebugInput) {
            this.settings.viewDebugInput = false;
            this.me.setSize(this.me.getWidth(), this.me.getHeight() - 40);
            this.label1.setVisible(false);
            this.inputField.setVisible(false);
            this.settings.saveSettings("settings.ini");
        } else {
            this.settings.viewDebugInput = true;
            this.me.setSize(this.me.getWidth(), this.me.getHeight() + 40);
            this.label1.setVisible(true);
            this.inputField.setVisible(true);
            this.settings.saveSettings("settings.ini");
        }
    }

    private void cameraWindowClosed() {
        this.viewCamera.setState(false);
        this.cameraMenu.setVisible(false);
        this.settings.viewCamera = false;
        this.settings.saveSettings("settings.ini");
    }

    private void addLogAndDebug() {
        Dimension dim = this.getSize();
        Container contentPane = new Container();
        this.setContentPane(contentPane);
        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPane.setLayout(contentPaneLayout);
        contentPaneLayout.setHorizontalGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addContainerGap().addGroup(contentPaneLayout.createParallelGroup().addComponent(this.label1).addComponent(this.inputField).addComponent(this.logLabel).addComponent(this.scrollPane2, -1, 449, Short.MAX_VALUE).addComponent(this.debugLabel).addComponent(this.scrollPane1, -1, 449, Short.MAX_VALUE).addGroup(contentPaneLayout.createSequentialGroup().addComponent(this.onLabel).addGap(3, 3, 3).addComponent(this.offLabel).addGap(3, 3, 3).addComponent(this.statusBar, -1, 200, Short.MAX_VALUE).addComponent(this.statusBar2, -1, 200, Short.MAX_VALUE))).addContainerGap()));
        contentPaneLayout.setVerticalGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label1)).addGap(4, 4, 4).addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.inputField, -2, 23, -2)).addGap(6, 6, 6).addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.logLabel)).addGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane2, -1, 218, Short.MAX_VALUE))).addGap(6, 6, 6).addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.debugLabel)).addGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane1, -1, 218, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.onLabel, -2, 25, -2).addComponent(this.offLabel, -2, 25, -2).addComponent(this.statusBar, -2, 25, -2).addComponent(this.statusBar2, -2, 25, -2)).addGap(4, 4, 4)));
        this.setSize(dim);
        this.pack();
    }

    public void appendDebugOutput(String output) {
        if (this.settings.timeStamped && this.newLine) {
            this.writeTimeStamp(this.debugOutput);
        }
        this.debugOutput.append(output);
    }

    public void appendLineDebugOutput(String output) {
        if (this.settings.timeStamped && this.newLine) {
            this.writeTimeStamp(this.debugOutput);
        }
        this.debugOutput.append(String.valueOf(output) + "\n");
        this.newLine = true;
        this.debugOutput.setCaretPosition(this.debugOutput.getText().length());
    }

    public void appendLogOutput(String output) {
        if (this.settings.timeStamped && this.newLine) {
            this.writeTimeStamp(this.logOutput);
        }
        this.logOutput.append(String.valueOf(output) + "\n");
        this.logOutput.setCaretPosition(this.logOutput.getText().length());
    }

    public void enterHit() {
        String input = this.inputField.getText();
        this.inputField.setText("");
        this.app.sendDebugData(input.getBytes());
    }

    public void setOutputImage(Image image) {
        this.imagePanel.setIcon(new ImageIcon(image));
    }

    public void changeStatusBar(String text, Color color) {
        this.statusBar.setText(text);
        this.statusBar.setForeground(color);
    }

    public void robotConnected() {
        this.statusBar.setText("Robot Connected ");
        this.startButton.setEnabled(true);
        this.statusBar.setForeground(Color.GREEN.darker().darker());
    }

    public void enableStartButton() {
        this.startButton.setEnabled(true);
    }

    public void robotDisconnected() {
        this.statusBar.setText("Robot Disconnected ");
        this.statusBar.setForeground(Color.RED);
        this.plannerStopped();
        this.disableInput();
        this.startButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.plannerMenu.setText("Start");
        this.toggleOnOff(false);
    }

    private void writeTimeStamp(JTextArea area) {
        area.append("[" + new Time(System.currentTimeMillis()) + "] ");
        this.newLine = false;
    }

    public void toggleOnOff(boolean on) {
        if (on) {
            this.onLabel.setIcon(this.onIcon);
            this.offLabel.setIcon(this.standbyIcon);
        } else {
            this.onLabel.setIcon(this.standbyIcon);
            this.offLabel.setIcon(this.offIcon);
        }
    }

    private void startButtonHit() {
        if (this.usingEasyBlue) {
            Integer id = new Integer(this.settings.robotId);
            String url = this.settings.robotAddresses.get(id);
            if (url == null || url == "") {
                JOptionPane.showMessageDialog(null, "ERROR: The robot you are trying to connect to (Robot " + id + ") does not have a Bluetooth address associated to it.", "Error Connecting to Robot", 0);
                return;
            }
            this.scanButton.setEnabled(false);
            String url2 = "btspp://" + url + ":" + this.settings.comPort + ";authenticate=false;encrypt=false;master=false";
            this.app.setURL(url2);
            this.app.connectBluetooth();
        }
        if (this.app.startButtonHit()) {
            this.setTitle(String.valueOf(this.getTitle()) + " - Planner Started");
            this.plannerStarted();
        }
        this.toggleOnOff(true);
        this.stopButton.setEnabled(true);
        this.startButton.setEnabled(false);
        this.plannerMenu.setText("Stop");
    }

    private void stopButtonHit() {
        this.stopButton.setEnabled(false);
        if (this.app.stopButtonHit()) {
            this.setTitle(this.getTitle().substring(0, this.getTitle().length() - 18));
        }
        this.scanButton.setEnabled(true);
        this.app.resetBluetooth();
        this.disableInput();
        this.startButton.setEnabled(true);
        if (!this.usingEasyBlue) {
            this.app.connectBluetooth();
            this.startButton.setEnabled(false);
        }
        this.toggleOnOff(false);
        this.plannerMenu.setText("Start");
    }

    private void openSettingWindow() {
        RBCSettingsWindow window = new RBCSettingsWindow(this.settings);
        window.setVisible(true);
    }

    private void unloadPlanner() {
        this.app.unloadPlanner();
        this.setTitle("RBCApp");
        this.unloadPlanner.setEnabled(false);
        this.loadPlanner.setText("Load Planner");
        this.loadPlanner.setEnabled(true);
        this.stopButton.setText("Stop Robot");
        this.startButton.setText("Start Robot");
        this.plannerLoaded = false;
        this.statusBar2.setText("Planner not loaded");
        this.statusBar2.setForeground(Color.RED);
    }

    private void loadPlanner() {
        JFileChooser chooser = new JFileChooser(new File("."));
        chooser.setDialogTitle("Choose Precompiled Planner Class File");
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(new ClassFileFilter());
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            if (!this.app.loadPlanner(chooser.getSelectedFile())) {
                JOptionPane.showMessageDialog(null, "ERROR: Unable to load planner from " + chooser.getSelectedFile().getAbsolutePath() + ".", "Error Opening Planner", 0);
                return;
            }
            this.loadPlanner.setText("Planner Loaded (" + chooser.getSelectedFile().getName() + ")");
            this.loadPlanner.setEnabled(false);
            this.stopButton.setText("Stop Robot");
            this.startButton.setText("Start Robot");
            this.unloadPlanner.setEnabled(true);
            this.setTitle("RBCApp - Planner Loaded (" + chooser.getSelectedFile().getName() + ")");
            this.plannerLoaded = true;
            this.statusBar2.setText("Planner Loaded");
            this.statusBar2.setForeground(Color.YELLOW.darker().darker());
        }
    }

    private void plannerStarted() {
        this.statusBar2.setText("Planner Started");
        this.statusBar2.setForeground(Color.GREEN.darker().darker());
    }

    private void plannerStopped() {
        if (this.plannerLoaded) {
            this.statusBar2.setText("Planner Loaded");
            this.statusBar2.setForeground(Color.YELLOW.darker().darker());
        } else {
            this.statusBar2.setText("Planner not loaded");
            this.statusBar2.setForeground(Color.RED);
        }
    }

    public void clearDebug() {
        this.debugOutput.setText("");
        this.newLine = true;
    }

    public void clearLog() {
        this.logOutput.setText("");
    }

    public void enableScan() {
        this.scanMenu.add(this.scanButton);
        this.menuBar1.add(this.scanMenu);
        this.pack();
    }

    public void enableRobotConnection() {
        this.resetBlue.setVisible(false);
        this.startButton.setEnabled(true);
        this.sep.setVisible(false);
        this.usingEasyBlue = true;
    }

    public void enableInput() {
        this.inputField.setEnabled(true);
    }

    public void disableInput() {
        this.inputField.setEnabled(false);
        this.inputField.setText("");
    }

    public void configureAddresses() {
        RBCBluetoothAddsWindow win = new RBCBluetoothAddsWindow(this.settings);
        win.setVisible(true);
    }

    private void scanButtonPressed() {
        ScannerWindow newWin = new ScannerWindow(this);
        newWin.setVisible(true);
    }

    private void resetCurrentImage() {
        this.imagePanel.setIcon(new ImageIcon(CameraImage.getColorImaged(Color.BLACK)));
    }

    private void saveCurrentImage() {
        try {
            ImageIcon icon = (ImageIcon)this.imagePanel.getIcon();
            JFileChooser chooser = new JFileChooser(new File("."));
            chooser.setDialogTitle("Save current camera image");
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.addChoosableFileFilter(new ImageFileFilter());
            int returnVal = chooser.showSaveDialog(null);
            if (returnVal == 0) {
                if (chooser.getSelectedFile().exists() && JOptionPane.showConfirmDialog(this, "Replace existing file?") != 0) {
                    return;
                }
                ImageIO.write((RenderedImage)((BufferedImage)icon.getImage()), new ImageFileFilter().getExtension(chooser.getSelectedFile()), chooser.getSelectedFile());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "ERROR: Unable to save camera image to.", "Error Saving Camera Image", 0);
        }
    }

    private void switchTimestamp() {
        this.settings.timeStamped = !this.settings.timeStamped;
        this.settings.saveSettings("settings.ini");
    }

    public class ClassFileFilter
    extends FileFilter {
        @Override
        public String getDescription() {
            return "Java Class File";
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            return extension != null && extension.equals("class");
        }

        private String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }

    public class ImageFileFilter
    extends FileFilter {
        @Override
        public String getDescription() {
            return "Image File (jpg; jpeg; png)";
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            return extension != null && (extension.equals("jpg") || extension.equals("jpeg") || extension.equals("png"));
        }

        private String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }

    public class ScannerWindow
    extends JFrame {
        private static final long serialVersionUID = -2387528471242720060L;
        private JList deviceList;
        private BluetoothDeviceFinder deviceFinder;
        private JTextField statusPane;
        private JButton scanButton;
        private RBCWindow win;
        private JButton addButton;

        public ScannerWindow(RBCWindow wind) {
            super("Scanner");
            this.win = wind;
            this.deviceFinder = new BluetoothDeviceFinder();
            this.setLayout(new FlowLayout());
            JLabel label = new JLabel("Available Bluetooth Devices");
            label.setPreferredSize(new Dimension(580, 20));
            this.add(label);
            this.statusPane = new JTextField("Press SCAN to scan for Bluetooth devices.");
            this.statusPane.setEnabled(false);
            this.statusPane.setBackground(Color.DARK_GRAY);
            this.statusPane.setForeground(Color.WHITE);
            this.statusPane.setPreferredSize(new Dimension(580, 20));
            this.deviceList = new JList();
            this.deviceList.setSelectionMode(0);
            JScrollPane scrollPane = new JScrollPane(this.deviceList, 22, 30);
            scrollPane.setPreferredSize(new Dimension(580, 150));
            this.add(scrollPane);
            this.addButton = new JButton("Add Selection To List Of Robots");
            this.addButton.setEnabled(false);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScannerWindow.this.addButtonHit();
                }
            });
            this.add(this.addButton);
            this.add(this.statusPane);
            this.scanButton = new JButton("Scan");
            this.scanButton.setEnabled(true);
            this.scanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScannerWindow.this.scanButtonHit();
                }
            });
            this.add(this.scanButton);
            this.setSize(600, 310);
            this.setLocationRelativeTo(this.getOwner());
            this.setResizable(false);
        }

        private void scanButtonHit() {
            this.statusPane.setText("Scanning for Bluetooth devices...");
            this.statusPane.update(this.statusPane.getGraphics());
            this.scan();
        }

        private void addButtonHit() {
            if (this.deviceList.getSelectedIndex() > -1) {
                String address = ((String)this.deviceList.getSelectedValue()).split(" ")[0];
                String input = JOptionPane.showInputDialog(this, (Object)"Enter the robot's id:");
                try {
                    int id = Integer.parseInt(input);
                    Integer idI = new Integer(id);
                    this.win.settings.robotAddresses.put(idI, address);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "ERROR: The robot's id must be an integer.", "Error Adding Robot", 0);
                }
            }
        }

        private void scan() {
            Vector<String> urls = this.deviceFinder.scanForBtDevice();
            if (urls != null) {
                this.deviceList.setListData(urls);
                if (urls.size() < 1) {
                    this.statusPane.setText("No Bluetooth devices found.");
                } else {
                    this.statusPane.setText("Press CONNECT to connect to the Bluetooth device.");
                    this.scanButton.setEnabled(false);
                    this.addButton.setEnabled(true);
                }
            } else {
                this.deviceList.setListData(new Vector());
                this.statusPane.setText("No Bluetooth devices found.");
            }
            this.deviceList.update(this.deviceList.getGraphics());
            this.statusPane.update(this.statusPane.getGraphics());
        }
    }
}

