/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.io.DataInputStream;
import java.util.ArrayDeque;
import server.Client;
import server.ClientOutputSignalQueue;
import server.Server;
import server.SystemManager;
import shared.ByteStream;
import signal.BlockStateChangeSignal;
import signal.BroadcastTrackerImageSignal;
import signal.PotStateChangeSignal;
import signal.ReceiveTrackerNumberSignal;
import signal.ReplyTrackerImageSignal;
import signal.RequestTrackerImageSignal;
import signal.RobotStateChangeSignal;
import signal.Signal;
import signal.SignalType;
import signal.TaskCompletedSignal;
import signal.TaskStartedSignal;
import signal.UpdateActualRobotPositionSignal;
import signal.UpdateBlockPositionSignal;
import signal.UpdateEstimatedRobotPositionSignal;
import signal.UpdatePotPositionSignal;

public class ClientInputSignalQueue
extends Thread {
    private ArrayDeque<Signal> m_inSignalQueue = new ArrayDeque();
    private DataInputStream m_in;
    private ClientOutputSignalQueue m_outSignalQueue;
    private Server m_server;
    private Client m_client;

    public void initialize(Server server, Client client, DataInputStream in, ClientOutputSignalQueue out) {
        this.m_server = server;
        this.m_client = client;
        this.m_in = in;
        this.m_outSignalQueue = out;
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    public boolean isTerminated() {
        return this.getState() == Thread.State.TERMINATED;
    }

    public void addSignal(Signal s) {
        if (s == null) {
            return;
        }
        this.m_inSignalQueue.add(s);
    }

    private void sendSignal(Signal s) {
        if (s == null) {
            return;
        }
        this.m_outSignalQueue.addSignal(s);
    }

    public void readSignal() {
        if (!this.m_client.isConnected()) {
            return;
        }
        Signal s = Signal.readFrom(ByteStream.readFrom(this.m_in, 12));
        Signal s2 = null;
        if (s == null) {
            return;
        }
        if (s.getSignalType() == 0) {
            s2 = s;
        } else if (s.getSignalType() == 1) {
            s2 = s;
        } else if (s.getSignalType() == 2) {
            s2 = s;
        } else if (s.getSignalType() == 3) {
            s2 = BlockStateChangeSignal.readFrom(ByteStream.readFrom(this.m_in, 11));
        } else if (s.getSignalType() == 4) {
            s2 = RobotStateChangeSignal.readFrom(ByteStream.readFrom(this.m_in, 10));
        } else if (s.getSignalType() == 5) {
            s2 = PotStateChangeSignal.readFrom(ByteStream.readFrom(this.m_in, 11));
        } else if (s.getSignalType() == 6) {
            s2 = TaskStartedSignal.readFrom(ByteStream.readFrom(this.m_in, 10));
        } else if (s.getSignalType() == 7) {
            s2 = TaskCompletedSignal.readFrom(ByteStream.readFrom(this.m_in, 10));
        } else if (s.getSignalType() == 8) {
            s2 = UpdateBlockPositionSignal.readFrom(ByteStream.readFrom(this.m_in, 17));
        } else if (s.getSignalType() == 9) {
            s2 = UpdatePotPositionSignal.readFrom(ByteStream.readFrom(this.m_in, 17));
        } else if (s.getSignalType() == 10) {
            s2 = UpdateActualRobotPositionSignal.readFrom(ByteStream.readFrom(this.m_in, 21));
        } else if (s.getSignalType() == 11) {
            s2 = UpdateEstimatedRobotPositionSignal.readFrom(ByteStream.readFrom(this.m_in, 21));
        } else if (s.getSignalType() == 12) {
            s2 = RequestTrackerImageSignal.readFrom(ByteStream.readFrom(this.m_in, 9));
        } else if (s.getSignalType() == 13) {
            s2 = ReplyTrackerImageSignal.readFrom(ByteStream.readFrom(this.m_in, 14), this.m_in);
        } else if (s.getSignalType() == 14) {
            s2 = BroadcastTrackerImageSignal.readFrom(ByteStream.readFrom(this.m_in, 13), this.m_in);
        } else if (s.getSignalType() == 15) {
            s2 = ReceiveTrackerNumberSignal.readFrom(ByteStream.readFrom(this.m_in, 9));
        } else {
            SystemManager.console.writeLine("Unexpected input signal of type: " + s.getSignalType());
        }
        this.addSignal(s2);
    }

    @Override
    public void run() {
        while (this.m_client.isConnected()) {
            if (!this.m_inSignalQueue.isEmpty()) {
                Signal s = this.m_inSignalQueue.remove();
                if (!(SystemManager.settings.getSignalDebugLevel() != 1 && SystemManager.settings.getSignalDebugLevel() != 3 || SystemManager.settings.getIgnorePingPongSignals() && (s.getSignalType() == 0 || s.getSignalType() == 1) && SystemManager.settings.getIgnorePingPongSignals() || SystemManager.settings.getIgnorePositionSignals() && (s.getSignalType() == 10 || s.getSignalType() == 11 || s.getSignalType() == 8 || s.getSignalType() == 9) && SystemManager.settings.getIgnorePositionSignals())) {
                    SystemManager.console.writeLine("Received from " + this.m_client.getName() + ": " + s.toString());
                }
                if (s.getSignalType() == 0) {
                    this.sendSignal(new Signal(1));
                }
                if (s.getSignalType() == 1) {
                    this.m_client.pong();
                } else if (s.getSignalType() == 13) {
                    ReplyTrackerImageSignal s2 = (ReplyTrackerImageSignal)s;
                    if (this.m_client.isIdentified()) {
                        this.m_server.forwardToTracker(this.m_client.getTrackerNumber(), s2.getDestinationTrackerNumber(), s);
                    }
                } else if (SignalType.isValid(s.getSignalType())) {
                    if (this.m_client.isIdentified()) {
                        this.m_server.forwardSignal(this.m_client.getClientNumber(), s);
                    }
                } else {
                    SystemManager.console.writeLine("Unexpected input signal of type: " + s.getSignalType());
                }
            }
            try {
                ClientInputSignalQueue.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

