/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.io.DataOutputStream;
import java.util.ArrayDeque;
import server.Client;
import server.SystemManager;
import signal.Signal;
import signal.SignalType;

public class ClientOutputSignalQueue
extends Thread {
    private ArrayDeque<Signal> m_outSignalQueue = new ArrayDeque();
    private DataOutputStream m_out;
    private Client m_client;

    public void initialize(Client client, DataOutputStream out) {
        this.m_client = client;
        this.m_out = out;
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    public boolean isTerminated() {
        return this.getState() == Thread.State.TERMINATED;
    }

    public void addSignal(Signal s) {
        if (s == null) {
            return;
        }
        this.m_outSignalQueue.add(s);
    }

    @Override
    public void run() {
        while (this.m_client.isConnected()) {
            if (!this.m_outSignalQueue.isEmpty()) {
                Signal s = this.m_outSignalQueue.remove();
                if (!(SystemManager.settings.getSignalDebugLevel() != 2 && SystemManager.settings.getSignalDebugLevel() != 3 || SystemManager.settings.getIgnorePingPongSignals() && (s.getSignalType() == 0 || s.getSignalType() == 1) && SystemManager.settings.getIgnorePingPongSignals() || SystemManager.settings.getIgnorePositionSignals() && (s.getSignalType() == 10 || s.getSignalType() == 11 || s.getSignalType() == 8 || s.getSignalType() == 9) && SystemManager.settings.getIgnorePositionSignals())) {
                    SystemManager.console.writeLine("Sending to " + this.m_client.getName() + ": " + s.toString());
                }
                if (SignalType.isValid(s.getSignalType())) {
                    s.writeTo(this.m_out);
                } else {
                    SystemManager.console.writeLine("Unexpected output signal of type: " + s.getSignalType());
                }
            }
            try {
                ClientOutputSignalQueue.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

