/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ByteStream {
    private byte[] m_data;
    private int m_length = 0;
    private int m_position = 0;
    private int m_initialCapacity;
    public static final int DEFAULT_CAPACITY = 64;
    public static final int CAPACITY_INCREMENT = 32;
    public static final String DEFAULT_IMAGE_FORMAT = "jpg";

    public ByteStream() {
        this.m_data = new byte[64];
        this.m_initialCapacity = 64;
    }

    public ByteStream(int initialCapacity) {
        this.m_initialCapacity = initialCapacity > 0 ? initialCapacity : 64;
        this.m_data = new byte[this.m_initialCapacity];
    }

    public int size() {
        return this.m_length;
    }

    public byte[] getContents() {
        return this.m_data;
    }

    public void clear() {
        this.m_data = new byte[this.m_initialCapacity];
        this.m_length = 0;
    }

    public void resetPosition() {
        this.m_position = 0;
    }

    public int getPosition() {
        return this.m_position;
    }

    public void setPosition(int offset) {
        if (offset < 0 || offset >= this.m_length) {
            return;
        }
        this.m_position = offset;
    }

    public void addBoolean(boolean b) {
        this.addByte((byte)(b ? 1 : 0));
    }

    public void addByte(byte b) {
        this.m_data[this.m_length] = b;
        ++this.m_length;
        this.checkCapacity();
    }

    public void addShort(short s) {
        this.addByte((byte)(s >> 8));
        this.addByte((byte)s);
    }

    public void addInteger(int i) {
        this.addByte((byte)(i >> 24));
        this.addByte((byte)(i >> 16));
        this.addByte((byte)(i >> 8));
        this.addByte((byte)i);
    }

    public void addLong(long l) {
        this.addByte((byte)(l >> 56));
        this.addByte((byte)(l >> 48));
        this.addByte((byte)(l >> 40));
        this.addByte((byte)(l >> 32));
        this.addByte((byte)(l >> 24));
        this.addByte((byte)(l >> 16));
        this.addByte((byte)(l >> 8));
        this.addByte((byte)l);
    }

    public void addFloat(float f) {
        this.addInteger(Float.floatToIntBits(f));
    }

    public void addDouble(double d) {
        this.addLong(Double.doubleToLongBits(d));
    }

    public void addChar(char c) {
        this.addByte((byte)(c >> 8));
        this.addByte((byte)c);
    }

    public void addString(String s) {
        if (s == null) {
            return;
        }
        int i = 0;
        while (i < s.length()) {
            this.addChar(s.charAt(i));
            ++i;
        }
    }

    public void addStringFixedLength(String s, int length) {
        if (s == null) {
            return;
        }
        int tempLength = s.length() > length ? length : s.length();
        int i = 0;
        while (i < tempLength) {
            this.addChar(s.charAt(i));
            ++i;
        }
        i = s.length();
        while (i < length) {
            this.addChar('\u0000');
            ++i;
        }
    }

    public void addBufferedImage(BufferedImage image) {
        if (image == null) {
            this.addInteger(0);
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, DEFAULT_IMAGE_FORMAT, baos);
        }
        catch (IOException e) {
            return;
        }
        byte[] data = baos.toByteArray();
        this.addInteger(data.length);
        int i = 0;
        while (i < data.length) {
            this.addByte(data[i]);
            ++i;
        }
    }

    public boolean getBoolean(int offset) {
        return this.getByte(offset) != 0;
    }

    public byte getByte(int offset) {
        return offset < 0 || offset >= this.m_data.length ? (byte)-1 : this.m_data[offset];
    }

    public short getShort(int offset) {
        if (offset < 0 || offset + 1 >= this.m_data.length) {
            return -1;
        }
        return (short)(this.m_data[offset] << 8 | this.m_data[offset + 1] & 0xFF);
    }

    public int getInteger(int offset) {
        if (offset < 0 || offset + 3 >= this.m_data.length) {
            return -1;
        }
        return this.m_data[offset] << 24 | (this.m_data[offset + 1] & 0xFF) << 16 | (this.m_data[offset + 2] & 0xFF) << 8 | this.m_data[offset + 3] & 0xFF;
    }

    public long getLong(int offset) {
        if (offset < 0 || offset + 7 >= this.m_data.length) {
            return -1L;
        }
        long l = 0L;
        int i = 0;
        while (i < 8) {
            l |= ((long)this.m_data[i + offset] & 0xFFL) << (8 - i - 1 << 3);
            ++i;
        }
        return l;
    }

    public float getFloat(int offset) {
        if (offset < 0 || offset + 3 >= this.m_data.length) {
            return -1.0f;
        }
        return Float.intBitsToFloat(this.getInteger(offset));
    }

    public double getDouble(int offset) {
        if (offset < 0 || offset + 7 >= this.m_data.length) {
            return -1.0;
        }
        return Double.longBitsToDouble(this.getLong(offset));
    }

    public char getChar(int offset) {
        if (offset < 0 || offset + 1 >= this.m_data.length) {
            return '\u0000';
        }
        return (char)(this.m_data[offset] << 8 | this.m_data[offset + 1] & 0xFF);
    }

    public String getString(int offset, int length) {
        if (length < 0 || offset < 0 || offset + (length - 1) * 2 >= this.m_data.length) {
            return null;
        }
        String s = "";
        int i = 0;
        while (i < length) {
            char c = this.getChar(offset + i * 2);
            if (c == '\u0000') break;
            s = String.valueOf(s) + c;
            ++i;
        }
        return s;
    }

    public BufferedImage getBufferedImage(int offset) {
        BufferedImage image;
        if (offset < 0 || offset + 4 >= this.m_data.length) {
            return null;
        }
        int length = this.getInteger(offset);
        byte[] data = new byte[length];
        if ((offset += 4) + length >= this.m_data.length) {
            return null;
        }
        int i = 0;
        while (i < length) {
            data[i] = this.getByte(offset);
            ++offset;
            ++i;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            image = ImageIO.read(in);
        }
        catch (Exception e) {
            return null;
        }
        return image;
    }

    public BufferedImage getBufferedImage(int offset, int length) {
        BufferedImage image;
        if (offset + length >= this.m_data.length) {
            return null;
        }
        byte[] data = new byte[length];
        int i = 0;
        while (i < length) {
            data[i] = this.getByte(offset);
            ++offset;
            ++i;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            image = ImageIO.read(in);
        }
        catch (Exception e) {
            return null;
        }
        return image;
    }

    public boolean nextBoolean() {
        boolean b = this.getBoolean(this.m_position);
        ++this.m_position;
        return b;
    }

    public byte nextByte() {
        byte b = this.getByte(this.m_position);
        ++this.m_position;
        return b;
    }

    public short nextShort() {
        short s = this.getShort(this.m_position);
        this.m_position += 2;
        return s;
    }

    public int nextInteger() {
        int i = this.getInteger(this.m_position);
        this.m_position += 4;
        return i;
    }

    public long nextLong() {
        long l = this.getLong(this.m_position);
        this.m_position += 8;
        return l;
    }

    public double nextFloat() {
        float f = this.getFloat(this.m_position);
        this.m_position += 4;
        return f;
    }

    public double nextDouble() {
        double d = this.getDouble(this.m_position);
        this.m_position += 8;
        return d;
    }

    public char nextChar() {
        char c = this.getChar(this.m_position);
        this.m_position += 2;
        return c;
    }

    public String nextString(int length) {
        String s = this.getString(this.m_position, length);
        if (length > 0) {
            this.m_position += 2 * length;
        }
        return s;
    }

    public BufferedImage nextBufferedImage() {
        BufferedImage image;
        if (this.m_position + 4 >= this.m_data.length) {
            return null;
        }
        int length = this.getInteger(this.m_position);
        this.m_position += 4;
        byte[] data = new byte[length];
        if (this.m_position + length >= this.m_data.length) {
            return null;
        }
        int i = 0;
        while (i < length) {
            data[i] = this.getByte(this.m_position);
            ++this.m_position;
            ++i;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            image = ImageIO.read(in);
        }
        catch (Exception e) {
            return null;
        }
        return image;
    }

    public BufferedImage nextBufferedImage(int length) {
        if (length <= 0 || this.m_position + length >= this.m_data.length) {
            return null;
        }
        byte[] data = new byte[length];
        int i = 0;
        while (i < length) {
            data[i] = this.nextByte();
            ++i;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        BufferedImage image = null;
        try {
            image = ImageIO.read(in);
        }
        catch (Exception e) {
            return null;
        }
        return image;
    }

    public static long getChecksum(boolean b) {
        return b ? 1 : 0;
    }

    public static long getChecksum(byte b) {
        long checksum = 0L;
        int i = 0;
        while (i < 8) {
            if ((b & (int)Math.pow(2.0, i)) > 0) {
                ++checksum;
            }
            ++i;
        }
        return checksum;
    }

    public static long getChecksum(short s) {
        long checksum = 0L;
        checksum += ByteStream.getChecksum((byte)(s >> 8));
        return checksum += ByteStream.getChecksum((byte)s);
    }

    public static long getChecksum(int i) {
        long checksum = 0L;
        checksum += ByteStream.getChecksum((byte)(i >> 24));
        checksum += ByteStream.getChecksum((byte)(i >> 16));
        checksum += ByteStream.getChecksum((byte)(i >> 8));
        return checksum += ByteStream.getChecksum((byte)i);
    }

    public static long getChecksum(long l) {
        long checksum = 0L;
        checksum += ByteStream.getChecksum((byte)(l >> 56));
        checksum += ByteStream.getChecksum((byte)(l >> 48));
        checksum += ByteStream.getChecksum((byte)(l >> 40));
        checksum += ByteStream.getChecksum((byte)(l >> 32));
        checksum += ByteStream.getChecksum((byte)(l >> 24));
        checksum += ByteStream.getChecksum((byte)(l >> 16));
        checksum += ByteStream.getChecksum((byte)(l >> 8));
        return checksum += ByteStream.getChecksum((byte)l);
    }

    public static long getChecksum(float f) {
        return ByteStream.getChecksum(Float.floatToIntBits(f));
    }

    public static long getChecksum(double d) {
        return ByteStream.getChecksum(Double.doubleToLongBits(d));
    }

    public static long getChecksum(char c) {
        long checksum = 0L;
        checksum += ByteStream.getChecksum((byte)(c >> 8));
        return checksum += ByteStream.getChecksum((byte)c);
    }

    public static long getChecksum(String s) {
        if (s == null || s.length() == 0) {
            return 0L;
        }
        long checksum = 0L;
        int i = 0;
        while (i < s.length()) {
            checksum += ByteStream.getChecksum(s.charAt(i));
            ++i;
        }
        return checksum;
    }

    public static long getChecksum(String s, int length) {
        if (s == null || s.length() == 0) {
            return 0L;
        }
        long checksum = 0L;
        int tempLength = s.length() > length ? length : s.length();
        int i = 0;
        while (i < tempLength) {
            checksum += ByteStream.getChecksum(s.charAt(i));
            ++i;
        }
        return checksum;
    }

    public static long getChecksum(BufferedImage img) {
        if (img == null) {
            return 0L;
        }
        long checksum = 0L;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, DEFAULT_IMAGE_FORMAT, baos);
        }
        catch (IOException e) {
            return 0L;
        }
        byte[] data = baos.toByteArray();
        checksum += ByteStream.getChecksum(data.length);
        int i = 0;
        while (i < data.length) {
            checksum += ByteStream.getChecksum(data[i]);
            ++i;
        }
        return checksum;
    }

    public long checksum() {
        long checksum = 0L;
        int i = 0;
        while (i < this.m_length) {
            checksum += ByteStream.getChecksum(this.m_data[i]);
            ++i;
        }
        return checksum;
    }

    private void checkCapacity() {
        if (this.m_length < this.m_data.length) {
            return;
        }
        byte[] temp = new byte[this.m_data.length + 32];
        int i = 0;
        while (i < this.m_data.length) {
            temp[i] = this.m_data[i];
            ++i;
        }
        this.m_data = temp;
    }

    public static ByteStream readFrom(DataInputStream in, int length) {
        long startTime;
        ByteStream bs;
        block5: {
            if (in == null || length < 1) {
                return null;
            }
            bs = new ByteStream(length);
            startTime = System.currentTimeMillis();
            if (in.available() > 0) break block5;
            return null;
        }
        try {
            while (in.available() < length && startTime + 8000L > System.currentTimeMillis()) {
            }
            in.read(bs.getContents(), 0, length);
        }
        catch (IOException e) {
            return null;
        }
        return bs;
    }

    public boolean writeTo(DataOutputStream out) {
        if (out == null) {
            return false;
        }
        try {
            out.write(this.m_data, 0, this.m_length);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

