/*
 * Decompiled with CFR 0.152.
 */
package shared;

public class SignalDebugLevel {
    public static final byte Off = 0;
    public static final byte Incoming = 1;
    public static final byte Outgoing = 2;
    public static final byte Both = 3;
    public static final String[] signalDebugLevels = new String[]{"Off", "Incoming", "Outgoing", "Both"};

    public static boolean isValid(byte debugLevel) {
        return debugLevel >= 0 && debugLevel < signalDebugLevels.length;
    }

    public static byte parseFrom(String data) {
        if (data == null) {
            return -1;
        }
        String temp = data.trim();
        byte i = 0;
        while (i < signalDebugLevels.length) {
            if (temp.equalsIgnoreCase(signalDebugLevels[i])) {
                return i;
            }
            i = (byte)(i + 1);
        }
        return -1;
    }

    public static String toString(byte debugLevel) {
        return !SignalDebugLevel.isValid(debugLevel) ? "Invalid" : signalDebugLevels[debugLevel];
    }
}

