/*
 * Decompiled with CFR 0.152.
 */
package signal;

import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import shared.ByteStream;
import signal.Signal;

public class BroadcastTrackerImageSignal
extends Signal {
    private byte m_sourceTrackerNumber;
    private BufferedImage m_sourceTrackerImage;
    public static final int LENGTH = 13;

    private BroadcastTrackerImageSignal() {
        super(14);
    }

    public BroadcastTrackerImageSignal(byte sourceTrackerNumber, BufferedImage sourceTrackerImage) {
        super(14);
        this.m_sourceTrackerNumber = sourceTrackerNumber;
        this.m_sourceTrackerImage = sourceTrackerImage;
    }

    public byte getSourceTrackerNumber() {
        return this.m_sourceTrackerNumber;
    }

    public BufferedImage getSourceTrackerImage() {
        return this.m_sourceTrackerImage;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_sourceTrackerNumber);
        return checksum += ByteStream.getChecksum(this.m_sourceTrackerImage);
    }

    public static BroadcastTrackerImageSignal readFrom(ByteStream byteStream, DataInputStream in) {
        if (byteStream == null) {
            return null;
        }
        BroadcastTrackerImageSignal s2 = new BroadcastTrackerImageSignal();
        s2.m_sourceTrackerNumber = byteStream.nextByte();
        byteStream.nextLong();
        int dataLength = byteStream.nextInteger();
        ByteStream imageStream = ByteStream.readFrom(in, dataLength);
        if (imageStream == null) {
            return null;
        }
        s2.m_sourceTrackerImage = imageStream.nextBufferedImage(dataLength);
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addByte(this.m_sourceTrackerNumber);
        byteStream.addLong(this.checksum());
        byteStream.addBufferedImage(this.m_sourceTrackerImage);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " Source Tracker ID: " + this.m_sourceTrackerNumber;
    }
}

