/*
 * Decompiled with CFR 0.152.
 */
package signal;

import pot.PotState;
import shared.ByteStream;
import signal.Signal;

public class PotStateChangeSignal
extends Signal {
    private byte m_potID;
    private byte m_robotID;
    private byte m_potState;
    public static final int LENGTH = 11;

    private PotStateChangeSignal() {
        super(5);
    }

    public PotStateChangeSignal(byte potID, byte robotID, byte potState) {
        super(5);
        this.m_potID = potID;
        this.m_robotID = robotID;
        this.m_potState = potState;
    }

    public byte getPotID() {
        return this.m_potID;
    }

    public byte getRobotID() {
        return this.m_robotID;
    }

    public byte getPotState() {
        return this.m_potState;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_potID);
        checksum += ByteStream.getChecksum(this.m_robotID);
        return checksum += ByteStream.getChecksum(this.m_potState);
    }

    public static PotStateChangeSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        PotStateChangeSignal s2 = new PotStateChangeSignal();
        s2.m_potID = byteStream.nextByte();
        s2.m_robotID = byteStream.nextByte();
        s2.m_potState = byteStream.nextByte();
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addByte(this.m_potID);
        byteStream.addByte(this.m_robotID);
        byteStream.addByte(this.m_potState);
        byteStream.addLong(this.checksum());
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " Pot ID: " + this.m_potID + " Robot ID: " + this.m_robotID + " Pot State " + PotState.toString(this.m_potState);
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return PotStateChangeSignal.readFrom(byteStream);
    }
}

